// SPDX-License-Identifier: Apache-2.0
// Copyright 2017-2021 Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"
	"time"

	v2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// CiliumClusterwideNetworkPoliciesGetter has a method to return a CiliumClusterwideNetworkPolicyInterface.
// A group's client should implement this interface.
type CiliumClusterwideNetworkPoliciesGetter interface {
	CiliumClusterwideNetworkPolicies() CiliumClusterwideNetworkPolicyInterface
}

// CiliumClusterwideNetworkPolicyInterface has methods to work with CiliumClusterwideNetworkPolicy resources.
type CiliumClusterwideNetworkPolicyInterface interface {
	Create(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.CreateOptions) (*v2.CiliumClusterwideNetworkPolicy, error)
	Update(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.UpdateOptions) (*v2.CiliumClusterwideNetworkPolicy, error)
	UpdateStatus(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.UpdateOptions) (*v2.CiliumClusterwideNetworkPolicy, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.CiliumClusterwideNetworkPolicy, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.CiliumClusterwideNetworkPolicyList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumClusterwideNetworkPolicy, err error)
	CiliumClusterwideNetworkPolicyExpansion
}

// ciliumClusterwideNetworkPolicies implements CiliumClusterwideNetworkPolicyInterface
type ciliumClusterwideNetworkPolicies struct {
	client rest.Interface
}

// newCiliumClusterwideNetworkPolicies returns a CiliumClusterwideNetworkPolicies
func newCiliumClusterwideNetworkPolicies(c *CiliumV2Client) *ciliumClusterwideNetworkPolicies {
	return &ciliumClusterwideNetworkPolicies{
		client: c.RESTClient(),
	}
}

// Get takes name of the ciliumClusterwideNetworkPolicy, and returns the corresponding ciliumClusterwideNetworkPolicy object, and an error if there is any.
func (c *ciliumClusterwideNetworkPolicies) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2.CiliumClusterwideNetworkPolicy, err error) {
	result = &v2.CiliumClusterwideNetworkPolicy{}
	err = c.client.Get().
		Resource("ciliumclusterwidenetworkpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of CiliumClusterwideNetworkPolicies that match those selectors.
func (c *ciliumClusterwideNetworkPolicies) List(ctx context.Context, opts v1.ListOptions) (result *v2.CiliumClusterwideNetworkPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v2.CiliumClusterwideNetworkPolicyList{}
	err = c.client.Get().
		Resource("ciliumclusterwidenetworkpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested ciliumClusterwideNetworkPolicies.
func (c *ciliumClusterwideNetworkPolicies) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("ciliumclusterwidenetworkpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a ciliumClusterwideNetworkPolicy and creates it.  Returns the server's representation of the ciliumClusterwideNetworkPolicy, and an error, if there is any.
func (c *ciliumClusterwideNetworkPolicies) Create(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.CreateOptions) (result *v2.CiliumClusterwideNetworkPolicy, err error) {
	result = &v2.CiliumClusterwideNetworkPolicy{}
	err = c.client.Post().
		Resource("ciliumclusterwidenetworkpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumClusterwideNetworkPolicy).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a ciliumClusterwideNetworkPolicy and updates it. Returns the server's representation of the ciliumClusterwideNetworkPolicy, and an error, if there is any.
func (c *ciliumClusterwideNetworkPolicies) Update(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.UpdateOptions) (result *v2.CiliumClusterwideNetworkPolicy, err error) {
	result = &v2.CiliumClusterwideNetworkPolicy{}
	err = c.client.Put().
		Resource("ciliumclusterwidenetworkpolicies").
		Name(ciliumClusterwideNetworkPolicy.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumClusterwideNetworkPolicy).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *ciliumClusterwideNetworkPolicies) UpdateStatus(ctx context.Context, ciliumClusterwideNetworkPolicy *v2.CiliumClusterwideNetworkPolicy, opts v1.UpdateOptions) (result *v2.CiliumClusterwideNetworkPolicy, err error) {
	result = &v2.CiliumClusterwideNetworkPolicy{}
	err = c.client.Put().
		Resource("ciliumclusterwidenetworkpolicies").
		Name(ciliumClusterwideNetworkPolicy.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(ciliumClusterwideNetworkPolicy).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the ciliumClusterwideNetworkPolicy and deletes it. Returns an error if one occurs.
func (c *ciliumClusterwideNetworkPolicies) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Resource("ciliumclusterwidenetworkpolicies").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *ciliumClusterwideNetworkPolicies) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("ciliumclusterwidenetworkpolicies").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched ciliumClusterwideNetworkPolicy.
func (c *ciliumClusterwideNetworkPolicies) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumClusterwideNetworkPolicy, err error) {
	result = &v2.CiliumClusterwideNetworkPolicy{}
	err = c.client.Patch(pt).
		Resource("ciliumclusterwidenetworkpolicies").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
