// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v2alpha1 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCiliumBGPPeerConfigs implements CiliumBGPPeerConfigInterface
type FakeCiliumBGPPeerConfigs struct {
	Fake *FakeCiliumV2alpha1
}

var ciliumbgppeerconfigsResource = v2alpha1.SchemeGroupVersion.WithResource("ciliumbgppeerconfigs")

var ciliumbgppeerconfigsKind = v2alpha1.SchemeGroupVersion.WithKind("CiliumBGPPeerConfig")

// Get takes name of the ciliumBGPPeerConfig, and returns the corresponding ciliumBGPPeerConfig object, and an error if there is any.
func (c *FakeCiliumBGPPeerConfigs) Get(ctx context.Context, name string, options v1.GetOptions) (result *v2alpha1.CiliumBGPPeerConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootGetAction(ciliumbgppeerconfigsResource, name), &v2alpha1.CiliumBGPPeerConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.CiliumBGPPeerConfig), err
}

// List takes label and field selectors, and returns the list of CiliumBGPPeerConfigs that match those selectors.
func (c *FakeCiliumBGPPeerConfigs) List(ctx context.Context, opts v1.ListOptions) (result *v2alpha1.CiliumBGPPeerConfigList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootListAction(ciliumbgppeerconfigsResource, ciliumbgppeerconfigsKind, opts), &v2alpha1.CiliumBGPPeerConfigList{})
	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v2alpha1.CiliumBGPPeerConfigList{ListMeta: obj.(*v2alpha1.CiliumBGPPeerConfigList).ListMeta}
	for _, item := range obj.(*v2alpha1.CiliumBGPPeerConfigList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested ciliumBGPPeerConfigs.
func (c *FakeCiliumBGPPeerConfigs) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchAction(ciliumbgppeerconfigsResource, opts))
}

// Create takes the representation of a ciliumBGPPeerConfig and creates it.  Returns the server's representation of the ciliumBGPPeerConfig, and an error, if there is any.
func (c *FakeCiliumBGPPeerConfigs) Create(ctx context.Context, ciliumBGPPeerConfig *v2alpha1.CiliumBGPPeerConfig, opts v1.CreateOptions) (result *v2alpha1.CiliumBGPPeerConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateAction(ciliumbgppeerconfigsResource, ciliumBGPPeerConfig), &v2alpha1.CiliumBGPPeerConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.CiliumBGPPeerConfig), err
}

// Update takes the representation of a ciliumBGPPeerConfig and updates it. Returns the server's representation of the ciliumBGPPeerConfig, and an error, if there is any.
func (c *FakeCiliumBGPPeerConfigs) Update(ctx context.Context, ciliumBGPPeerConfig *v2alpha1.CiliumBGPPeerConfig, opts v1.UpdateOptions) (result *v2alpha1.CiliumBGPPeerConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateAction(ciliumbgppeerconfigsResource, ciliumBGPPeerConfig), &v2alpha1.CiliumBGPPeerConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.CiliumBGPPeerConfig), err
}

// Delete takes name of the ciliumBGPPeerConfig and deletes it. Returns an error if one occurs.
func (c *FakeCiliumBGPPeerConfigs) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(ciliumbgppeerconfigsResource, name, opts), &v2alpha1.CiliumBGPPeerConfig{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCiliumBGPPeerConfigs) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionAction(ciliumbgppeerconfigsResource, listOpts)

	_, err := c.Fake.Invokes(action, &v2alpha1.CiliumBGPPeerConfigList{})
	return err
}

// Patch applies the patch and returns the patched ciliumBGPPeerConfig.
func (c *FakeCiliumBGPPeerConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2alpha1.CiliumBGPPeerConfig, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceAction(ciliumbgppeerconfigsResource, name, pt, data, subresources...), &v2alpha1.CiliumBGPPeerConfig{})
	if obj == nil {
		return nil, err
	}
	return obj.(*v2alpha1.CiliumBGPPeerConfig), err
}
