// +build !ignore_autogenerated

/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1alpha2

import (
	unsafe "unsafe"

	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	config "sigs.k8s.io/kind/pkg/cluster/config"
	cri "sigs.k8s.io/kind/pkg/container/cri"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*Node)(nil), (*config.Node)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Node_To_config_Node(a.(*Node), b.(*config.Node), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*config.Node)(nil), (*Node)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Node_To_v1alpha2_Node(a.(*config.Node), b.(*Node), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*config.Cluster)(nil), (*Config)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Cluster_To_v1alpha2_Config(a.(*config.Cluster), b.(*Config), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*config.Node)(nil), (*Node)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_config_Node_To_v1alpha2_Node(a.(*config.Node), b.(*Node), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Config)(nil), (*config.Cluster)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Config_To_config_Cluster(a.(*Config), b.(*config.Cluster), scope)
	}); err != nil {
		return err
	}
	if err := s.AddConversionFunc((*Node)(nil), (*config.Node)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1alpha2_Node_To_config_Node(a.(*Node), b.(*config.Node), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1alpha2_Node_To_config_Node(in *Node, out *config.Node, s conversion.Scope) error {
	// WARNING: in.Replicas requires manual conversion: does not exist in peer-type
	out.Role = config.NodeRole(in.Role)
	out.Image = in.Image
	// WARNING: in.KubeadmConfigPatches requires manual conversion: does not exist in peer-type
	// WARNING: in.KubeadmConfigPatchesJSON6902 requires manual conversion: does not exist in peer-type
	out.ExtraMounts = *(*[]cri.Mount)(unsafe.Pointer(&in.ExtraMounts))
	return nil
}

func autoConvert_config_Node_To_v1alpha2_Node(in *config.Node, out *Node, s conversion.Scope) error {
	out.Role = NodeRole(in.Role)
	out.Image = in.Image
	out.ExtraMounts = *(*[]cri.Mount)(unsafe.Pointer(&in.ExtraMounts))
	return nil
}
