27 Aug 2020

#### eBPF is generally available

We [introduced](https://www.projectcalico.org/introducing-the-calico-ebpf-dataplane/) tech-preview support for the eBPF dataplane in Calico v3.13. The eBPF dataplane has several advantages over the Linux networking dataplane including: higher throughput, lower CPU usage, and native Kubernetes services support. With Calico v3.16, eBPF support is now GA! Check out the [guide]({{site.baseurl}}/maintenance/enabling-bpf) to try it out.

#### Windows support

Calico for Windows is open-source! Calico for Windows supports Kubernetes networking using VXLAN and enforces network policy for Windows workloads. Try out our [quickstart guide]({{site.baseurl}}/getting-started/windows-calico/quickstart) to get a Calico for Windows cluster up and running! 
 
#### BGP Community Advertisement

Calico now supports BGP communities! Check out the BGP configuration resource [reference]({{site.baseurl}}/reference/resources/bgpconfig#communities) for more details. We've also added custom BGP port configuration.

#### Bug fixes

 - Adding support for monitoring node IP addresses/subnets changes. [node #554](https://github.com/projectcalico/node/pull/554) (@realgaurav)
 - Don't fail if not authorized to access configmaps [node #541](https://github.com/projectcalico/node/pull/541) (@caseydavenport)
 - Always auto-detect node IP address & subnet. [node #531](https://github.com/projectcalico/node/pull/531) (@realgaurav)
 - Fix that calico/node required IP auto detection to be enabled [node #513](https://github.com/projectcalico/node/pull/513) (@krisiasty)
 - In BPF mode, fix that packets could be dropped if the UDP/TCP header didn't fit in the SKB's head buffer. [felix #2462](https://github.com/projectcalico/felix/pull/2462) (@fasaxc)
 - In BPF mode, ensure that the host is always reachable, even if the conntrack table gets full. [felix #2456](https://github.com/projectcalico/felix/pull/2456) (@tomastigera)
 - In BPF mode, fix file descriptor leaks. [felix #2455](https://github.com/projectcalico/felix/pull/2455) (@fasaxc)
 - Fix that the async_calc_graph health watchdog could time out while the calc graph was blocked sending its output downstream. [felix #2451](https://github.com/projectcalico/felix/pull/2451) (@fasaxc)
 - Fix route_table.go slow retries (and reduce log spam) when a route is moved from one interface to another. [felix #2448](https://github.com/projectcalico/felix/pull/2448) (@fasaxc)
 - Reduce log spam when an interface is removed from the dataplane. [felix #2447](https://github.com/projectcalico/felix/pull/2447) (@fasaxc)
 - In BPF mode, Felix now correctly handles the case where a workload endpoint interface is recreated with the same name. [felix #2431](https://github.com/projectcalico/felix/pull/2431) (@fasaxc)
 - Felix no longer logs "Wireguard disabled" in its dataplane resolution loop. [felix #2420](https://github.com/projectcalico/felix/pull/2420) (@fasaxc)
 - Fix that libcalico-go could emit a nil Node resource resulting in a memory leak in Typha and errors in Felix. [libcalico-go #1291](https://github.com/projectcalico/libcalico-go/pull/1291) (@fasaxc)

#### Other changes

 - Add support for BGP communities and configurable BGP ports [libcalico-go #1262](https://github.com/projectcalico/libcalico-go/pull/1262) (@Suraiya-Hameed)
 - Calico IPAM support for Windows nodes [libcalico-go #1276](https://github.com/projectcalico/libcalico-go/pull/1276) (@song-jiang)
 - Reintroduce Windows operating system support [felix #2443](https://github.com/projectcalico/felix/pull/2443) (@song-jiang)
 - calico/node's security has been improved by removing as many unneeded packages, binaries and libraries from the base image as possible. [node #525](https://github.com/projectcalico/node/pull/525) (@fasaxc)
 - A new IP/interface detection method `cidr` is added. The syntax (for example for the environment variable `IP_AUTODETECTION_METHOD` is `cidr=<cidr>(,<cidr>)*`. [node #518](https://github.com/projectcalico/node/pull/518) (@mandelsoft)
 - Upgrade to golang 1.14 [typha #385](https://github.com/projectcalico/typha/pull/385) (@Brian-McM)
 - Upgrade to Golang 1.14 [felix #2437](https://github.com/projectcalico/felix/pull/2437) (@Brian-McM)
 - Fix incorrect parsing of pod CIDR when using host-local IPAM [libcalico-go #1278](https://github.com/projectcalico/libcalico-go/pull/1278) (@caseydavenport)
 - Previously, Felix had a fixed 10s timer on which it resynced its list of local interfaces with the dataplane.  To reduce CPU usage, the timer has been increased to 90s by default and a config parameter (InterfaceRefreshInterval) added to control it. [felix #2433](https://github.com/projectcalico/felix/pull/2433) (@fasaxc)
 - Connections to services without endpoints are now properly rejected in iptables dataplane mode.  The fix required moving the iptables ACCEPT rule to the end of the filter FORWARD chain; if you have your own rules in that chain then please check that they do not drop or reject pod traffic before it reaches the ACCEPT rule. [felix #2424](https://github.com/projectcalico/felix/pull/2424) (@caseydavenport)
 - In BPF mode, traffic to unknown workload interfaces is now blocked (as long as Felix was running long enough to insert its policing rules). [felix #2423](https://github.com/projectcalico/felix/pull/2423) (@fasaxc)
 - In BPF mode, Felix now attaches programs in parallel for improved performance. [felix #2410](https://github.com/projectcalico/felix/pull/2410) (@fasaxc)
 - In BPF mode, Felix now collects the BPF verifier log only on retry for increased performance and prevention of log buffer size issues. [felix #2429](https://github.com/projectcalico/felix/pull/2429) (@fasaxc)
 - In BPF mode, Felix now rate-limits stale BPF map cleanup in order to save CPU. [felix #2428](https://github.com/projectcalico/felix/pull/2428) (@fasaxc)
 - In BPF mode, Felix now detects BPF support on Red Hat kernels with backports as well as generic kernels. [felix #2409](https://github.com/projectcalico/felix/pull/2409) (@sridhartigera)
 - In BPF mode, Felix now uses a more efficient algorithm to resync the Kubernetes sevices with the dataplane.  This speeds up the initial sync (especially with large numbers of services). [felix #2401](https://github.com/projectcalico/felix/pull/2401) (@tomastigera)
 - eBPF dataplane support for encryption via Wireguard [felix #2389](https://github.com/projectcalico/felix/pull/2389) (@neiljerram)
 - Reject connections to services with no backends [felix #2380](https://github.com/projectcalico/felix/pull/2380) (@sridhartigera)
 - Implementation to handle setting source-destination-check for AWS EC2 instances. [felix #2381](https://github.com/projectcalico/felix/pull/2381) (@realgaurav)
 - In BPF mode, Felix now applies policy updates without reapplying the BPF programs; this gives a performance boost and closes a window where traffic was not policed. [felix #2363](https://github.com/projectcalico/felix/pull/2363) (@fasaxc)
 - In Kubernetes API Datastore mode, record when a pod is deleted from the network; this prevents pods that are stuck in Terminating state from being treated as active pods, resulting in duplicate IP errors and incorrect IP set calculation. [libcalico-go #1284](https://github.com/projectcalico/libcalico-go/pull/1284) (@fasaxc)
 - Upgrade to golang 1.14 [libcalico-go #1271](https://github.com/projectcalico/libcalico-go/pull/1271) (@Brian-McM)
 - Maintaining original next hop on specific bgppeer [libcalico-go #1266](https://github.com/projectcalico/libcalico-go/pull/1266) (@gunboe)
 - New Felix configuration parameter "FeatureDetectOverride" allows for overriding iptables feature detection. [libcalico-go #1264](https://github.com/projectcalico/libcalico-go/pull/1264) (@uablrek)
 - Speed up allocation of new IPAM blocks when most blocks are already in-use. [libcalico-go #1248](https://github.com/projectcalico/libcalico-go/pull/1248) (@caseydavenport)
 - Handle backend watch, if upstream closes channel[ClosedByRemote] [libcalico-go #1247](https://github.com/projectcalico/libcalico-go/pull/1247) (@krishgobinath)
 - Upgrade to Golang 1.14 [pod2daemon #43](https://github.com/projectcalico/pod2daemon/pull/43) (@Brian-McM)
 - Remove unnecessary packages from docker image [pod2daemon #42](https://github.com/projectcalico/pod2daemon/pull/42) (@gianlucam76)
 - Add support for BGP communities and configurable BGP ports [confd #341](https://github.com/projectcalico/confd/pull/341) (@Suraiya-Hameed)
 - Add configurable file logging. [cni-plugin #927](https://github.com/projectcalico/cni-plugin/pull/927) (@mgleung)
 - Upgrade to golang 1.14 [cni-plugin #921](https://github.com/projectcalico/cni-plugin/pull/921) (@Brian-McM)
 - Handle panics in the CNI plugin more gracefully [cni-plugin #913](https://github.com/projectcalico/cni-plugin/pull/913) (@caseydavenport)
 - install-cni will now check if the cni.conf file is a valid json document [cni-plugin #904](https://github.com/projectcalico/cni-plugin/pull/904) (@johscheuer)
 - The Calico CNI plugin now disables duplicate address detection on IPv6 interfaces.  This avoids the associated delay. [cni-plugin #895](https://github.com/projectcalico/cni-plugin/pull/895) (@fasaxc)
 - Support projectcalico.org/namespace label for Mesos to enable namespaced workload endpoints [cni-plugin #886](https://github.com/projectcalico/cni-plugin/pull/886) (@vixns)
 - Enable CNI plugin logging to disk by default [calico #3881](https://github.com/projectcalico/calico/pull/3881) (@mgleung)
 - Update version of flannel included in documentation to v0.12.0 [calico #3873](https://github.com/projectcalico/calico/pull/3873) (@caseydavenport)

#### Known issues

- Calico CNI binaries panic unless they use the canonical binary name [cni-plugin #941](https://github.com/projectcalico/cni-plugin/issues/941)
