18 Aug 2022

#### IPv6 wireguard support
Calico now supports wireguard encryption for IPv6 networks.

Pull Requests:
 - Add IPv6 support to wireguard. [calico #6178](https://github.com/projectcalico/calico/pull/6178) (@coutinhop)
 - Skip ipv6 vxlan route update with wireguard manager [calico #6073](https://github.com/projectcalico/calico/pull/6073) (@song-jiang)

#### IPAM API enhancements
Calico now exposes the IPAM configuration and IPAM block affinities over our API. This should make IPAM
configuration easier and allow for custom solutions to monitor IPAM block assignments. Since block affinities
are managed by Calico IPAM, they are only available on a read-only basis.

Pull Requests:
 - Add the API for accessing block affinities with read-only permissions. [calico #6420](https://github.com/projectcalico/calico/pull/6420) (@mgleung)
 - Add IPAMConfiguration to projectcalico.org/v3 API [calico #6393](https://github.com/projectcalico/calico/pull/6393) (@song-jiang)

#### More operator installation configuration options
We have added more fields to the operator API in order to allow for more fine-grained tweaks to an
operator-installed Calico deployment. Some of the newly exposed configuration fields include:
* Annotations and labels
* Node affinity and node selectors
* Tolerations
* minReadySeconds
* Container resource limits and requests
Details and discussion can be found on the [operator github](https://github.com/tigera/operator/issues/1990).

Pull Requests:
 - Support configuring IP pool DisableBGPExport with env variables [calico #6391](https://github.com/projectcalico/calico/pull/6391) (@lmm)
 - Ability to configure labels / annotations for the tigera-operator pod via helm [calico #6211](https://github.com/projectcalico/calico/pull/6211) (@agaffney)
 - Add tolerations and node selectors to the operator helm chart [calico #6158](https://github.com/projectcalico/calico/pull/6158) (@redref)

#### Ability to split IP pools
We have added commands to the `calicoctl` utility to allow for safely splitting IP pools into smaller pools.
IP pools can only be split by powers of 2 in order to ensure equal splits of IP addresses. Child IP pools
must also be large enough to contain the IPAM blocks of the parent IP pool.

Pull Requests:
 - Add calicoctl command to split IP pools. [calico #6308](https://github.com/projectcalico/calico/pull/6308) (@mgleung)

#### Transition from pod security policies to pod security standards
Calico no longer installs pod security policies (deprecated in Kubernetes 1.21) and now deploys
[pod security standards](https://kubernetes.io/docs/concepts/security/pod-security-standards/).
Operator installations of Calico should automatically transition any deployments on Kubernetes 1.25+.

Pull Requests:
 - Remove tigera-operator PodSecurityPolicy, as policy/v1beta1 is removed in Kubernetes v1.25+ [calico #6270](https://github.com/projectcalico/calico/pull/6270) (@caseydavenport)
 - Remove apiserver PodSecurityPolicy, as policy/v1beta1 is removed in Kubernetes v1.25+ [calico #6270](https://github.com/projectcalico/calico/pull/6270) (@caseydavenport)

#### Bug fixes

##### General
 - Set IPIPMode and VXLANMode to the default "Never" if they are empty strings in IPPools. [calico #6521](https://github.com/projectcalico/calico/pull/6521) (@coutinhop)
 - Fix nil error logged from kube-controllers health reporter [calico #6514](https://github.com/projectcalico/calico/pull/6514) (@caseydavenport)
 - Fix that kube-controllers health checks didn't include a timeout on HTTP calls [calico #6514](https://github.com/projectcalico/calico/pull/6514) (@caseydavenport)
 - Fix issue in L3RouteResolver CIDRTrie which could result in crashes when the IPv6 trie had a node with a /63 prefix. [calico #6511](https://github.com/projectcalico/calico/pull/6511) (@coutinhop)
 - Fix occasional incorrect withdrawal of Service IPs over BGP when changing BGPConfiguration. [calico #6416](https://github.com/projectcalico/calico/pull/6416) (@caseydavenport)
 - Remove API-level defaulting for FloatingIPs field - use code default instead [calico #6415](https://github.com/projectcalico/calico/pull/6415) (@caseydavenport)
 - Fix missing serviceaccount token creation RBAC for etcd-mode clusters, and canal clusters. [calico #6396](https://github.com/projectcalico/calico/pull/6396) (@caseydavenport)
 - Increase timeout when deleting workloads veth device in order to avoid false positives under heavy load. [calico #6356](https://github.com/projectcalico/calico/pull/6356) (@fasaxc)
 - Fix parsing of apiserver CLI flags [calico #6354](https://github.com/projectcalico/calico/pull/6354) (@cyclinder)
 - Fix lookups of locally defined hostnames from within Calico containers due to missing nsswitch.conf [calico #6326](https://github.com/projectcalico/calico/pull/6326) (@caseydavenport)
 - Fix serviceaccount token generation for canal (introduced in v3.23.2) [calico #6302](https://github.com/projectcalico/calico/pull/6302) (@caseydavenport)
 - Fix L3RouteResolver incorrectly outputting "Some nodes share IP address, route calculation may choose wrong node." log messages. [calico #6298](https://github.com/projectcalico/calico/pull/6298) (@coutinhop)
 - Fix calico/node and typha version skew bug between Calico v3.22 and v3.22+ [calico #6296](https://github.com/projectcalico/calico/pull/6296) (@caseydavenport)
 - Update the netlink library to fix a panic bug caused by unsafe pointer usage. [calico #6295](https://github.com/projectcalico/calico/pull/6295) (@fasaxc)
 - Fix WorkloadSourceSpoofing validation in FelixConfiguration [calico #6280](https://github.com/projectcalico/calico/pull/6280) (@AloysAugustin)
 - calico will only distribute routes to a Pod if its IP address falls within a  IP pool, But this won't work for VXLAN mode (only BGP mode). [calico #6245](https://github.com/projectcalico/calico/pull/6245) (@cyclinder)
 - Set preserveUnknownFields to false in Calico CRDs in order to allow updating from old versions. [calico #6242](https://github.com/projectcalico/calico/pull/6242) (@freecaykes)
 - Fix IP address truncation when using autodetection method "k8s-internal-ip" [calico #6228](https://github.com/projectcalico/calico/pull/6228) (@Josh-Tigera)
 - Fix possible context leaks [calico #6187](https://github.com/projectcalico/calico/pull/6187) (@hjiawei)
 - Fix that a combination of node deletions and workload IP relocation previously could result in multiple nodes having the same CIDR. [calico #6185](https://github.com/projectcalico/calico/pull/6185) (@robbrockbank)
 - Fix that some components failed to seed the simple (math/rand) random number generator before use.  One side effect of this was that several components would always choose the same Typha to connect to. [calico #6163](https://github.com/projectcalico/calico/pull/6163) (@fasaxc)
 - Remove some unused libraries from produced container images [calico #6125](https://github.com/projectcalico/calico/pull/6125) (@ScheererJ)
 - Fix that BGPPeer resources that identified a Calico node by IP address were handled asymmetrically in IPv4+IPv6 clusters.  In the forward direction, a peering for the IP was generated but in the reverse direction a peering for both IPv6 and IPv4 addresses was generated. [calico #6119](https://github.com/projectcalico/calico/pull/6119) (@fasaxc)
 - Fix helm upgrade instructions [calico #6117](https://github.com/projectcalico/calico/pull/6117) (@caseydavenport)
 - Ignore v prefix when comparing cluster and client version in calicoctl [calico #6064](https://github.com/projectcalico/calico/pull/6064) (@lou-lan)
 - Fix bug where Calico would not recover after listing from a too old resource version [calico #6045](https://github.com/projectcalico/calico/pull/6045) (@caseydavenport)
 - Ignore blocks that are not confirmed to a host [calico #6003](https://github.com/projectcalico/calico/pull/6003) (@caseydavenport)

##### eBPF
 - ebpf: explicitly ACCEPT approved traffic in INPUT to avoid drops in default-DROP environments. [calico #6327](https://github.com/projectcalico/calico/pull/6327) (@tomastigera)
 - ebpf: WG traffic is allowed by the HEP programs in case of a conflicting policy. [calico #6320](https://github.com/projectcalico/calico/pull/6320) (@tomastigera)
 - eBPF: Retry setting RPF when device isn't ready [calico #6304](https://github.com/projectcalico/calico/pull/6304) (@tomastigera)
 - ebpf: we drop packets that are about to be redirected to a workload endpoint that does not have a tc attached program yet, hence is unprotected. [calico #6241](https://github.com/projectcalico/calico/pull/6241) (@tomastigera)

##### Windows
 - Fix issues with the windows node names in GCE [calico #6510](https://github.com/projectcalico/calico/pull/6510) (@lmm)

##### Wireguard
 - Limit rate of logging 'Wireguard is not supported' to fix log spam issues. [calico #6512](https://github.com/projectcalico/calico/pull/6512) (@coutinhop)
 - Handle errors correctly in wireguard tunnel IP setting on the node [calico #6185](https://github.com/projectcalico/calico/pull/6185) (@robbrockbank)
 - When there is no allocated Wireguard interface IP and host encryption is enabled the host IP is used as the device IP.  This ensures source IP selection will choose the correct host IP when routing over Wireguard [calico #6185](https://github.com/projectcalico/calico/pull/6185) (@robbrockbank)
 - Don't allocate wireguard device IPs for managed cloud non-calico CNI [calico #6185](https://github.com/projectcalico/calico/pull/6185) (@robbrockbank)

#### Other changes

##### General
 - Update the base images to alpine 3.16 for the flexvolume and CSI driver [calico #6560](https://github.com/projectcalico/calico/pull/6560) (@mgleung)
 - Update pacakges from UBI repo for CVE fixes [calico #6380](https://github.com/projectcalico/calico/pull/6380) (@caseydavenport)
 - Add new node-role.kubernetes.io/control-plane taints [calico #6370](https://github.com/projectcalico/calico/pull/6370) (@frezbo)
 - Update UBI base image to 8.6 [calico #6347](https://github.com/projectcalico/calico/pull/6347) (@caseydavenport)
 - Build ppc64le image for calico/apiserver. [calico #6287](https://github.com/projectcalico/calico/pull/6287) (@yussufsh)
 - Add HTTP /terminate endpoint for graceful termination of Dikastes sidecar container to facilitate Kubernetes Job completion [calico #6268](https://github.com/projectcalico/calico/pull/6268) (@Josh-Tigera)
 - Update the ipset package from 7.1 to 7.11 for ARM builds [calico #6262](https://github.com/projectcalico/calico/pull/6262) (@ScOut3R)
 - Documentation updated to use static per-patch raw.githubuercontent.com manifest links. [calico #6261](https://github.com/projectcalico/calico/pull/6261) (@caseydavenport)
 - Add new Pod annotation for assigning specified MAC address to container veth [calico #6249](https://github.com/projectcalico/calico/pull/6249) (@Josh-Tigera)
 - Update flannel daemonset default value for migration controller [calico #6229](https://github.com/projectcalico/calico/pull/6229) (@caseydavenport)
 - Explicitly copy necessary libs from UBI instead of whole /lib and /lib64 dirs for the typha, dikastes, flexvol, kube-controllers, flannel-migration controller images [calico #6225](https://github.com/projectcalico/calico/pull/6225) (@coutinhop)
 - Reduce the number of libraries included within the calico/cni image. [calico #6217](https://github.com/projectcalico/calico/pull/6217) (@freecaykes)
 - Reduce the number of libraries included within the calico/apiserver image [calico #6214](https://github.com/projectcalico/calico/pull/6214) (@freecaykes)
 - calicoctl ipam check/release now look for and clean up unused IPAM handles. [calico #6155](https://github.com/projectcalico/calico/pull/6155) (@fasaxc)
 - Updating a couple of dependencies for Calico (including, spf13/viper, spf13/cobra and etcd related dependencies). Updating the dependencies would also help us with our CVE scan process. [calico #6154](https://github.com/projectcalico/calico/pull/6154) (@Behnam-Shobiri)
 - compiled using go-1.18 [calico #6131](https://github.com/projectcalico/calico/pull/6131) (@tomastigera)
 - Update Kubernetes dependency to v1.24 [calico #6097](https://github.com/projectcalico/calico/pull/6097) (@caseydavenport)
 - Add IPv6 support for flannel migration. [calico #6088](https://github.com/projectcalico/calico/pull/6088) (@coutinhop)
 - Operator monitors BGP configuration resource to trigger rolling updates as needed [calico #6016](https://github.com/projectcalico/calico/pull/6016) (@caseydavenport)
 - go version update to 1.17.9 [calico #6000](https://github.com/projectcalico/calico/pull/6000) (@doublek)
 - AKS BYO instructions now install the Calico API server by default. [calico #5976](https://github.com/projectcalico/calico/pull/5976) (@song-jiang)
 - Attach SHA256SUMS as part of release, including checksums for all release artifacts. [calico #5960](https://github.com/projectcalico/calico/pull/5960) (@caseydavenport)
 - Manifests can now be accessed via immutable github links. [calico #5954](https://github.com/projectcalico/calico/pull/5954) (@caseydavenport)
 - Calico now uses the TokenRequest API to generate and refresh a token for the CNI plugin.  This ensures that the token remains valid even when the calico-node daemonset is restarted. [calico #5910](https://github.com/projectcalico/calico/pull/5910) (@ScheererJ)
 - Added dummy routetable for network policy only mode [calico #5454](https://github.com/projectcalico/calico/pull/5454) (@juanfresia)

##### eBPF
 - Add support to dump bpf policies attached to an interface [calico #6283](https://github.com/projectcalico/calico/pull/6283) (@sridhartigera)
 - ebpf: Conntrack table gets upgraded to version 3 [calico #6223](https://github.com/projectcalico/calico/pull/6223) (@sridhartigera)
 - eBPF: Add counters to eBPF programs, and add support to calico-bpf to work with those counters. [calico #6198](https://github.com/projectcalico/calico/pull/6198) (@mazdakn)
 - cni dumps stack when and where ADD or DEL panics [calico #6195](https://github.com/projectcalico/calico/pull/6195) (@tomastigera)
 - eBPF: Move mount of BPFfs and cgroupv2 to a dedicated init container with elevated privileges; enter the root cgroup namespace to mount cgroupv2 in order to allow the CTLB to be installed system-wide. Reduce the mount privileges of the main calico-node container. [calico #6078](https://github.com/projectcalico/calico/pull/6078) (@mazdakn)
 - Remove special case eBPF on EKS documentation; current versions of EKS use a new enough kernel for eBPF. [calico #6008](https://github.com/projectcalico/calico/pull/6008) (@fasaxc)
 - ebpf: RPF checks enforced in BPF [calico #5981](https://github.com/projectcalico/calico/pull/5981) (@sridhartigera)
 - ebpf: host does not require CTLB to access cluster IPs [calico #5879](https://github.com/projectcalico/calico/pull/5879) (@tomastigera)

##### Windows
 - Windows quickstart install script creates calico service account token secret if missing [calico #6467](https://github.com/projectcalico/calico/pull/6467) (@lmm)
 - Update platform detection in windows installation for EC2 to use IMDSv2 [calico #6104](https://github.com/projectcalico/calico/pull/6104) (@backjo)
 - Windows install script now auto-detects networking backend via ippools [calico #6010](https://github.com/projectcalico/calico/pull/6010) (@lmm)

##### Wireguard
 - Calico will now add an ACCEPT rule for the Wireguard UDP port when enabled to ensure policy doesn't drop Calico Wireguard traffic. [calico #6250](https://github.com/projectcalico/calico/pull/6250) (@muff1nman)
