01 Jul 2019

#### IPAM utilization reporting

You can now view IP address usage for each IP pool using calicoctl. This allows you to more easily manage the IP space in your cluster, providing a simple way to see
which IP pools have addresses available and which are running low. See [the calicoctl reference documentation](https://docs.projectcalico.org/master/reference/calicoctl/ipam/show)
for more detailed information on how to use this feature.

Pull requests:

 - Expose IPAM usage in calicoctl [calicoctl #2011](https://github.com/projectcalico/calicoctl/pull/2011) (@neiljerram)
 - Calculate IPAM usage [libcalico-go #1087](https://github.com/projectcalico/libcalico-go/pull/1087) (@neiljerram)
 - Documentation updates [calico #2636](https://github.com/projectcalico/calico/pull/2636) (@neiljerram)

#### Istio integration improvements

Calico v3.8.0 includes several improvements to its integration with Istio for [application layer policy enforcement](https://docs.projectcalico.org/v3.8/security/app-layer-policy/). Calico now supports Istio v1.1, and includes the
necessary drivers and volumes in calico-node by default. [To enable](https://docs.projectcalico.org/v3.8/getting-started/kubernetes/installation/app-layer-policy), simply modify the default felix configuration.

Pull requests:

 - Adds support for envoy.service.auth.v2 API; supports Istio 1.1 [app-policy #91](https://github.com/projectcalico/app-policy/pull/91) (@spikecurtis)
 - Includes App Layer Policy drivers & volumes in `calico-node` but leaves disabled by default. [calico #2633](https://github.com/projectcalico/calico/pull/2633) (@spikecurtis)
 - Sidecar injector ConfigMaps for multiple Istio versions, URL changed [calico #2619](https://github.com/projectcalico/calico/pull/2619) (@spikecurtis)

#### Explicit source IP for outgoing NAT

You can now specify an exact address to use for outgoing SNAT when workloads are sending traffic outside of the cluster. This enables better support for hosts with multiple interface addresses. For example, you may
want to ensure that SNAT occurs using a publicly routable secondary IP address on your primary interface.

Pull requests:

 - Support for specifying explicit IP to be used for outgoing NAT [felix #2028](https://github.com/projectcalico/felix/pull/2028) (@maxstr)
 - Support for specifying explicit IP to be used for outgoing NAT [libcalico-go #1089](https://github.com/projectcalico/libcalico-go/pull/1089) (@maxstr)

#### Bug fixes

 - Fix that VXLAN routes were revoked but not re-added if node IP tunnel or main IP changed. [felix #2030](https://github.com/projectcalico/felix/pull/2030) (@fasaxc)
 - Fixed slow memory leak that was noticed with lots of workload churn. [felix #2023](https://github.com/projectcalico/felix/pull/2023) (@tmjd)

#### Other changes

 - Manifests now use the stable v1 Kubernetes APIs [calico #2629](https://github.com/projectcalico/calico/pull/2629) (@jadech32)
 - Assign priority classes to Calico components [calico #2564](https://github.com/projectcalico/calico/pull/2564) (@tomastigera)
 - Validate BGP peer node and peer selectors [libcalico-go #1091](https://github.com/projectcalico/libcalico-go/pull/1091) (@jadech32)
 - Add [etcd DNS discovery](https://coreos.com/etcd/docs/latest/op-guide/clustering.html#dns-discovery) support for specifying etcdv3 endpoint(s). [libcalico-go #1086](https://github.com/projectcalico/libcalico-go/pull/1086) (@jsok)
 - Only update peers if there was a significant change in nodes [confd #234](https://github.com/projectcalico/confd/pull/234) (@cezarsa)
 - Changed order of releasing IP and removing interface [cni-plugin #746](https://github.com/projectcalico/cni-plugin/pull/746) (@jadech32)
 - Update cni-plugins version to v0.8.0 and add bandwidth plugin for traffic shaping. [cni-plugin #745](https://github.com/projectcalico/cni-plugin/pull/745) (@johscheuer)
