/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: FindText.java
 *
 * Copyright (c) 2003 Sun Microsystems and Static Free Software
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TextWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.TopLevel;

import java.awt.Frame;
import java.awt.Insets;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.util.Iterator;
import java.util.List;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;


/**
 * Class to handle the "Search and Replace" dialog.
 */
public class FindText extends EDialog
{
	private static String lastFindTextMessage = null;
	private static String lastReplaceTextMessage = null;
	private static boolean iniCaseSensitive = false;
	private static boolean iniFindReverse = false;
	private String lastSearch = null;

	public static void findTextDialog()
	{
		FindText dialog = new FindText(TopLevel.getCurrentJFrame(), false);
		dialog.setVisible(true);
	}

	/** Creates new form Search and Replace */
	private FindText(Frame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
		if (lastFindTextMessage != null)
			findString.setText(lastFindTextMessage);
		if (lastReplaceTextMessage != null)
			replaceString.setText(lastReplaceTextMessage);
		caseSensitive.setSelected(iniCaseSensitive);
		findReverse.setSelected(iniFindReverse);
		getRootPane().setDefaultButton(find);
	}

	protected void escapePressed() { doneActionPerformed(null); }

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel4 = new javax.swing.JLabel();
		done = new javax.swing.JButton();
        findString = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        replaceString = new javax.swing.JTextField();
        caseSensitive = new javax.swing.JCheckBox();
        findReverse = new javax.swing.JCheckBox();
        replace = new javax.swing.JButton();
        replaceAndFind = new javax.swing.JButton();
        replaceAll = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        lineNumber = new javax.swing.JTextField();
        find = new javax.swing.JButton();
        goToLine = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Search and Replace");
        setName("");
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });

        jLabel4.setText("Find:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel4, gridBagConstraints);

		done.setText("Done");
		done.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
				doneActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(done, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(findString, gridBagConstraints);

        jLabel1.setText("Line Number:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(replaceString, gridBagConstraints);

        caseSensitive.setText("Case Sensitive");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(caseSensitive, gridBagConstraints);

        findReverse.setText("Find Reverse");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(findReverse, gridBagConstraints);

        replace.setText("Replace");
        replace.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                replaceActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(replace, gridBagConstraints);

        replaceAndFind.setText("Replace and Find");
        replaceAndFind.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                replaceAndFindActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(replaceAndFind, gridBagConstraints);

        replaceAll.setText("Replace All");
        replaceAll.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                replaceAllActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(replaceAll, gridBagConstraints);

        jLabel2.setText("Replace:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel2, gridBagConstraints);

        lineNumber.setColumns(6);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(lineNumber, gridBagConstraints);

        find.setText("Find");
        find.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                findActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(find, gridBagConstraints);

        goToLine.setText("Go To Line");
        goToLine.addActionListener(new java.awt.event.ActionListener()
        {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                goToLineActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(goToLine, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

	private void goToLineActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_goToLineActionPerformed
	{//GEN-HEADEREND:event_goToLineActionPerformed
		WindowFrame wf = WindowFrame.getCurrentWindowFrame();
		if (wf == null) return;
		WindowContent content = wf.getContent();
		if (content instanceof TextWindow)
		{
			TextWindow tw = (TextWindow)content;
			int i = TextUtils.atoi(lineNumber.getText());
			tw.goToLineNumber(i);
			return;
		}
		System.out.println("Cannot access this window by line numbers");
	}//GEN-LAST:event_goToLineActionPerformed

	private void replaceAllActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_replaceAllActionPerformed
	{//GEN-HEADEREND:event_replaceAllActionPerformed
		WindowFrame wf = WindowFrame.getCurrentWindowFrame();
		if (wf == null) return;
		String search = findString.getText();
		String replace = replaceString.getText();
		WindowContent content = wf.getContent();
		content.initTextSearch(search, caseSensitive.isSelected());
		content.replaceAllText(replace);

	}//GEN-LAST:event_replaceAllActionPerformed

	private void replaceAndFindActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_replaceAndFindActionPerformed
	{//GEN-HEADEREND:event_replaceAndFindActionPerformed
		WindowFrame wf = WindowFrame.getCurrentWindowFrame();
		if (wf == null) return;
		if (lastSearch == null) return;
		WindowContent content = wf.getContent();
		content.replaceText(replaceString.getText());
		if (!content.findNextText(findReverse.isSelected())) lastSearch = null;

	}//GEN-LAST:event_replaceAndFindActionPerformed

	private void replaceActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_replaceActionPerformed
	{//GEN-HEADEREND:event_replaceActionPerformed
		WindowFrame wf = WindowFrame.getCurrentWindowFrame();
		if (wf == null) return;
		if (lastSearch == null) return;
		WindowContent content = wf.getContent();
		content.replaceText(replaceString.getText());

	}//GEN-LAST:event_replaceActionPerformed

	private void findActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_findActionPerformed
	{//GEN-HEADEREND:event_findActionPerformed
		WindowFrame wf = WindowFrame.getCurrentWindowFrame();
		if (wf == null) return;
		String search = findString.getText();
		WindowContent content = wf.getContent();
		if (lastSearch != null)
		{
			if (!lastSearch.equals(search)) lastSearch = null;
		}
		if (lastSearch == null)
		{
			content.initTextSearch(search, caseSensitive.isSelected());
		}
		lastSearch = search;
		if (!content.findNextText(findReverse.isSelected())) lastSearch = null;
	}//GEN-LAST:event_findActionPerformed

	private void doneActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_doneActionPerformed
	{//GEN-HEADEREND:event_doneActionPerformed
		closeDialog(null);
	}//GEN-LAST:event_doneActionPerformed

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		lastFindTextMessage = findString.getText();
		lastReplaceTextMessage = replaceString.getText();
		iniCaseSensitive = caseSensitive.isSelected();
		iniFindReverse = findReverse.isSelected();

		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton done;
    private javax.swing.JCheckBox caseSensitive;
    private javax.swing.JButton find;
    private javax.swing.JCheckBox findReverse;
    private javax.swing.JTextField findString;
    private javax.swing.JButton goToLine;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField lineNumber;
    private javax.swing.JButton replace;
    private javax.swing.JButton replaceAll;
    private javax.swing.JButton replaceAndFind;
    private javax.swing.JTextField replaceString;
    // End of variables declaration//GEN-END:variables
}
