/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.io.output.Topology;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class Verilog
extends Topology {
    private static final int MAXDECLARATIONWIDTH = 80;
    private static final String IMPLICITINVERTERNODENAME = "Imp";
    private static final String IMPLICITINVERTERSIGNAME = "ImpInv";
    public static final Variable.Key VERILOG_CODE_KEY = ElectricObject.newKey("VERILOG_code");
    public static final Variable.Key VERILOG_DECLARATION_KEY = ElectricObject.newKey("VERILOG_declaration");
    public static final Variable.Key WIRE_TYPE_KEY = ElectricObject.newKey("SIM_verilog_wire_type");
    public static final Variable.Key VERILOG_TEMPLATE_KEY = ElectricObject.newKey("ATTR_verilog_template");
    public static final Variable.Key VERILOG_BEHAVE_FILE_KEY = ElectricObject.newKey("SIM_verilog_behave_file");
    private StringBuffer sim_verDeclarationLine;
    private int sim_verdeclarationprefix;

    public static void writeVerilogFile(Cell cell, VarContext context, String filePath) {
        Verilog out = new Verilog();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        if (out.writeCell(cell, context)) {
            return;
        }
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    Verilog() {
    }

    protected void start() {
        Global global;
        int i;
        this.printWriter.print("/* Verilog for cell " + this.topCell.describe() + " from Library " + this.topCell.getLibrary().getName() + " */\n");
        this.emitCopyright("/* ", " */");
        if (User.isIncludeDateAndVersionInOutput()) {
            this.printWriter.print("/* Created on " + TextUtils.formatDate(this.topCell.getCreationDate()) + " */\n");
            this.printWriter.print("/* Last revised on " + TextUtils.formatDate(this.topCell.getRevisionDate()) + " */\n");
            this.printWriter.print("/* Written on " + TextUtils.formatDate(new Date()) + " by Electric VLSI Design System, version " + Version.getVersion() + " */\n");
        } else {
            this.printWriter.print("/* Written by Electric VLSI Design System */\n");
        }
        Netlist netList = this.getNetlistForCell(this.topCell);
        Global.Set globals = netList.getGlobals();
        int globalSize = globals.size();
        ArrayList<Global> globalsToWrite = new ArrayList<Global>();
        for (i = 0; i < globalSize; ++i) {
            global = globals.get(i);
            if (global == Global.power || global == Global.ground) continue;
            globalsToWrite.add(global);
        }
        if (globalsToWrite.size() > 0) {
            this.printWriter.print("\nmodule glbl();\n");
            for (i = 0; i < globalsToWrite.size(); ++i) {
                global = (Global)globalsToWrite.get(i);
                if (Simulation.getVerilogUseTrireg()) {
                    this.printWriter.print("    trireg " + global.getName() + ";\n");
                    continue;
                }
                this.printWriter.print("    wire " + global.getName() + ";\n");
            }
            this.printWriter.print("endmodule\n");
        }
    }

    protected void done() {
    }

    protected boolean skipCellAndSubcells(Cell cell) {
        String fileName;
        if (cell.getVar(VERILOG_TEMPLATE_KEY) != null) {
            return true;
        }
        Variable behaveFileVar = cell.getVar(VERILOG_BEHAVE_FILE_KEY);
        if (behaveFileVar != null && (fileName = behaveFileVar.getObject().toString()).length() > 0) {
            this.printWriter.print("`include \"" + fileName + "\"\n");
            return true;
        }
        return false;
    }

    protected void writeCellTopology(Cell cell, Topology.CellNetInfo cni, VarContext context) {
        Topology.CellAggregateSignal cas;
        Cell verViewCell = cell.otherView(View.VERILOG);
        if (verViewCell != null) {
            String[] stringArray = verViewCell.getTextViewContents();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.printWriter.print(stringArray[i] + "%s\n");
                }
            }
            return;
        }
        Netlist netList = this.getNetlistForCell(cell);
        this.printWriter.print("\n");
        StringBuffer sb = new StringBuffer();
        sb.append("module " + cni.getParameterizedName() + "(");
        boolean first = true;
        Iterator it = cni.getCellAggregateSignals();
        while (it.hasNext()) {
            cas = (Topology.CellAggregateSignal)it.next();
            if (cas.getExport() == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cas.getName());
            first = false;
        }
        sb.append(");");
        this.writeLongLine(sb.toString());
        it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            Variable var = ai.getVar(WIRE_TYPE_KEY);
            if (var == null) continue;
            String wireType = var.getObject().toString();
            int overrideValue = 0;
            if (wireType.equalsIgnoreCase("wire")) {
                overrideValue = 1;
            } else if (wireType.equalsIgnoreCase("trireg")) {
                overrideValue = 2;
            }
            int busWidth = netList.getBusWidth(ai);
            for (int i = 0; i < busWidth; ++i) {
                JNetwork net = netList.getNetwork(ai, i);
                Topology.CellSignal cs = cni.getCellSignal(net);
                if (cs == null) continue;
                cs.getAggregateSignal().setFlags(overrideValue);
            }
        }
        first = true;
        it = cni.getCellAggregateSignals();
        while (it.hasNext()) {
            cas = (Topology.CellAggregateSignal)it.next();
            Export pp = cas.getExport();
            if (pp == null) continue;
            String portType = "input";
            if (pp.getCharacteristic() == PortProto.Characteristic.OUT) {
                portType = "output";
            }
            this.printWriter.print("  " + portType);
            if (cas.getLowIndex() > cas.getHighIndex()) {
                this.printWriter.print(" " + cas.getName() + ";");
            } else {
                int low = cas.getLowIndex();
                int high = cas.getHighIndex();
                if (cas.isDescending()) {
                    low = cas.getHighIndex();
                    high = cas.getLowIndex();
                }
                this.printWriter.print(" [" + low + ":" + high + "] " + cas.getName() + ";");
            }
            if (cas.getFlags() != 0) {
                if (cas.getFlags() == 1) {
                    this.printWriter.print("  wire");
                } else {
                    this.printWriter.print("  trireg");
                }
                this.printWriter.print(" " + cas.getName() + ";");
            }
            this.printWriter.print("\n");
            first = false;
        }
        if (!first) {
            this.printWriter.print("\n");
        }
        if (cni.getPowerNet() != null) {
            this.printWriter.print("  supply1 vdd;\n");
        }
        if (cni.getGroundNet() != null) {
            this.printWriter.print("  supply0 gnd;\n");
        }
        String wireType = "wire";
        if (Simulation.getVerilogUseTrireg()) {
            wireType = "trireg";
        }
        int localWires = 0;
        for (int wt = 0; wt < 2; ++wt) {
            first = true;
            Iterator it2 = cni.getCellAggregateSignals();
            while (it2.hasNext()) {
                Topology.CellAggregateSignal cas2 = (Topology.CellAggregateSignal)it2.next();
                if (cas2.getExport() != null || cas2.isSupply() || cas2.getLowIndex() <= cas2.getHighIndex() || cas2.isGlobal()) continue;
                String impSigName = wireType;
                if (cas2.getFlags() != 0) {
                    impSigName = cas2.getFlags() == 1 ? "wire" : "trireg";
                }
                if (!(wt == 0 ^ !wireType.equals(impSigName))) continue;
                if (first) {
                    this.initDeclaration("  " + impSigName);
                }
                this.addDeclaration(cas2.getName());
                ++localWires;
                first = false;
            }
            if (first) continue;
            this.termDeclaration();
        }
        Iterator it3 = cni.getCellAggregateSignals();
        while (it3.hasNext()) {
            Topology.CellAggregateSignal cas3 = (Topology.CellAggregateSignal)it3.next();
            if (cas3.getExport() != null || cas3.isSupply() || cas3.getLowIndex() > cas3.getHighIndex() || cas3.isGlobal()) continue;
            if (cas3.isDescending()) {
                this.printWriter.print("  " + wireType + " [" + cas3.getHighIndex() + ":" + cas3.getLowIndex() + "] " + cas3.getName() + ";\n");
            } else {
                this.printWriter.print("  " + wireType + " [" + cas3.getLowIndex() + ":" + cas3.getHighIndex() + "] " + cas3.getName() + ";\n");
            }
            ++localWires;
        }
        if (localWires != 0) {
            this.printWriter.print("\n");
        }
        first = this.includeTypedCode(cell, VERILOG_DECLARATION_KEY, "declarations");
        if (!(first |= this.includeTypedCode(cell, VERILOG_CODE_KEY, "code"))) {
            this.printWriter.print("  /* automatically generated Verilog */\n");
        }
        Iterator nIt = netList.getNodables();
        while (nIt.hasNext()) {
            Variable varTemplate;
            Nodable no = (Nodable)nIt.next();
            NodeProto niProto = no.getProto();
            NodeProto.Function nodeType = NodeProto.Function.UNKNOWN;
            if (niProto instanceof PrimitiveNode) {
                NodeInst ni = (NodeInst)no;
                Iterator pIt = ni.getPortInsts();
                if (pIt.hasNext()) {
                    boolean allConnected = true;
                    PortInst firstPi = (PortInst)pIt.next();
                    JNetwork firstNet = netList.getNetwork(firstPi);
                    while (pIt.hasNext()) {
                        PortInst pi = (PortInst)pIt.next();
                        JNetwork thisNet = netList.getNetwork(pi);
                        if (thisNet == firstNet) continue;
                        allConnected = false;
                        break;
                    }
                    if (allConnected) continue;
                }
                if ((nodeType = ni.getFunction()) == NodeProto.Function.RESIST || nodeType == NodeProto.Function.CAPAC || nodeType == NodeProto.Function.ECAPAC || nodeType == NodeProto.Function.INDUCT || nodeType == NodeProto.Function.DIODE || nodeType == NodeProto.Function.DIODEZ) continue;
            }
            if (niProto instanceof Cell && (varTemplate = niProto.getVar(VERILOG_TEMPLATE_KEY)) != null) {
                this.writeTemplate((String)varTemplate.getObject(), no, cni, context);
                continue;
            }
            if (Simulation.getVerilogUseAssign() && (nodeType == NodeProto.Function.GATEAND || nodeType == NodeProto.Function.GATEOR || nodeType == NodeProto.Function.GATEXOR || nodeType == NodeProto.Function.BUFFER)) {
                String op = "";
                if (nodeType == NodeProto.Function.GATEAND) {
                    op = " & ";
                } else if (nodeType == NodeProto.Function.GATEOR) {
                    op = " | ";
                } else if (nodeType == NodeProto.Function.GATEXOR) {
                    op = " ^ ";
                }
                StringBuffer infstr = new StringBuffer();
                boolean wholeNegated = false;
                first = true;
                NodeInst ni = (NodeInst)no;
                block15: for (int i = 0; i < 2; ++i) {
                    Iterator cIt = ni.getConnections();
                    while (cIt.hasNext()) {
                        Connection con = (Connection)cIt.next();
                        PortInst pi = con.getPortInst();
                        if (i == 0 ? !pi.getPortProto().getName().equals("y") : !pi.getPortProto().getName().equals("a")) continue;
                        ArcInst ai = con.getArc();
                        JNetwork net = netList.getNetwork(ai, 0);
                        Topology.CellSignal cs = cni.getCellSignal(net);
                        String sigName = cs.getName();
                        boolean isNegated = false;
                        if (i == 0) {
                            infstr.append("assign " + sigName + " = ");
                            if (!isNegated) continue block15;
                            infstr.append("~(");
                            wholeNegated = true;
                            continue block15;
                        }
                        if (!first) {
                            infstr.append(op);
                        }
                        first = false;
                        if (isNegated) {
                            infstr.append("~");
                        }
                        infstr.append(sigName);
                    }
                }
                if (wholeNegated) {
                    infstr.append(")");
                }
                infstr.append(";");
                this.writeLongLine(infstr.toString());
                continue;
            }
            int implicitPorts = 0;
            boolean dropBias = false;
            String nodeName = "";
            if (niProto instanceof Cell) {
                nodeName = this.parameterizedName(no, context);
            } else {
                Variable varWeakNode;
                if (nodeType == NodeProto.Function.TRA4NMOS) {
                    nodeType = NodeProto.Function.TRANMOS;
                    dropBias = true;
                } else if (nodeType == NodeProto.Function.TRA4PMOS) {
                    nodeType = NodeProto.Function.TRAPMOS;
                    dropBias = true;
                }
                if (nodeType == NodeProto.Function.TRANMOS) {
                    implicitPorts = 2;
                    nodeName = "tranif1";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif1";
                    }
                } else if (nodeType == NodeProto.Function.TRAPMOS) {
                    implicitPorts = 2;
                    nodeName = "tranif0";
                    varWeakNode = ((NodeInst)no).getVar(Simulation.WEAK_NODE_KEY);
                    if (varWeakNode != null) {
                        nodeName = "rtranif0";
                    }
                } else if (nodeType == NodeProto.Function.GATEAND) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "and", "nand");
                } else if (nodeType == NodeProto.Function.GATEOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "or", "nor");
                } else if (nodeType == NodeProto.Function.GATEXOR) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "xor", "xnor");
                } else if (nodeType == NodeProto.Function.BUFFER) {
                    implicitPorts = 1;
                    nodeName = this.chooseNodeName((NodeInst)no, "buf", "not");
                    nodeName = "buf";
                }
            }
            if (nodeName.length() == 0) continue;
            StringBuffer infstr = new StringBuffer();
            infstr.append("  " + nodeName + " " + this.nameNoIndices(no.getName()) + "(");
            first = true;
            NodeInst ni = null;
            switch (implicitPorts) {
                case 0: {
                    Topology.CellNetInfo subCni = this.getCellNetInfo(nodeName);
                    Iterator sIt = subCni.getCellAggregateSignals();
                    while (sIt.hasNext()) {
                        Topology.CellAggregateSignal cas4 = (Topology.CellAggregateSignal)sIt.next();
                        Export pp = cas4.getExport();
                        if (pp == null) continue;
                        if (first) {
                            first = false;
                        } else {
                            infstr.append(", ");
                        }
                        int low = cas4.getLowIndex();
                        int high = cas4.getHighIndex();
                        if (low > high) {
                            infstr.append("." + cas4.getName() + "(");
                            JNetwork net = netList.getNetwork(no, pp, cas4.getExportIndex());
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            infstr.append(cs.getName());
                            infstr.append(")");
                            continue;
                        }
                        int total = high - low + 1;
                        Topology.CellSignal[] outerSignalList = new Topology.CellSignal[total];
                        for (int j = low; j <= high; ++j) {
                            JNetwork net = netList.getNetwork(no, cas4.getExport(), j - low);
                            outerSignalList[j - low] = cni.getCellSignal(net);
                        }
                        this.writeBus(outerSignalList, low, high, cas4.isDescending(), cas4.getName(), cni.getPowerNet(), cni.getGroundNet(), infstr);
                    }
                    infstr.append(");");
                    break;
                }
                case 1: {
                    ni = (NodeInst)no;
                    for (int i = 0; i < 2; ++i) {
                        Iterator pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst pi = (PortInst)pIt.next();
                            if (i != 0 ? !pi.getPortProto().getName().equals("a") : !pi.getPortProto().getName().equals("y")) continue;
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            JNetwork net = netList.getNetwork(pi);
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            String sigName = cs.getName();
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                    break;
                }
                case 2: {
                    ni = (NodeInst)no;
                    JNetwork gateNet = netList.getNetwork(ni.getTransistorGatePort());
                    for (int i = 0; i < 2; ++i) {
                        Iterator pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst ePi;
                            PortInst pi = (PortInst)pIt.next();
                            JNetwork net = netList.getNetwork(pi);
                            boolean connected = false;
                            Iterator ePIt = ni.getPortInsts();
                            while (ePIt.hasNext() && (ePi = (PortInst)ePIt.next()) != pi) {
                                JNetwork eNet = netList.getNetwork(ePi);
                                if (eNet != net) continue;
                                connected = true;
                                break;
                            }
                            if (connected || dropBias && pi.getPortProto().getName().equals("b") || (i != 0 ? net != gateNet : net == gateNet)) continue;
                            if (first) {
                                first = false;
                            } else {
                                infstr.append(", ");
                            }
                            Topology.CellSignal cs = cni.getCellSignal(net);
                            String sigName = cs.getName();
                            infstr.append(sigName);
                        }
                    }
                    infstr.append(");");
                }
            }
            this.writeLongLine(infstr.toString());
        }
        this.printWriter.print("endmodule   /* " + cni.getParameterizedName() + " */\n");
    }

    private String chooseNodeName(NodeInst ni, String positive, String negative) {
        Iterator aIt = ni.getConnections();
        while (aIt.hasNext()) {
            Connection con = (Connection)aIt.next();
            if (!con.getPortInst().getPortProto().getName().equals("y") || !con.isNegated()) continue;
            return negative;
        }
        return positive;
    }

    private void writeTemplate(String line, Nodable no, Topology.CellNetInfo cni, VarContext context) {
        Netlist netList = cni.getNetList();
        StringBuffer infstr = new StringBuffer();
        infstr.append("  ");
        for (int pt = 0; pt < line.length(); ++pt) {
            int startpt;
            char chr = line.charAt(pt);
            if (chr != '$' || pt + 1 >= line.length() || line.charAt(pt + 1) != '(') {
                infstr.append(chr);
                continue;
            }
            for (pt = startpt = pt + 2; pt < line.length() && line.charAt(pt) != ')'; ++pt) {
            }
            String paramName = line.substring(startpt, pt);
            PortProto pp = no.getProto().findPortProto(paramName);
            if (pp != null) {
                JNetwork net = netList.getNetwork(no, pp, 0);
                Topology.CellSignal cs = cni.getCellSignal(net);
                infstr.append(cs.getName());
                continue;
            }
            if (paramName.equalsIgnoreCase("node_name")) {
                infstr.append(this.getSafeNetName(no.getName()));
                continue;
            }
            String attrName = "ATTR_" + paramName;
            Variable var = no.getVar(attrName);
            if (var == null) {
                // empty if block
            }
            if (var == null) {
                infstr.append("??");
                continue;
            }
            infstr.append(context.evalVar(var));
        }
        this.writeLongLine(infstr.toString());
    }

    private void writeBus(Topology.CellSignal[] outerSignalList, int lowIndex, int highIndex, boolean descending, String name, JNetwork pwrNet, JNetwork gndNet, StringBuffer infstr) {
        Topology.CellSignal cs;
        int j;
        boolean breakBus = false;
        int numExported = 0;
        int numInternal = 0;
        for (j = lowIndex; j <= highIndex; ++j) {
            cs = outerSignalList[j - lowIndex];
            if (cs.isPower() || cs.isGround()) {
                breakBus = true;
                break;
            }
            if (cs.isExported()) {
                ++numExported;
                continue;
            }
            ++numInternal;
        }
        if (numExported > 0 && numInternal > 0) {
            breakBus = true;
        }
        if (!breakBus) {
            for (j = lowIndex + 1; j <= highIndex; ++j) {
                Topology.CellSignal oCs;
                int k;
                cs = outerSignalList[j - lowIndex];
                for (k = lowIndex; k < j && cs != (oCs = outerSignalList[k - lowIndex]); ++k) {
                }
                if (k < j) break;
            }
            if (j <= highIndex) {
                breakBus = true;
            } else {
                String lastnetname = null;
                for (j = lowIndex; j <= highIndex; ++j) {
                    int openSquare;
                    Topology.CellSignal wl = outerSignalList[j - lowIndex];
                    String thisnetname = wl.getName();
                    if ((!wl.isDescending() ? descending : !descending) || (openSquare = thisnetname.indexOf(91)) < 0) break;
                    if (j > lowIndex) {
                        int li;
                        for (li = 0; li < lastnetname.length() && thisnetname.charAt(li) == lastnetname.charAt(li) && lastnetname.charAt(li) != '['; ++li) {
                        }
                        if (lastnetname.charAt(li) != '[' || thisnetname.charAt(li) != '[' || TextUtils.atoi(thisnetname.substring(li + 1)) != TextUtils.atoi(lastnetname.substring(li + 1)) + 1) break;
                    }
                    lastnetname = thisnetname;
                }
                if (j <= highIndex) {
                    breakBus = true;
                }
            }
        }
        if (name != null) {
            infstr.append("." + name + "(");
        }
        if (breakBus) {
            infstr.append("{");
            int start = lowIndex;
            int end = highIndex;
            int order = 1;
            if (descending) {
                start = highIndex;
                end = lowIndex;
                order = -1;
            }
            int j2 = start;
            while (true) {
                if (j2 != start) {
                    infstr.append(", ");
                }
                Topology.CellSignal cs2 = outerSignalList[j2 - lowIndex];
                infstr.append(cs2.getName());
                if (j2 == end) break;
                j2 += order;
            }
            infstr.append("}");
        } else {
            int i;
            Topology.CellSignal lastCs = outerSignalList[0];
            String lastNetName = lastCs.getName();
            int openSquare = lastNetName.indexOf(91);
            Topology.CellSignal cs3 = outerSignalList[highIndex - lowIndex];
            String netName = cs3.getName();
            for (i = 0; i < netName.length() && netName.charAt(i) != '['; ++i) {
                infstr.append(netName.charAt(i));
            }
            if (descending) {
                int first = TextUtils.atoi(netName.substring(i + 1));
                int second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + first + ":" + second + "]");
            } else {
                int first = TextUtils.atoi(netName.substring(i + 1));
                int second = TextUtils.atoi(lastNetName.substring(openSquare + 1));
                infstr.append("[" + second + ":" + first + "]");
            }
        }
        if (name != null) {
            infstr.append(")");
        }
    }

    private boolean includeTypedCode(Cell cell, Variable.Key verilogkey, String descript) {
        boolean first = true;
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Object obj;
            Variable var;
            NodeInst ni = (NodeInst)it.next();
            if (ni.getProto() != Generic.tech.invisiblePinNode || (var = ni.getVar(verilogkey)) == null || !var.isDisplay() || !((obj = var.getObject()) instanceof String) && !(obj instanceof String[])) continue;
            if (first) {
                first = false;
                this.printWriter.print("  /* user-specified Verilog " + descript + " */\n");
            }
            if (obj instanceof String) {
                this.printWriter.print("  " + (String)obj + "\n");
                continue;
            }
            String[] stringArray = (String[])obj;
            int len = stringArray.length;
            for (int i = 0; i < len; ++i) {
                this.printWriter.print("  " + stringArray[i] + "\n");
            }
        }
        if (!first) {
            this.printWriter.print("\n");
        }
        return first;
    }

    private void writeLongLine(String s) {
        while (s.length() > 80) {
            int lastSpace = s.lastIndexOf(32, 80);
            if (lastSpace < 0) {
                lastSpace = s.length();
            }
            this.printWriter.print(s.substring(0, lastSpace) + "\n      ");
            while (lastSpace + 1 < s.length() && s.charAt(lastSpace) == ' ') {
                ++lastSpace;
            }
            s = s.substring(lastSpace);
        }
        this.printWriter.print(s + "\n");
    }

    private void initDeclaration(String header) {
        this.sim_verDeclarationLine = new StringBuffer();
        this.sim_verDeclarationLine.append(header);
        this.sim_verdeclarationprefix = header.length();
    }

    private void addDeclaration(String signame) {
        if (this.sim_verDeclarationLine.length() + signame.length() + 3 > 80) {
            this.printWriter.print(this.sim_verDeclarationLine.toString() + ";\n");
            this.sim_verDeclarationLine.delete(this.sim_verdeclarationprefix, this.sim_verDeclarationLine.length());
        }
        if (this.sim_verDeclarationLine.length() != this.sim_verdeclarationprefix) {
            this.sim_verDeclarationLine.append(",");
        }
        this.sim_verDeclarationLine.append(" " + signame);
    }

    private void termDeclaration() {
        this.printWriter.print(this.sim_verDeclarationLine.toString() + ";\n");
    }

    private String nameNoIndices(String p) {
        StringBuffer sb = new StringBuffer();
        if (Character.isDigit(p.charAt(0))) {
            sb.append('_');
        }
        for (int i = 0; i < p.length(); ++i) {
            int chr = p.charAt(i);
            if (!Character.isLetterOrDigit((char)chr) && chr != 95 && chr != 36) {
                chr = 95;
            }
            sb.append((char)chr);
        }
        return sb.toString();
    }

    protected String getSafeCellName(String name) {
        return this.getSafeNetName(name);
    }

    protected String getPowerName() {
        return "vdd";
    }

    protected String getGroundName() {
        return "gnd";
    }

    protected String getGlobalName(Global glob) {
        return "glbl." + glob.getName();
    }

    protected boolean isNetworksUseExportedNames() {
        return true;
    }

    protected String getSafeNetName(String name) {
        boolean allAlnum = true;
        int len = name.length();
        if (len == 0) {
            return name;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isLetterOrDigit(name.charAt(i))) continue;
            allAlnum = false;
            break;
        }
        if (allAlnum && Character.isLetter(name.charAt(0))) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        for (int t = 0; t < name.length(); ++t) {
            char chr = name.charAt(t);
            if (chr == '[' || chr == ']') {
                sb.append('_');
                if (t + 1 >= name.length() || chr != ']' || name.charAt(t + 1) != '[') continue;
                ++t;
                continue;
            }
            if (Character.isLetterOrDigit(chr) || chr == '$') {
                sb.append(chr);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    protected Netlist getNetlistForCell(Cell cell) {
        boolean shortResistors = true;
        Netlist netList = cell.getNetlist(shortResistors);
        return netList;
    }

    protected boolean canParameterizeNames() {
        return true;
    }
}

