/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.netlist.BadTransistorType;
import com.sun.electric.tool.ncc.netlist.ExportGlobalConflict;
import com.sun.electric.tool.ncc.netlist.Visitor;
import com.sun.electric.tool.ncc.processing.HierarchyInfo;
import java.util.ArrayList;

public class NccNetlist {
    private final NccGlobals globals;
    private final Cell rootCell;
    private final VarContext rootContext;
    private ArrayList wires;
    private ArrayList parts;
    private ArrayList ports;
    private boolean exportAssertionFailures;
    private boolean exportGlobalConflicts;
    private boolean badTransistorType;

    public NccNetlist(Cell root, VarContext context, Netlist netlist, HierarchyInfo hierInfo, boolean blackBox, NccGlobals globals) {
        this.globals = globals;
        this.rootCell = root;
        this.rootContext = context;
        try {
            Visitor v = new Visitor(globals, hierInfo, blackBox, context);
            HierarchyEnumerator.enumerateCell(root, context, netlist, v, true);
            this.wires = v.getWireList();
            this.parts = v.getPartList();
            this.ports = v.getPortList();
            this.exportAssertionFailures = v.exportAssertionFailures();
        }
        catch (RuntimeException e) {
            if (e instanceof ExportGlobalConflict) {
                this.exportGlobalConflicts = true;
            }
            if (e instanceof BadTransistorType) {
                this.badTransistorType = true;
            }
            throw e;
        }
        if (this.netlistErrors()) {
            this.parts = this.ports = new ArrayList();
            this.wires = this.ports;
        }
    }

    public ArrayList getWireArray() {
        return this.wires;
    }

    public ArrayList getPartArray() {
        return this.parts;
    }

    public ArrayList getPortArray() {
        return this.ports;
    }

    public boolean netlistErrors() {
        return this.exportAssertionFailures || this.exportGlobalConflicts || this.badTransistorType;
    }

    public Cell getRootCell() {
        return this.rootCell;
    }

    public VarContext getRootContext() {
        return this.rootContext;
    }
}

