/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.topology;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.PrimitiveNode;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class PortInst
extends ElectricObject {
    private final NodeInst nodeInst;
    private final PortProto portProto;
    static final /* synthetic */ boolean $assertionsDisabled;

    private PortInst(PortProto portProto, NodeInst nodeInst) {
        this.portProto = portProto;
        this.nodeInst = nodeInst;
    }

    public static PortInst newInstance(PortProto portProto, NodeInst nodeInst) {
        PortInst pi = new PortInst(portProto, nodeInst);
        return pi;
    }

    public NodeInst getNodeInst() {
        return this.nodeInst;
    }

    public PortProto getPortProto() {
        return this.portProto;
    }

    public final int getPortIndex() {
        return this.portProto.getPortIndex();
    }

    public Iterator getConnections() {
        Connection c;
        ArrayList<Connection> connections = new ArrayList<Connection>();
        Iterator it = this.nodeInst.getConnections(this.getPortIndex());
        while (it.hasNext() && (c = (Connection)it.next()).getPortInst() == this) {
            connections.add(c);
        }
        return connections.iterator();
    }

    public Iterator getExports() {
        ArrayList<Export> exports = new ArrayList<Export>();
        Iterator it = this.nodeInst.getExports();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            if (e.getOriginalPort() != this) continue;
            exports.add(e);
        }
        return exports.iterator();
    }

    void updateShrinkage() {
        Connection con;
        NodeProto np = this.nodeInst.getProto();
        if (!(np instanceof PrimitiveNode)) {
            return;
        }
        PrimitiveNode pn = (PrimitiveNode)np;
        boolean canShrink = false;
        if (!pn.isArcsShrink() && !canShrink) {
            return;
        }
        byte shrink = this.checkShortening(canShrink);
        Iterator it = this.nodeInst.getConnections(this.getPortIndex());
        while (it.hasNext() && (con = (Connection)it.next()).getPortInst() == this) {
            con.setEndShrink(shrink);
        }
    }

    private byte checkShortening(boolean canShrink) {
        int shrink;
        Connection con;
        int ang0 = -1;
        int ang1 = -1;
        Iterator it = this.nodeInst.getConnections(this.getPortIndex());
        while (it.hasNext() && (con = (Connection)it.next()).getPortInst() == this) {
            ArcInst ai = con.getArc();
            if (ai.getWidth() == 0.0) continue;
            int angle = ai.getAngle();
            if ((angle %= 1800) == ang0 || angle == ang1) continue;
            if (ang0 < 0) {
                ang0 = angle;
                continue;
            }
            if (ang1 < 0) {
                ang1 = angle;
                continue;
            }
            return 0;
        }
        if (ang1 < 0) {
            return 0;
        }
        int ang = Math.abs(ang0 - ang1);
        if (ang > 900) {
            ang = 1800 - ang;
        }
        if ((shrink = (ang + 5) / 10) == 0 && ang != 0) {
            shrink = 1;
        }
        return (byte)shrink;
    }

    public void disconnect() {
        Iterator it = this.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            this.delVar(var.getKey());
        }
        if (!$assertionsDisabled && this.getNumVariables() != 0) {
            throw new AssertionError();
        }
        it = this.getConnections();
        while (it.hasNext()) {
            Connection con = (Connection)it.next();
            ArcInst ai = con.getArc();
            if (!ai.isLinked()) continue;
            ai.kill();
        }
        it = this.getExports();
        while (it.hasNext()) {
            Export export = (Export)it.next();
            export.kill();
        }
    }

    public PortProto getProtoEquivalent() {
        return this.portProto instanceof Export ? ((Export)this.portProto).getEquivalent() : this.portProto;
    }

    public Rectangle2D getBounds() {
        Poly poly = this.nodeInst.getShapeOfPort(this.portProto);
        Rectangle2D r = poly.getBounds2D();
        return r;
    }

    public Poly getPoly() {
        return this.nodeInst.getShapeOfPort(this.portProto);
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow_ wnd, boolean multipleStrings) {
        if (super.numDisplayableVariables(multipleStrings) == 0) {
            return 0;
        }
        Poly portPoly = this.getPoly();
        int justAdded = super.addDisplayableVariables(portPoly.getBounds2D(), polys, start, wnd, multipleStrings);
        for (int i = 0; i < justAdded; ++i) {
            polys[start + i].setPort(this.getPortProto());
        }
        return justAdded;
    }

    public String describe(boolean withQuotes) {
        String info = this.nodeInst.describe(false) + "." + this.portProto.getName();
        return withQuotes ? "'" + info + "'" : info;
    }

    public String toString() {
        return "port " + this.describe(true);
    }

    public boolean compare(Object obj, StringBuffer buffer) {
        Poly noPoly;
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PortInst no = (PortInst)obj;
        HashSet<Connection> noCheckAgain = new HashSet<Connection>();
        Iterator it = this.getConnections();
        while (it.hasNext()) {
            Connection c = (Connection)it.next();
            boolean found = false;
            Iterator noIt = no.getConnections();
            while (noIt.hasNext()) {
                Connection noC = (Connection)noIt.next();
                if (noCheckAgain.contains(noC) || !c.getLocation().equals(noC.getLocation())) continue;
                found = true;
                noCheckAgain.add(noC);
                break;
            }
            if (found) continue;
            if (buffer != null) {
                buffer.append("No corresponding port " + this + " found in " + no + "\n");
            }
            return false;
        }
        Poly poly = this.getPoly();
        boolean check = poly.compare(noPoly = no.getPoly(), buffer);
        if (!check && buffer != null) {
            buffer.append("No same ports detected in " + this.portProto.getName() + " and " + no.getPortProto().getName() + "\n");
        }
        return check;
    }

    public boolean isLinked() {
        try {
            return this.nodeInst != null && this.nodeInst.isLinked() && this.nodeInst.getPortInst(this.getPortIndex()) == this;
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public Poly computeTextPoly(EditWindow_ wnd, Variable var, Name name) {
        Rectangle2D bounds;
        Poly[] polys;
        Poly poly = null;
        if (var != null && (polys = this.getPolyList(var, (bounds = this.getPoly().getBounds2D()).getCenterX(), bounds.getCenterY(), wnd, false)).length > 0) {
            poly = polys[0];
            poly.transform(this.getNodeInst().rotateOut());
        }
        if (poly != null) {
            poly.setExactTextBounds(wnd, this);
        }
        return poly;
    }

    static {
        $assertionsDisabled = !PortInst.class.desiredAssertionStatus();
    }
}

