/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

public class InvCTLn {
    private static final double wellOverhangDiff = 6.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;
    private static final double wirePitch = 7.0;
    private static final double wireWithPolyPitch = 8.0;
    private static final double pmosBot = 8.5;
    private static final double nmosTop = -8.5;
    private static final double inY = 4.0;
    private static final double ctlY = -4.0;

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(double sz, StdCellParams stdCell) {
        int i;
        double totWid;
        String nm = "invCTLn";
        sz = stdCell.roundSize(sz);
        sz = stdCell.checkMinStrength(sz, 0.5, nm);
        int nbSeriesN = 2;
        double spaceAvail = -8.5 - (stdCell.getCellBot() + 6.0);
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid = sz * (double)nbSeriesN * 3.0, 1);
        InvCTLn.error(fwN == null, "can't make " + nm + " this small: " + sz);
        spaceAvail = stdCell.getCellTop() - 6.0 - 8.5;
        totWid = sz * 6.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        InvCTLn.error(fwP == null, "can't make " + nm + " this small: " + sz);
        Cell inv = stdCell.findPart(nm, sz);
        if (inv != null) {
            return inv;
        }
        inv = stdCell.newPart(nm, sz);
        double inX = 3.5;
        double pmosX = inX + 7.0;
        double pmosY = 8.5 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(fwP.nbFolds + 1) / 2];
        for (int nbFoldsP = 0; nbFoldsP < fwP.nbFolds; nbFoldsP += 2) {
            double pmosPitch = 26.0;
            double x = pmosX + (double)(nbFoldsP / 2) * pmosPitch;
            int nbFolds = Math.min(2, fwP.nbFolds - nbFoldsP);
            FoldedPmos pmos = new FoldedPmos(x, pmosY, nbFolds, 1, fwP.gateWid, inv, stdCell);
            pmoss[nbFoldsP / 2] = pmos;
        }
        stdCell.fillDiffAndSelectNotches(pmoss, true);
        double nmosX = pmosX + 8.0;
        double nmosY = -8.5 - fwN.physWid / 2.0;
        FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, fwN.nbFolds, nbSeriesN, fwN.gateWid, inv, stdCell);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, inv);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, inv);
        LayoutLib.newExport(inv, "in", PortCharacteristic.IN, Tech.m1, 4.0, inX, 4.0);
        TrackRouterH in = new TrackRouterH(Tech.m1, 3.0, 4.0, inv);
        in.connect(inv.findExport("in"));
        for (i = 0; i < pmoss.length; ++i) {
            FoldedMos pmos = pmoss[i];
            ((TrackRouter)in).connect(pmos.getGate(0, 'B'), 4.0, Tech.getPolyLShapeOffset());
            if (pmos.nbGates() != 2) continue;
            ((TrackRouter)in).connect(pmos.getGate(1, 'B'), -4.0, Tech.getPolyLShapeOffset());
        }
        for (i = 0; i < nmos.nbGates(); i += 2) {
            if (i / 2 % 2 == 0) {
                ((TrackRouter)in).connect(nmos.getGate(i, 'T'), -4.0, -Tech.getPolyTShapeOffset());
                continue;
            }
            ((TrackRouter)in).connect(nmos.getGate(i + 1, 'T'), 4.0, -Tech.getPolyTShapeOffset());
        }
        double rightDiffX = StdCellParams.getRightDiffX(nmos, pmoss);
        double ctlX = rightDiffX + 7.0;
        LayoutLib.newExport(inv, "ctl", PortCharacteristic.IN, Tech.m1, 4.0, ctlX, -4.0);
        TrackRouterH ctl = new TrackRouterH(Tech.m1, 3.0, -4.0, inv);
        ctl.connect(inv.findExport("ctl"));
        for (int i2 = 0; i2 < nmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                ((TrackRouter)ctl).connect(nmos.getGate(i2 + 1, 'T'), 4.0, -Tech.getPolyLShapeOffset());
                continue;
            }
            ((TrackRouter)ctl).connect(nmos.getGate(i2, 'T'), -4.0, -Tech.getPolyLShapeOffset());
        }
        double outX = ctlX + 7.0;
        LayoutLib.newExport(inv, "out", PortCharacteristic.OUT, Tech.m1, 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(Tech.m2, 4.0, 11.0, inv);
        outHi.connect(inv.findExport("out"));
        for (int i3 = 0; i3 < pmoss.length; ++i3) {
            outHi.connect(pmoss[i3].getSrcDrn(1));
        }
        TrackRouterH outLo = new TrackRouterH(Tech.m2, 4.0, -11.0, inv);
        outLo.connect(inv.findExport("out"));
        for (int i4 = 1; i4 < nmos.nbSrcDrns(); i4 += 2) {
            outLo.connect(nmos.getSrcDrn(i4));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, inv);
        stdCell.addPmosWell(wellMinX, wellMaxX, inv);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, inv);
        stdCell.doNCC(inv, nm + "{sch}");
        return inv;
    }
}

