/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.Geometric;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.FPGA;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.Clipboard;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.Array;
import com.sun.electric.tool.user.dialogs.ArtworkLook;
import com.sun.electric.tool.user.dialogs.Attributes;
import com.sun.electric.tool.user.dialogs.BusParameters;
import com.sun.electric.tool.user.dialogs.Change;
import com.sun.electric.tool.user.dialogs.ChangeText;
import com.sun.electric.tool.user.dialogs.EditKeyBindings;
import com.sun.electric.tool.user.dialogs.FindText;
import com.sun.electric.tool.user.dialogs.GetInfoArc;
import com.sun.electric.tool.user.dialogs.GetInfoExport;
import com.sun.electric.tool.user.dialogs.GetInfoMulti;
import com.sun.electric.tool.user.dialogs.GetInfoNode;
import com.sun.electric.tool.user.dialogs.GetInfoOutline;
import com.sun.electric.tool.user.dialogs.GetInfoText;
import com.sun.electric.tool.user.dialogs.MoveBy;
import com.sun.electric.tool.user.dialogs.SelectObject;
import com.sun.electric.tool.user.dialogs.SpecialProperties;
import com.sun.electric.tool.user.dialogs.Spread;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.tecEdit.LibToTech;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.TechToLib;
import com.sun.electric.tool.user.ui.CurveListener;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.ErrorLoggerTree;
import com.sun.electric.tool.user.ui.OutlineListener;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.SizeListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;

public class EditMenu {
    static EMenu makeMenu() {
        return new EMenu("_Edit", new EMenuItem("Cu_t", 'X'){

            public void run() {
                Clipboard.cut();
            }
        }, new EMenuItem("Cop_y", 'C'){

            public void run() {
                Clipboard.copy();
            }
        }, new EMenuItem("_Paste", 'V'){

            public void run() {
                Clipboard.paste();
            }
        }, new EMenuItem("Dup_licate", 'M'){

            public void run() {
                Clipboard.duplicate();
            }
        }, EMenuItem.SEPARATOR, ToolBar.undoCommand, ToolBar.redoCommand, new EMenuItem("Sho_w Undo List"){

            public void run() {
                EditMenu.showUndoListCommand();
            }
        }, new EMenuItem("Repeat Last Action", KeyStroke.getKeyStroke('&')){

            public void run() {
                EMenuItem.repeatLastCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenu("_Rotate", new EMenuItem("90 Degrees Clock_wise"){

            public void run() {
                CircuitChanges.rotateObjects(2700);
            }
        }, new EMenuItem("90 Degrees _Counterclockwise", 'J'){

            public void run() {
                CircuitChanges.rotateObjects(900);
            }
        }, new EMenuItem("180 _Degrees"){

            public void run() {
                CircuitChanges.rotateObjects(1800);
            }
        }, new EMenuItem("_Other..."){

            public void run() {
                CircuitChanges.rotateObjects(0);
            }
        }), new EMenu("_Mirror", new EMenuItem("_Up <-> Down"){

            public void run() {
                CircuitChanges.mirrorObjects(true);
            }
        }, new EMenuItem("_Left <-> Right"){

            public void run() {
                CircuitChanges.mirrorObjects(false);
            }
        }), new EMenu("Si_ze", new EMenuItem("_Interactively", 'B'){

            public void run() {
                SizeListener.sizeObjects();
            }
        }, new EMenuItem("All Selected _Nodes..."){

            public void run() {
                SizeListener.sizeAllNodes();
            }
        }, new EMenuItem("All Selected _Arcs..."){

            public void run() {
                SizeListener.sizeAllArcs();
            }
        }), new EMenu("Mo_ve", new EMenuItem("_Spread..."){

            public void run() {
                Spread.showSpreadDialog();
            }
        }, new EMenuItem("_Move Objects By..."){

            public void run() {
                MoveBy.showMoveByDialog();
            }
        }, new EMenuItem("_Align to Grid"){

            public void run() {
                CircuitChanges.alignToGrid();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Align Horizontally to _Left"){

            public void run() {
                CircuitChanges.alignNodes(true, 0);
            }
        }, new EMenuItem("Align Horizontally to _Right"){

            public void run() {
                CircuitChanges.alignNodes(true, 1);
            }
        }, new EMenuItem("Align Horizontally to _Center"){

            public void run() {
                CircuitChanges.alignNodes(true, 2);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Align Vertically to _Top"){

            public void run() {
                CircuitChanges.alignNodes(false, 0);
            }
        }, new EMenuItem("Align Vertically to _Bottom"){

            public void run() {
                CircuitChanges.alignNodes(false, 1);
            }
        }, new EMenuItem("Align _Vertically to Center"){

            public void run() {
                CircuitChanges.alignNodes(false, 2);
            }
        }), EMenuItem.SEPARATOR, new EMenu("_Erase", new EMenuItem("_Selected", KeyStroke.getKeyStroke(127, 0), KeyStroke.getKeyStroke(8, 0)){

            public void run() {
                CircuitChanges.deleteSelected();
            }
        }, new EMenuItem("_Arcs Connected to Selected Nodes"){

            public void run() {
                CircuitChanges.deleteArcsOnSelected(false);
            }
        }, new EMenuItem("Arcs Connected _Between Selected Nodes"){

            public void run() {
                CircuitChanges.deleteArcsOnSelected(true);
            }
        }), new EMenuItem("_Array...", KeyStroke.getKeyStroke(117, 0)){

            public void run() {
                Array.showArrayDialog();
            }
        }, new EMenuItem("C_hange...", KeyStroke.getKeyStroke(67, 0)){

            public void run() {
                Change.showChangeDialog();
            }
        }, EMenuItem.SEPARATOR, new EMenu("Propert_ies", new EMenuItem("_Object Properties...", 'I'){

            public void run() {
                EditMenu.getInfoCommand(false);
            }
        }, new EMenuItem("_Attribute Properties..."){

            public void run() {
                Attributes.showDialog();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_See All Attributes on Node"){

            public void run() {
                EditMenu.seeAllParametersCommand();
            }
        }, new EMenuItem("_Hide All Attributes on Node"){

            public void run() {
                EditMenu.hideAllParametersCommand();
            }
        }, new EMenuItem("_Default Attribute Visibility"){

            public void run() {
                EditMenu.defaultParamVisibilityCommand();
            }
        }, new EMenuItem("Update Attributes Inheritance on _Node"){

            public void run() {
                EditMenu.updateInheritance(false);
            }
        }, new EMenuItem("Update Attributes Inheritance all _Libraries"){

            public void run() {
                EditMenu.updateInheritance(true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Parameterize _Bus Name"){

            public void run() {
                BusParameters.makeBusParameter();
            }
        }, new EMenuItem("_Edit Bus Parameters..."){

            public void run() {
                BusParameters.showBusParametersDialog();
            }
        }), new EMenu("Ar_c", new EMenuItem("_Rigid"){

            public void run() {
                CircuitChanges.arcRigidCommand();
            }
        }, new EMenuItem("_Not Rigid"){

            public void run() {
                CircuitChanges.arcNotRigidCommand();
            }
        }, new EMenuItem("_Fixed Angle"){

            public void run() {
                CircuitChanges.arcFixedAngleCommand();
            }
        }, new EMenuItem("Not Fixed _Angle"){

            public void run() {
                CircuitChanges.arcNotFixedAngleCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Toggle _Directionality"){

            public void run() {
                CircuitChanges.arcDirectionalCommand();
            }
        }, new EMenuItem("Toggle End Extension of Both Head/Tail"){

            public void run() {
                CircuitChanges.arcHeadExtendCommand();
                CircuitChanges.arcTailExtendCommand();
            }
        }, new EMenuItem("Toggle End Extension of _Head"){

            public void run() {
                CircuitChanges.arcHeadExtendCommand();
            }
        }, new EMenuItem("Toggle End Extension of _Tail"){

            public void run() {
                CircuitChanges.arcTailExtendCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Insert _Jog In Arc"){

            public void run() {
                EditMenu.insertJogInArcCommand();
            }
        }, new EMenuItem("Rip _Bus"){

            public void run() {
                CircuitChanges.ripBus();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Curve through Cursor"){

            public void run() {
                CurveListener.setCurvature(true);
            }
        }, new EMenuItem("Curve abo_ut Cursor"){

            public void run() {
                CurveListener.setCurvature(false);
            }
        }, new EMenuItem("Re_move Curvature"){

            public void run() {
                CurveListener.removeCurvature();
            }
        }), ToolBar.modesSubMenu, new EMenu("Te_xt", new EMenuItem("_Find Text...", 'L'){

            public void run() {
                FindText.findTextDialog();
            }
        }, new EMenuItem("_Change Text Size..."){

            public void run() {
                ChangeText.changeTextDialog();
            }
        }, new EMenuItem("_Increase All Text Size", '='){

            public void run() {
                EditMenu.changeGlobalTextSize(1.25);
            }
        }, new EMenuItem("_Decrease All Text Size", '-'){

            public void run() {
                EditMenu.changeGlobalTextSize(0.8);
            }
        }, new EMenuItem("Add _Text Annotation", KeyStroke.getKeyStroke(84, 0)){

            public void run() {
                PaletteFrame.placeInstance("ART_message", null, false);
            }
        }), new EMenu("Clea_nup Cell", new EMenuItem("Cleanup _Pins"){

            public void run() {
                CircuitChanges.cleanupPinsCommand(false);
            }
        }, new EMenuItem("Cleanup Pins _Everywhere"){

            public void run() {
                CircuitChanges.cleanupPinsCommand(true);
            }
        }, new EMenuItem("Show _Nonmanhattan"){

            public void run() {
                CircuitChanges.showNonmanhattanCommand();
            }
        }, new EMenuItem("Show Pure _Layer Nodes"){

            public void run() {
                CircuitChanges.showPureLayerCommand();
            }
        }, new EMenuItem("_Shorten Selected Arcs"){

            public void run() {
                CircuitChanges.shortenArcsCommand();
            }
        }), new EMenu("Technolo_gy Specific", new EMenuItem("Toggle Port _Negation", 'T'){

            public void run() {
                CircuitChanges.toggleNegatedCommand();
            }
        }, new EMenuItem("_Artwork Color and Pattern..."){

            public void run() {
                ArtworkLook.showArtworkLookDialog();
            }
        }, EMenuItem.SEPARATOR, new EMenu("_FPGA", new EMenuItem("Read _Architecture And Primitives..."){

            public void run() {
                FPGA.readArchitectureFile(true);
            }
        }, new EMenuItem("Read P_rimitives..."){

            public void run() {
                FPGA.readArchitectureFile(false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Edit _Pips..."){

            public void run() {
                FPGA.programPips();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Show _No Wires"){

            public void run() {
                FPGA.setWireDisplay(0);
            }
        }, new EMenuItem("Show A_ctive Wires"){

            public void run() {
                FPGA.setWireDisplay(1);
            }
        }, new EMenuItem("Show All _Wires"){

            public void run() {
                FPGA.setWireDisplay(2);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Show Text"){

            public void run() {
                FPGA.setTextDisplay(true);
            }
        }, new EMenuItem("_Hide Text"){

            public void run() {
                FPGA.setTextDisplay(false);
            }
        }), EMenuItem.SEPARATOR, new EMenuItem("Convert Technology to _Library for Editing..."){

            public void run() {
                TechToLib.makeLibFromTech();
            }
        }, new EMenuItem("Convert Library to _Technology..."){

            public void run() {
                LibToTech.makeTechFromLib();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Identify Primitive Layers"){

            public void run() {
                Manipulate.identifyLayers(false);
            }
        }, new EMenuItem("Identify _Ports"){

            public void run() {
                Manipulate.identifyLayers(true);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Edit Library _Dependencies..."){

            public void run() {
                Manipulate.editLibraryDependencies();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Descri_be this Technology"){

            public void run() {
                EditMenu.describeTechnologyCommand();
            }
        }, new EMenuItem("Do_cument Current Technology"){

            public void run() {
                Manipulate.describeTechnology(Technology.getCurrent());
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Rena_me Current Technology..."){

            public void run() {
                CircuitChanges.renameCurrentTechnology();
            }
        }), new EMenu("_Selection", new EMenuItem("Sele_ct All", 'A'){

            public void run() {
                EditMenu.selectAllCommand();
            }
        }, new EMenuItem("Select All _Easy"){

            public void run() {
                EditMenu.selectEasyCommand();
            }
        }, new EMenuItem("Select All _Hard"){

            public void run() {
                EditMenu.selectHardCommand();
            }
        }, new EMenuItem("Select Nothin_g"){

            public void run() {
                EditMenu.selectNothingCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Select All Like _This"){

            public void run() {
                EditMenu.selectAllLikeThisCommand();
            }
        }, new EMenuItem("Select _Next Like This"){

            public void run() {
                EditMenu.selectNextLikeThisCommand(true);
            }
        }, new EMenuItem("Select _Previous Like This"){

            public void run() {
                EditMenu.selectNextLikeThisCommand(false);
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Select Object..."){

            public void run() {
                SelectObject.selectObjectDialog(null, false);
            }
        }, new EMenuItem("Deselect All _Arcs"){

            public void run() {
                EditMenu.deselectAllArcsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Make Selected Eas_y"){

            public void run() {
                EditMenu.selectMakeEasyCommand();
            }
        }, new EMenuItem("Make Selected Har_d"){

            public void run() {
                EditMenu.selectMakeHardCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("P_ush Selection"){

            public void run() {
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd == null) {
                    return;
                }
                wnd.getHighlighter().pushHighlight();
            }
        }, new EMenuItem("P_op Selection"){

            public void run() {
                EditWindow wnd = EditWindow.getCurrent();
                if (wnd == null) {
                    return;
                }
                wnd.getHighlighter().popHighlight();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Enclosed Ob_jects"){

            public void run() {
                EditMenu.selectEnclosedObjectsCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Show Ne_xt Error", KeyStroke.getKeyStroke('>')){

            public void run() {
                EditMenu.showNextErrorCommand();
            }
        }, new EMenuItem("Show Pre_vious Error", KeyStroke.getKeyStroke('<')){

            public void run() {
                EditMenu.showPrevErrorCommand();
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("Add to Waveform _in New Panel", KeyStroke.getKeyStroke(65, 0)){

            public void run() {
                EditMenu.addToWaveformNewCommand();
            }
        }, new EMenuItem("Add to _Waveform in Current Panel", KeyStroke.getKeyStroke(79, 0)){

            public void run() {
                EditMenu.addToWaveformCurrentCommand();
            }
        }, new EMenuItem("_Remove from Waveform", KeyStroke.getKeyStroke(82, 0)){

            public void run() {
                EditMenu.removeFromWaveformCommand();
            }
        }));
    }

    public static void keyBindingsCommand() {
        TopLevel top = TopLevel.getCurrentJFrame();
        EditKeyBindings dialog = new EditKeyBindings(top.getEMenuBar(), top, true);
        dialog.setVisible(true);
    }

    public static void getInfoCommand(boolean doubleClick) {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        if (wnd.getHighlighter().getNumHighlights() == 0) {
            Cell c = WindowFrame.getCurrentCell();
            if (c != null) {
                Attributes.showDialog();
            }
        } else {
            int[] counts = new int[5];
            NodeInst theNode = Highlight2.getInfoCommand(wnd.getHighlighter().getHighlights(), counts);
            int arcCount = counts[0];
            int nodeCount = counts[1];
            int exportCount = counts[2];
            int textCount = counts[3];
            int graphicsCount = counts[4];
            if (doubleClick) {
                int opt;
                if (arcCount == 0 && exportCount == 0 && graphicsCount == 0 && nodeCount == 1 ^ textCount == 1 && theNode != null && (opt = Manipulate.getOptionOnNode(theNode)) >= 0) {
                    Manipulate.modifyObject(wnd, theNode, opt);
                    return;
                }
                if (arcCount == 0 && exportCount == 0 && graphicsCount == 0 && nodeCount == 1 && textCount == 0 && theNode != null) {
                    int ret = SpecialProperties.doubleClickOnNode(wnd, theNode);
                    if (ret > 0) {
                        return;
                    }
                    if (ret < 0) {
                        doubleClick = false;
                    }
                }
            }
            if (arcCount <= 1 && nodeCount <= 1 && exportCount <= 1 && textCount <= 1 && graphicsCount == 0) {
                if (arcCount == 1) {
                    GetInfoArc.showDialog();
                }
                if (nodeCount == 1) {
                    if (WindowFrame.getListener() == OutlineListener.theOne) {
                        GetInfoOutline.showOutlinePropertiesDialog();
                    } else {
                        GetInfoNode.showDialog();
                    }
                }
                if (exportCount == 1) {
                    if (doubleClick) {
                        GetInfoText.editTextInPlace();
                    } else {
                        GetInfoExport.showDialog();
                    }
                }
                if (textCount == 1) {
                    if (doubleClick) {
                        GetInfoText.editTextInPlace();
                    } else {
                        GetInfoText.showDialog();
                    }
                }
            } else {
                GetInfoMulti.showDialog();
            }
        }
    }

    public static void seeAllParametersCommand() {
        ParameterVisibility job = new ParameterVisibility(0, MenuCommands.getSelectedObjects(true, false));
    }

    public static void hideAllParametersCommand() {
        ParameterVisibility job = new ParameterVisibility(1, MenuCommands.getSelectedObjects(true, false));
    }

    public static void defaultParamVisibilityCommand() {
        ParameterVisibility job = new ParameterVisibility(2, MenuCommands.getSelectedObjects(true, false));
    }

    public static void updateInheritance(boolean allLibraries) {
        List<Geometric> highlighted = MenuCommands.getSelectedObjects(true, false);
        UpdateAttributes job = new UpdateAttributes(highlighted, allLibraries, 0);
    }

    public static void changeGlobalTextSize(double scale) {
        double curScale = User.getGlobalTextScale();
        if ((curScale *= scale) != 0.0) {
            User.setGlobalTextScale(curScale);
            EditWindow.repaintAllContents();
        }
    }

    public static void selectAllCommand() {
        EditMenu.doSelection(false, false);
    }

    public static void selectEasyCommand() {
        EditMenu.doSelection(true, false);
    }

    public static void selectHardCommand() {
        EditMenu.doSelection(false, true);
    }

    private static void doSelection(boolean mustBeEasy, boolean mustBeHard) {
        Variable var;
        Iterator<Variable> vIt;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        RectangularShape thisPageBounds = null;
        if (curCell.isMultiPage()) {
            int curPage = wnd.getMultiPageNumber();
            Dimension d = new Dimension();
            int frameFactor = Cell.FrameDescription.getCellFrameInfo(curCell, d);
            if (frameFactor == 0 && curCell.isMultiPage()) {
                double offY = (double)curPage * 1000.0;
                thisPageBounds = new Rectangle2D.Double(-d.getWidth() / 2.0, -d.getHeight() / 2.0 + offY, d.getWidth(), d.getHeight());
            }
        }
        boolean cellsAreHard = !User.isEasySelectionOfCellInstances();
        highlighter.clear();
        Iterator<Serializable> it = curCell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            if (thisPageBounds != null && !thisPageBounds.contains(ni.getAnchorCenter()) || ni.getProto() == Generic.tech.cellCenterNode && !mustBeEasy && !mustBeHard) continue;
            boolean hard = ni.isHardSelect();
            if (ni.isCellInstance() && cellsAreHard) {
                hard = true;
            }
            if (mustBeEasy && hard || mustBeHard && !hard) continue;
            if (!ni.isInvisiblePinWithText()) {
                highlighter.addElectricObject(ni, curCell);
            }
            if (!User.isTextVisibilityOnNode()) continue;
            if (ni.isUsernamed()) {
                highlighter.addText(ni, curCell, NodeInst.NODE_NAME);
            }
            vIt = ni.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isDisplay()) continue;
                highlighter.addText(ni, curCell, var.getKey());
            }
        }
        it = curCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (thisPageBounds != null && !thisPageBounds.contains(ai.getHeadLocation())) continue;
            boolean hard = ai.isHardSelect();
            if (mustBeEasy && hard || mustBeHard && !hard) continue;
            highlighter.addElectricObject(ai, curCell);
            if (!User.isTextVisibilityOnArc()) continue;
            if (ai.isUsernamed()) {
                highlighter.addText(ai, curCell, ArcInst.ARC_NAME);
            }
            vIt = ai.getVariables();
            while (vIt.hasNext()) {
                var = vIt.next();
                if (!var.isDisplay()) continue;
                highlighter.addText(ai, curCell, var.getKey());
            }
        }
        it = curCell.getExports();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            highlighter.addText(pp, curCell, null);
        }
        if (User.isTextVisibilityOnCell()) {
            it = curCell.getVariables();
            while (it.hasNext()) {
                Variable var2 = (Variable)it.next();
                if (!var2.isAttribute() || thisPageBounds != null && !thisPageBounds.contains(new Point2D.Double(var2.getXOff(), var2.getYOff()))) continue;
                highlighter.addText(curCell, curCell, var2.getKey());
            }
        }
        highlighter.finished();
    }

    public static void selectAllLikeThisCommand() {
        Object isLikeThis;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        HashMap<Object, Geometric> likeThis = new HashMap<Object, Geometric>();
        List<Geometric> highlighted = highlighter.getHighlightedEObjs(true, true);
        for (Geometric geom : highlighted) {
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                likeThis.put(ni.getProto(), ni);
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            likeThis.put(ai.getProto(), ai);
        }
        highlighter.clear();
        Iterator<Geometric> it = curCell.getNodes();
        block1: while (it.hasNext()) {
            NodeInst ni = it.next();
            isLikeThis = likeThis.get(ni.getProto());
            if (isLikeThis == null) continue;
            if (ni.isInvisiblePinWithText()) {
                Iterator<Variable> vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = vIt.next();
                    if (!var.isDisplay()) continue;
                    highlighter.addText(ni, curCell, var.getKey());
                    continue block1;
                }
                continue;
            }
            highlighter.addElectricObject(ni, curCell);
        }
        it = curCell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            isLikeThis = likeThis.get(ai.getProto());
            if (isLikeThis == null) continue;
            highlighter.addElectricObject(ai, curCell);
        }
        highlighter.finished();
        System.out.println("Selected " + highlighter.getNumHighlights() + " objects");
    }

    public static void selectNextLikeThisCommand(boolean next) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Highlight2 high = highlighter.getOneHighlight();
        if (high == null) {
            return;
        }
        ElectricObject eObj = high.getElectricObject();
        if (high.isHighlightEOBJ()) {
            if (eObj instanceof PortInst) {
                eObj = ((PortInst)eObj).getNodeInst();
            }
            if (eObj instanceof NodeInst) {
                NodeInst thisNi = (NodeInst)eObj;
                NodeInst[] allNodes = new NodeInst[curCell.getNumNodes()];
                int tot = 0;
                int which = 0;
                Iterator<NodeInst> it = curCell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    if (ni.getProto() != thisNi.getProto()) continue;
                    if (ni == thisNi) {
                        which = tot;
                    }
                    allNodes[tot++] = ni;
                }
                if (next) {
                    if (++which >= tot) {
                        which = 0;
                    }
                } else if (--which < 0) {
                    which = tot - 1;
                }
                highlighter.clear();
                highlighter.addElectricObject(allNodes[which], curCell);
                highlighter.finished();
                return;
            }
            if (eObj instanceof ArcInst) {
                ArcInst thisAi = (ArcInst)eObj;
                ArcInst[] allArcs = new ArcInst[curCell.getNumArcs()];
                int tot = 0;
                int which = 0;
                Iterator<ArcInst> it = curCell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = it.next();
                    if (ai.getProto() != thisAi.getProto()) continue;
                    if (ai == thisAi) {
                        which = tot;
                    }
                    allArcs[tot++] = ai;
                }
                if (next) {
                    if (++which >= tot) {
                        which = 0;
                    }
                } else if (--which < 0) {
                    which = tot - 1;
                }
                highlighter.clear();
                highlighter.addElectricObject(allArcs[which], curCell);
                highlighter.finished();
                return;
            }
        }
        if (high.isHighlightText() && eObj instanceof Export) {
            Export[] allExports = new Export[curCell.getNumPorts()];
            int i = 0;
            int which = 0;
            Iterator<Export> it = curCell.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (e == eObj) {
                    which = i;
                }
                allExports[i++] = e;
            }
            if (next) {
                if (++which >= allExports.length) {
                    which = 0;
                }
            } else if (--which < 0) {
                which = allExports.length - 1;
            }
            highlighter.clear();
            highlighter.addText(allExports[which], curCell, Export.EXPORT_NAME);
            highlighter.finished();
            return;
        }
        System.out.println("Cannot advance the current selection");
    }

    public static void selectNothingCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        wnd.getHighlighter().clear();
        wnd.getHighlighter().finished();
    }

    public static void deselectAllArcsCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        ArrayList<Highlight2> newHighList = new ArrayList<Highlight2>();
        for (Highlight2 h : highlighter.getHighlights()) {
            if ((h.isHighlightEOBJ() || h.isHighlightText()) && h.getElectricObject() instanceof ArcInst) continue;
            newHighList.add(h);
        }
        highlighter.clear();
        highlighter.setHighlightList(newHighList);
        highlighter.finished();
    }

    public static void selectMakeEasyCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        List<Geometric> highlighted = wnd.getHighlighter().getHighlightedEObjs(true, true);
        new SetEasyHardSelect(true, highlighted);
    }

    public static void selectMakeHardCommand() {
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null) {
            return;
        }
        List<Geometric> highlighted = wnd.getHighlighter().getHighlightedEObjs(true, true);
        new SetEasyHardSelect(false, highlighted);
    }

    public static void selectEnclosedObjectsCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Rectangle2D selection = highlighter.getHighlightedArea(wnd);
        highlighter.clear();
        if (selection != null) {
            highlighter.selectArea(wnd, selection.getMinX(), selection.getMaxX(), selection.getMinY(), selection.getMaxY(), false, ToolBar.isSelectSpecial());
        }
        highlighter.finished();
    }

    public static void showNextErrorCommand() {
        String msg = ErrorLoggerTree.reportNextMessage();
        System.out.println(msg);
    }

    public static void showPrevErrorCommand() {
        String msg = ErrorLoggerTree.reportPrevMessage();
        System.out.println(msg);
    }

    public static void addToWaveformNewCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        WaveformWindow.Locator wwLoc = new WaveformWindow.Locator(wnd);
        WaveformWindow ww = wwLoc.getWaveformWindow();
        if (ww == null) {
            System.out.println("Cannot add selected signals to the waveform window: no waveform window is associated with this cell");
            return;
        }
        ww.showSignals(wnd.getHighlighter(), wwLoc.getContext(), true);
    }

    public static void addToWaveformCurrentCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        WaveformWindow.Locator wwLoc = new WaveformWindow.Locator(wnd);
        WaveformWindow ww = wwLoc.getWaveformWindow();
        if (ww == null) {
            System.out.println("Cannot overlay selected signals to the waveform window: no waveform window is associated with this cell");
            return;
        }
        ww.showSignals(wnd.getHighlighter(), wwLoc.getContext(), false);
    }

    public static void removeFromWaveformCommand() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (!(wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)wf.getContent();
        WaveformWindow.Locator wwLoc = new WaveformWindow.Locator(wnd);
        WaveformWindow ww = wwLoc.getWaveformWindow();
        if (ww == null) {
            System.out.println("Cannot remove selected signals from the waveform window: no waveform window is associated with this cell");
            return;
        }
        Set<Network> nets = wnd.getHighlighter().getHighlightedNetworks();
        ww.removeSignals(nets, wwLoc.getContext());
    }

    public static void insertJogInArcCommand() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        ArcInst ai = (ArcInst)wnd.getHighlighter().getOneElectricObject(ArcInst.class);
        if (ai == null) {
            return;
        }
        System.out.println("Select the position in the arc to place the jog");
        EventListener currentListener = WindowFrame.getListener();
        WindowFrame.setListener(new InsertJogInArcListener(wnd, ai, currentListener));
    }

    public static void showUndoListCommand() {
        Undo.showHistoryList();
    }

    public static void describeTechnologyCommand() {
        PrimitiveNode.Function fun;
        PrimitiveNode np;
        Technology tech = Technology.getCurrent();
        System.out.println("Technology " + tech.getTechName());
        System.out.println("    Full name: " + tech.getTechDesc());
        if (tech.isScaleRelevant()) {
            System.out.println("    Scale: 1 grid unit is " + tech.getScale() + " nanometers (" + tech.getScale() / 1000.0 + " microns)");
        }
        int arcCount = 0;
        Iterator<ArcProto> it = tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            if (ap.isNotUsed()) continue;
            ++arcCount;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("    Has " + arcCount + " arcs (wires):");
        Iterator<ArcProto> it2 = tech.getArcs();
        while (it2.hasNext()) {
            ArcProto ap = it2.next();
            if (ap.isNotUsed()) continue;
            sb.append(" " + ap.getName());
        }
        System.out.println(sb.toString());
        int pinCount = 0;
        int totalCount = 0;
        int pureCount = 0;
        int contactCount = 0;
        Iterator<PrimitiveNode> it3 = tech.getNodes();
        while (it3.hasNext()) {
            np = it3.next();
            if (np.isNotUsed()) continue;
            fun = np.getFunction();
            ++totalCount;
            if (fun == PrimitiveNode.Function.PIN) {
                ++pinCount;
                continue;
            }
            if (fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT) {
                ++contactCount;
                continue;
            }
            if (fun != PrimitiveNode.Function.NODE) continue;
            ++pureCount;
        }
        if (pinCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + pinCount + " pin nodes for making bends in arcs:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.PIN) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (contactCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + contactCount + " contact nodes for joining different arcs:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.CONNECT) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (pinCount + contactCount + pureCount < totalCount) {
            sb = new StringBuffer();
            sb.append("    Has " + (totalCount - pinCount - contactCount - pureCount) + " regular nodes:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) == PrimitiveNode.Function.PIN || fun == PrimitiveNode.Function.CONTACT || fun == PrimitiveNode.Function.CONNECT || fun == PrimitiveNode.Function.NODE) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
        if (pureCount > 0) {
            sb = new StringBuffer();
            sb.append("    Has " + pureCount + " pure-layer nodes for creating custom geometry:");
            it3 = tech.getNodes();
            while (it3.hasNext()) {
                np = it3.next();
                if (np.isNotUsed() || (fun = np.getFunction()) != PrimitiveNode.Function.NODE) continue;
                sb.append(" " + np.getName());
            }
            System.out.println(sb.toString());
        }
    }

    private static class InsertJogInArcListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        private EditWindow wnd;
        private ArcInst ai;
        private EventListener currentListener;

        public InsertJogInArcListener(EditWindow wnd, ArcInst ai, EventListener currentListener) {
            this.wnd = wnd;
            this.ai = ai;
            this.currentListener = currentListener;
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseDragged(MouseEvent evt) {
            this.mouseMoved(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            Point2D insert2D = this.getInsertPoint(evt);
            EPoint insert = new EPoint(insert2D.getX(), insert2D.getY());
            InsertJogPoint job = new InsertJogPoint(this.ai, insert, this.wnd.getHighlighter());
            WindowFrame.setListener(this.currentListener);
        }

        public void mouseMoved(MouseEvent evt) {
            Point2D insert = this.getInsertPoint(evt);
            double x = insert.getX();
            double y = insert.getY();
            double width = (this.ai.getWidth() - this.ai.getProto().getWidthOffset()) / 2.0;
            Highlighter highlighter = this.wnd.getHighlighter();
            highlighter.clear();
            highlighter.addLine(new Point2D.Double(x - width, y - width), new Point2D.Double(x - width, y + width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x - width, y + width), new Point2D.Double(x + width, y + width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x + width, y + width), new Point2D.Double(x + width, y - width), this.ai.getParent());
            highlighter.addLine(new Point2D.Double(x + width, y - width), new Point2D.Double(x - width, y - width), this.ai.getParent());
            highlighter.finished();
            this.wnd.repaint();
        }

        private Point2D getInsertPoint(MouseEvent evt) {
            Point2D mouseDB = this.wnd.screenToDatabase(evt.getX(), evt.getY());
            EditWindow.gridAlign(mouseDB);
            Point2D insert = DBMath.closestPointToSegment(this.ai.getHeadLocation(), this.ai.getTailLocation(), mouseDB);
            return insert;
        }

        public void mouseWheelMoved(MouseWheelEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        private static class InsertJogPoint
        extends Job {
            private ArcInst ai;
            private EPoint insert;
            private transient Highlighter highlighter;
            private NodeInst jogPoint;

            protected InsertJogPoint(ArcInst ai, EPoint insert, Highlighter highlighter) {
                super("Insert Jog in Arc", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
                this.ai = ai;
                this.insert = insert;
                this.highlighter = highlighter;
                this.startJob();
            }

            public boolean doIt() throws JobException {
                if (CircuitChangeJobs.cantEdit(this.ai.getParent(), null, true) != 0) {
                    return false;
                }
                ArcProto ap = this.ai.getProto();
                PrimitiveNode np = ap.findPinProto();
                if (np == null) {
                    return false;
                }
                NodeInst ni = NodeInst.makeInstance(np, this.insert, np.getDefWidth(), np.getDefHeight(), this.ai.getParent());
                if (ni == null) {
                    System.out.println("Cannot create pin " + np.describe(true));
                    return false;
                }
                NodeInst ni2 = NodeInst.makeInstance(np, this.insert, np.getDefWidth(), np.getDefHeight(), this.ai.getParent());
                if (ni2 == null) {
                    System.out.println("Cannot create pin " + np.describe(true));
                    return false;
                }
                PortInst pi = ni.getOnlyPortInst();
                PortInst pi2 = ni2.getOnlyPortInst();
                PortInst headPort = this.ai.getHeadPortInst();
                PortInst tailPort = this.ai.getTailPortInst();
                EPoint headPt = this.ai.getHeadLocation();
                EPoint tailPt = this.ai.getTailLocation();
                double width = this.ai.getWidth();
                String arcName = this.ai.getName();
                int angle = (this.ai.getAngle() + 900) % 3600;
                ArcInst newAi1 = ArcInst.makeInstance(ap, width, headPort, pi, headPt, this.insert, null);
                ArcInst newAi2 = ArcInst.makeInstance(ap, width, pi, pi2, this.insert, this.insert, null);
                ArcInst newAi3 = ArcInst.makeInstance(ap, width, pi2, tailPort, this.insert, tailPt, null);
                newAi1.setHeadNegated(this.ai.isHeadNegated());
                newAi1.setHeadExtended(this.ai.isHeadExtended());
                newAi1.setHeadArrowed(this.ai.isHeadArrowed());
                newAi3.setTailNegated(this.ai.isTailNegated());
                newAi3.setTailExtended(this.ai.isTailExtended());
                newAi3.setTailArrowed(this.ai.isTailArrowed());
                this.ai.kill();
                if (arcName != null) {
                    if (headPt.distance(this.insert) > tailPt.distance(this.insert)) {
                        newAi1.setName(arcName);
                        newAi1.copyTextDescriptorFrom(this.ai, ArcInst.ARC_NAME);
                    } else {
                        newAi3.setName(arcName);
                        newAi3.copyTextDescriptorFrom(this.ai, ArcInst.ARC_NAME);
                    }
                }
                newAi2.setAngle(angle);
                this.jogPoint = ni;
                this.fieldVariableChanged("jogPoint");
                return true;
            }

            public void terminateOK() {
                this.highlighter.clear();
                this.highlighter.addElectricObject(this.jogPoint, this.jogPoint.getParent());
                this.highlighter.finished();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetEasyHardSelect
    extends Job {
        private boolean easy;
        private List<Geometric> highlighted;

        private SetEasyHardSelect(boolean easy, List<Geometric> highlighted) {
            super("Make Selected Objects Easy/Hard To Select", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.easy = easy;
            this.highlighted = highlighted;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            for (Geometric geom : this.highlighted) {
                if (geom instanceof NodeInst) {
                    NodeInst ni = (NodeInst)geom;
                    if (this.easy) {
                        ni.clearHardSelect();
                        continue;
                    }
                    ni.setHardSelect();
                    continue;
                }
                ArcInst ai = (ArcInst)geom;
                if (this.easy) {
                    ai.setHardSelect(false);
                    continue;
                }
                ai.setHardSelect(true);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateAttributes
    extends Job {
        private List<Geometric> highlighted;
        private boolean allLibraries;
        private int whatToUpdate;

        UpdateAttributes(List<Geometric> highlighted, boolean allLibraries, int whatToUpdate) {
            super("Update Inheritance", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.highlighted = highlighted;
            this.allLibraries = allLibraries;
            this.whatToUpdate = whatToUpdate;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int count = 0;
            if (this.allLibraries) {
                Iterator<Library> it = Library.getLibraries();
                while (it.hasNext()) {
                    Library lib = it.next();
                    Iterator<Cell> it2 = lib.getCells();
                    while (it2.hasNext()) {
                        Cell c = it2.next();
                        Iterator<NodeInst> it3 = c.getNodes();
                        while (it3.hasNext()) {
                            NodeInst ni = it3.next();
                            if (!ni.isCellInstance()) continue;
                            if (this.whatToUpdate == 0) {
                                this.updateInheritance(ni, (Cell)ni.getProto());
                                ++count;
                            }
                            if (this.whatToUpdate != 1) continue;
                            this.updateLocations(ni, (Cell)ni.getProto());
                            ++count;
                        }
                    }
                }
            } else {
                for (Geometric eobj : this.highlighted) {
                    NodeInst ni;
                    if (!(eobj instanceof NodeInst) || !(ni = (NodeInst)eobj).isCellInstance()) continue;
                    if (this.whatToUpdate == 0) {
                        this.updateInheritance(ni, (Cell)ni.getProto());
                        ++count;
                    }
                    if (this.whatToUpdate != 1) continue;
                    this.updateLocations(ni, (Cell)ni.getProto());
                    ++count;
                }
            }
            if (this.whatToUpdate == 0) {
                System.out.println("Updated Attribute Inheritance on " + count + " nodes");
            }
            if (this.whatToUpdate == 1) {
                System.out.println("Updated Attribute Locations on " + count + " nodes");
            }
            return true;
        }

        private void updateInheritance(NodeInst ni, Cell proto) {
            CircuitChangeJobs.inheritAttributes(ni, true);
        }

        private void updateLocations(NodeInst ni, Cell proto) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterVisibility
    extends Job {
        private int how;
        private List<Geometric> selected;

        protected ParameterVisibility(int how, List<Geometric> selected) {
            super("Change Parameter Visibility", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.how = how;
            this.selected = selected;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int changeCount = 0;
            List<Geometric> list = this.selected;
            for (Geometric geom : list) {
                NodeInst ni = (NodeInst)geom;
                if (!ni.isCellInstance()) continue;
                boolean changed = false;
                Iterator<Variable> vIt = ni.getVariables();
                while (vIt.hasNext()) {
                    Variable var = vIt.next();
                    Variable nVar = this.findParameterSource(var, ni);
                    if (nVar == null) continue;
                    switch (this.how) {
                        case 0: {
                            if (var.isDisplay()) break;
                            ni.addVar(var.withDisplay(true));
                            changed = true;
                            break;
                        }
                        case 1: {
                            if (!var.isDisplay()) break;
                            ni.addVar(var.withDisplay(false));
                            changed = true;
                            break;
                        }
                        case 2: {
                            if (nVar.getTextDescriptor().isInterior()) {
                                if (!var.isDisplay()) break;
                                ni.addVar(var.withDisplay(false));
                                changed = true;
                                break;
                            }
                            if (var.isDisplay()) break;
                            ni.addVar(var.withDisplay(true));
                            changed = true;
                        }
                    }
                }
                if (!changed) continue;
                ++changeCount;
            }
            if (changeCount == 0) {
                System.out.println("No Parameter visibility changed");
            } else {
                System.out.println("Changed visibility on " + changeCount + " nodes");
            }
            return true;
        }

        private Variable findParameterSource(Variable var, NodeInst ni) {
            Cell np = (Cell)ni.getProto();
            Cell cnp = np.contentsView();
            if (cnp != null) {
                np = cnp;
            }
            Iterator<Variable> it = np.getVariables();
            while (it.hasNext()) {
                Variable nVar = it.next();
                if (var.getKey() != nVar.getKey()) continue;
                return nVar;
            }
            return null;
        }
    }
}

