/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.DRCRules;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.CheckCellLayerEnumerator;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.MultiDRCAreaToolJob;
import com.sun.electric.tool.drc.MultiDRCLayoutToolJob;
import com.sun.electric.tool.user.ErrorLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class MultiDRCToolJob
extends Job {
    protected Cell topCell;
    protected Layer theLayer;
    protected String theLayerName;
    protected ErrorLogger errorLogger;
    protected static boolean printLog = false;
    protected long globalStartTime;

    MultiDRCToolJob(Cell c, String l, String jobName) {
        super(jobName, DRC.getDRCTool(), Job.Type.REMOTE_EXAMINE, null, null, Job.Priority.USER);
        this.theLayerName = l;
        this.topCell = c;
    }

    public void terminateOK() {
        if (!Job.BATCHMODE) {
            MultiDRCCollectData.jobsList.add(this.errorLogger);
        }
    }

    public static MultiDRCCollectData checkDesignRules(Cell cell, boolean checkArea, boolean ignoreExtensionR) {
        if (cell == null) {
            return null;
        }
        Technology tech = cell.getTechnology();
        DRCRules rules = DRC.getRules(tech);
        if (rules == null || rules.getNumberOfRules() == 0) {
            return null;
        }
        CellLayersContainer cellLayersCon = new CellLayersContainer();
        CheckCellLayerEnumerator layerCellCheck = new CheckCellLayerEnumerator(cellLayersCon);
        HierarchyEnumerator.enumerateCell(cell, VarContext.globalContext, (HierarchyEnumerator.Visitor)layerCellCheck);
        GenMath.MutableBoolean polyDone = new GenMath.MutableBoolean(false);
        long globalStartTime = System.currentTimeMillis();
        Set<String> layers = cellLayersCon.getLayersSet(cell);
        for (String layerS : layers) {
            Layer layer = tech.findLayer(layerS);
            if (checkArea) {
                MultiDRCAreaToolJob.startMultiMinAreaChecking(cell, layer, cellLayersCon, globalStartTime, polyDone);
                continue;
            }
            MultiDRCLayoutToolJob.startMultiLayoutChecking(cell, layer, null, null, null, ignoreExtensionR, polyDone);
        }
        if (!checkArea) {
            MultiDRCLayoutToolJob.startMultiLayoutChecking(cell, null, null, null, null, ignoreExtensionR, polyDone);
        }
        return new MultiDRCCollectData(globalStartTime);
    }

    public static class MultiDRCCollectData
    extends Job {
        static List<ErrorLogger> jobsList = new ArrayList<ErrorLogger>();
        long globalStartTime;

        MultiDRCCollectData(long s) {
            super("Design-Rule Check Collect Data", DRC.getDRCTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.globalStartTime = s;
            jobsList.clear();
            this.startJob();
        }

        public boolean doIt() {
            if (!Job.BATCHMODE) {
                return true;
            }
            int totalErrors = 0;
            int totalWarnings = 0;
            for (ErrorLogger data : jobsList) {
                totalErrors += data.getNumErrors();
                totalWarnings += data.getNumWarnings();
            }
            System.out.println("Total Number of Threads: " + Job.getNumThreads());
            System.out.println("Total Number of Errors: " + totalErrors);
            System.out.println("Total Number of Warnings: " + totalWarnings);
            System.out.println(totalErrors + " errors and " + totalWarnings + " warnings found (took " + TextUtils.getElapsedTime(System.currentTimeMillis() - this.globalStartTime) + ")");
            return true;
        }

        public void terminateOK() {
            int totalErrors = 0;
            int totalWarnings = 0;
            for (ErrorLogger data : jobsList) {
                totalErrors += data.getNumErrors();
                totalWarnings += data.getNumWarnings();
            }
            System.out.println("Total Number of Errors: " + totalErrors);
            System.out.println("Total Number of Warnings: " + totalWarnings);
            System.out.println(totalErrors + " errors and " + totalWarnings + " warnings found (took " + TextUtils.getElapsedTime(System.currentTimeMillis() - this.globalStartTime) + ")");
        }
    }
}

