/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TrackRouterH;
import com.sun.electric.tool.generator.layout.gates.Inv;
import com.sun.electric.tool.generator.layout.gates.Pms1;
import java.util.ArrayList;
import java.util.Iterator;

public class KeeperHigh {
    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    public static Cell makePart(Cell schem, VarContext context, StdCellParams stdCell) {
        Netlist netlist = schem.getNetlist();
        Iterator<NodeInst> nodes = schem.getNodes();
        double szMc = -1.0;
        double szPmos = -1.0;
        double szK = -1.0;
        double szI = -1.0;
        while (nodes.hasNext()) {
            NodeInst ni = nodes.next();
            String nm = ni.getProto().getName();
            if (nm.equals("pms1K{ic}")) {
                szPmos = StdCellParams.getSize(ni, context);
                continue;
            }
            if (nm.equals("invK{ic}")) {
                szK = StdCellParams.getSize(ni, context);
                continue;
            }
            if (!nm.equals("inv{ic}")) continue;
            Network net = netlist.getNetwork(ni.findPortInst("in"));
            if (net.hasName("mc")) {
                szMc = StdCellParams.getSize(ni, context);
                continue;
            }
            if (net.hasName("d")) {
                szI = StdCellParams.getSize(ni, context);
                continue;
            }
            System.out.println("Unrecognized net: ");
            Iterator<String> it = net.getNames();
            while (it.hasNext()) {
                System.out.println(it.next());
            }
            KeeperHigh.error(true, "unrecognized net");
        }
        KeeperHigh.error(szMc == -1.0, "KeeperHigh: inv bufferring mc not found");
        KeeperHigh.error(szPmos == -1.0, "KeeperHigh: pmos not found");
        KeeperHigh.error(szK == -1.0, "KeeperHigh: invK not found");
        KeeperHigh.error(szI == -1.0, "KeeperHigh: inv driving invK not found");
        double sz = stdCell.roundSize(szK);
        Cell keep = stdCell.findPart("keeper_high", sz);
        if (keep != null) {
            return keep;
        }
        keep = stdCell.newPart("keeper_high", sz);
        Cell invKProto = Inv.makePart(szK, stdCell);
        NodeInst invK = LayoutLib.newNodeInst(invKProto, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        Cell invIProto = Inv.makePart(szI, stdCell);
        NodeInst invI = LayoutLib.newNodeInst(invIProto, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        Cell pmosProto = Pms1.makePart(szPmos, stdCell);
        NodeInst pmos = LayoutLib.newNodeInst(pmosProto, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        Cell mcProto = Inv.makePart(szMc, stdCell);
        NodeInst mc = LayoutLib.newNodeInst(mcProto, 0.0, 0.0, 0.0, 0.0, 0.0, keep);
        ArrayList<NodeInst> l = new ArrayList<NodeInst>();
        l.add(mc);
        l.add(pmos);
        l.add(invK);
        l.add(invI);
        LayoutLib.abutLeftRight(l);
        TrackRouterH vdd = new TrackRouterH(Tech.m2(), 10.0, keep);
        vdd.connect(new NodeInst[]{mc, pmos, invK, invI}, "vdd");
        TrackRouterH gnd = new TrackRouterH(Tech.m2(), 10.0, keep);
        gnd.connect(new NodeInst[]{mc, invK, invI}, "gnd");
        TrackRouterH d = new TrackRouterH(Tech.m2(), 4.0, LayoutLib.roundCenterY(pmos.findPortInst("d")), keep);
        d.connect(new PortInst[]{pmos.findPortInst("d"), invK.findPortInst("out"), invI.findPortInst("in")});
        double trackY = stdCell.getTrackY(-1);
        TrackRouterH d_bar = new TrackRouterH(Tech.m2(), 4.0, trackY, keep);
        d_bar.connect(new PortInst[]{invK.findPortInst("in"), invI.findPortInst("out")});
        TrackRouterH mc_bar = new TrackRouterH(Tech.m1(), 4.0, LayoutLib.roundCenterY(pmos.findPortInst("g")), keep);
        mc_bar.connect(new PortInst[]{mc.findPortInst("out"), pmos.findPortInst("g")});
        Export.newInstance(keep, mc.findPortInst("in"), "mc").setCharacteristic(PortCharacteristic.IN);
        Export.newInstance(keep, pmos.findPortInst("d"), "d").setCharacteristic(PortCharacteristic.BIDIR);
        Export.newInstance(keep, invK.findPortInst("vdd"), "vdd").setCharacteristic(PortCharacteristic.PWR);
        Export.newInstance(keep, invK.findPortInst("gnd"), "gnd").setCharacteristic(PortCharacteristic.GND);
        stdCell.addNmosWell(mc.getBounds().getWidth(), mc.getBounds().getWidth() + pmos.getBounds().getWidth(), keep);
        stdCell.addEssentialBounds(0.0, invI.getBounds().getMaxX(), keep);
        return keep;
    }
}

