/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.io.output.Output;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class PAL
extends Output {
    private Cell topCell;
    private List<String> equations;
    private Set<String> internalSymbols;
    private Set<String> externalSymbols;

    public static void writePALFile(Cell cell, VarContext context, String filePath) {
        PAL out = new PAL();
        if (out.openTextOutputStream(filePath)) {
            return;
        }
        out.initialize(cell);
        PALNetlister netlister = new PALNetlister(out);
        HierarchyEnumerator.enumerateCell(cell, context, (HierarchyEnumerator.Visitor)netlister, Netlist.ShortResistors.ALL);
        out.terminate(cell);
        if (out.closeTextOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    PAL() {
    }

    private void initialize(Cell cell) {
        this.topCell = cell;
        this.equations = new ArrayList<String>();
        this.internalSymbols = new TreeSet<String>();
        this.externalSymbols = new TreeSet<String>();
    }

    private void terminate(Cell cell) {
        this.printWriter.println("module " + cell.getName());
        this.printWriter.println("title 'generated by Electric'");
        int pinNumber = 1;
        for (String symbol : this.externalSymbols) {
            this.printWriter.println("    " + symbol + " pin " + pinNumber + ";");
            ++pinNumber;
        }
        for (String symbol : this.internalSymbols) {
            this.printWriter.println("    " + symbol + " = 0,1;");
        }
        this.printWriter.println("");
        this.printWriter.println("equations");
        for (String eq : this.equations) {
            this.printWriter.println("    " + eq + ";");
        }
        this.printWriter.println("");
        this.printWriter.println("end " + cell.describe(false));
    }

    private static class PALNetlister
    extends HierarchyEnumerator.Visitor {
        private PAL pal;

        PALNetlister(PAL pal) {
            this.pal = pal;
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            if (no.isCellInstance()) {
                return true;
            }
            NodeInst ni = (NodeInst)no;
            PrimitiveNode.Function fun = ni.getFunction();
            if (fun != PrimitiveNode.Function.GATEAND && fun != PrimitiveNode.Function.GATEOR && fun != PrimitiveNode.Function.GATEXOR && fun != PrimitiveNode.Function.BUFFER) {
                return false;
            }
            String funName = "";
            if (fun == PrimitiveNode.Function.GATEAND) {
                funName = "&";
            } else if (fun == PrimitiveNode.Function.GATEOR) {
                funName = "#";
            } else if (fun == PrimitiveNode.Function.GATEXOR) {
                funName = "$";
            }
            Connection outputCon = null;
            Iterator<Connection> it = ni.getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                PortInst pi = con.getPortInst();
                if (!pi.getPortProto().getName().equals("y")) continue;
                outputCon = con;
                break;
            }
            if (outputCon == null) {
                System.out.println("ERROR: output port is not connected on " + ni + " in " + ni.getParent());
                return false;
            }
            Netlist netlist = info.getNetlist();
            StringBuffer sb = new StringBuffer();
            if (outputCon.isNegated()) {
                sb.append("!");
            }
            Network oNet = netlist.getNetwork(outputCon.getPortInst());
            sb.append(this.getNetName(oNet, info) + " =");
            int count = 0;
            Iterator<Connection> it2 = ni.getConnections();
            while (it2.hasNext()) {
                Network net;
                Connection con = it2.next();
                PortInst pi = con.getPortInst();
                if (!pi.getPortProto().getName().equals("a")) continue;
                if (count == 1) {
                    sb.append(" " + funName);
                }
                ++count;
                sb.append(" ");
                ArcInst ai = con.getArc();
                if (con.isNegated()) {
                    sb.append("!");
                }
                if ((net = netlist.getNetwork(ai, 0)) == null) continue;
                sb.append(this.getNetName(net, info));
            }
            this.pal.equations.add(sb.toString());
            return false;
        }

        private String getNetName(Network net, HierarchyEnumerator.CellInfo info) {
            Network higher;
            while ((higher = info.getNetworkInParent(net)) != null) {
                net = higher;
                info = info.getParentInfo();
            }
            if (net.isExported() && info.getCell() == this.pal.topCell) {
                String exportName = net.describe(false);
                this.pal.externalSymbols.add(exportName);
                return exportName;
            }
            String internalName = info.getUniqueNetName(net, ".");
            this.pal.internalSymbols.add(internalName);
            return internalName;
        }
    }
}

