/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.result.NetObjReport;
import com.sun.electric.tool.ncc.result.PartReport;
import com.sun.electric.tool.ncc.result.PortReport;
import com.sun.electric.tool.ncc.result.WireReport;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.ui.EditWindow;
import java.util.Iterator;

public class HighlightTools {
    public static Highlighter getHighlighter(Cell cell, VarContext context) {
        Highlighter highlighter = null;
        if (cell != null) {
            if (!cell.isLinked()) {
                System.out.println("Cell is deleted");
            }
            EditWindow wnd = EditWindow.showEditWindowForCell(cell, context);
            highlighter = wnd.getHighlighter();
            highlighter.clear();
        }
        return highlighter;
    }

    public static void highlightPortExports(Highlighter highlighter, Cell cell, PortReport p) {
        String name = p.getWireName();
        HighlightTools.highlightNetworkByName(highlighter, cell, name);
    }

    public static void highlightNetworkByName(Highlighter highlighter, Cell cell, String netName) {
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(netName)) continue;
            highlighter.addNetwork(net, cell);
        }
    }

    public static void highlightPart(Highlighter highlighter, Cell cell, PartReport part) {
        String name = part.getNameProxy().leafName();
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable nod = it.next();
            if (!name.equals(nod.getName())) continue;
            highlighter.addElectricObject(nod.getNodeInst(), cell);
        }
    }

    public static void highlightWire(Highlighter highlighter, Cell cell, WireReport wire) {
        HighlightTools.highlightNetNamed(highlighter, cell, wire.getNameProxy().leafName());
    }

    public static void highlightNetNamed(Highlighter highlighter, Cell cell, String name) {
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted mimic-routing (network information unavailable).  Please try again");
            return;
        }
        Iterator<Network> it = netlist.getNetworks();
        while (it.hasNext()) {
            Network net = it.next();
            if (!net.hasName(name)) continue;
            highlighter.addNetwork(net, cell);
            Iterator<Export> it2 = net.getExports();
            while (it2.hasNext()) {
                Export exp = it2.next();
                highlighter.addText(exp, cell, null);
            }
        }
    }

    public static void highlightPortOrWire(Highlighter highlighter, Cell cell, NetObjReport portOrWire) {
        if (portOrWire instanceof WireReport) {
            HighlightTools.highlightWire(highlighter, cell, (WireReport)portOrWire);
        } else if (portOrWire instanceof PortReport) {
            HighlightTools.highlightPortExports(highlighter, cell, (PortReport)portOrWire);
        }
    }
}

