/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.TableKeeper;
import gnu.jel.debug.Debug;

public abstract class OP {
    public OP[] chi = null;
    public int resID;
    public Class<?> resType;
    public static final Class<?>[] specialTypes = (Class[])TableKeeper.getTable("specialTypes");
    public static final byte[] unwrapType = (byte[])TableKeeper.getTable("unwrapType");
    private static final int[] cvt_wide = (int[])TableKeeper.getTable("cvt_wide");

    public abstract Object eval() throws Exception;

    public abstract void compile(ClassFile var1);

    public static final int typeID(Class<?> c) {
        int i;
        int NUM_SPECIAL_PRIMITIVE_TYPES = 10;
        if (c == null) {
            return 8;
        }
        if (c.isPrimitive()) {
            int i2;
            for (i2 = 0; i2 < 10 && specialTypes[i2] != c; ++i2) {
            }
            Debug.check(i2 < 10, "You didn't put _ALL_ primitive types into primitiveTypes array.");
            return i2;
        }
        for (i = 11; i < specialTypes.length && !specialTypes[i].isAssignableFrom(c); ++i) {
        }
        if (i < specialTypes.length) {
            return i;
        }
        return 8;
    }

    public static final int typeIDObject(Object o) {
        if (o instanceof Boolean) {
            return 0;
        }
        if (o instanceof Byte) {
            return 1;
        }
        if (o instanceof Character) {
            return 2;
        }
        if (o instanceof Short) {
            return 3;
        }
        if (o instanceof Integer) {
            return 4;
        }
        if (o instanceof Long) {
            return 5;
        }
        if (o instanceof Float) {
            return 6;
        }
        if (o instanceof Double) {
            return 7;
        }
        if (o instanceof String) {
            return 11;
        }
        return 8;
    }

    public static boolean isWidening(int id1, Class<?> c1, int id2, Class<?> c2) {
        if (c2 == Object.class) {
            return true;
        }
        if (c2 == Number.class) {
            return (id1 = unwrapType[id1]) < 8 && id1 != 0 && id1 != 2;
        }
        if ((id2 <= 11 || id2 >= 20 && id2 <= 27) && id2 != 8) {
            id1 = unwrapType[id1];
            id2 = unwrapType[id2];
            Debug.check(id1 < cvt_wide.length);
            return (cvt_wide[id2] & 2048 >> id1) > 0;
        }
        if (id1 >= 8) {
            if (c1 == c2) {
                return true;
            }
            if (c1 == null) {
                return true;
            }
            if (c2 == null) {
                return false;
            }
            return c2.isAssignableFrom(c1);
        }
        return false;
    }

    public static boolean isWidening(Class<?> c1, Class<?> c2) {
        return OP.isWidening(OP.typeID(c1), c1, OP.typeID(c2), c2);
    }

    protected static Number widen(Object o, int clsID) {
        switch (clsID) {
            case 0: {
                if (((Boolean)o).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
            case 1: {
                return (Number)o;
            }
            case 2: {
                return (long)((Character)o).charValue();
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return (Number)o;
            }
        }
        Debug.println("Attempt to widen wrong primitive (" + clsID + ").");
        return 0L;
    }

    protected static Object narrow(Number val, int clsID) {
        switch (clsID) {
            case 0: {
                if (val.longValue() != 0L) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 1: {
                return val.byteValue();
            }
            case 2: {
                return Character.valueOf((char)val.longValue());
            }
            case 3: {
                return val.shortValue();
            }
            case 4: {
                return val.intValue();
            }
            case 5: {
                return val.longValue();
            }
            case 6: {
                return Float.valueOf(val.floatValue());
            }
            case 7: {
                return val.doubleValue();
            }
        }
        Debug.println("Attempt to narrow wrong primitive (" + clsID + ").");
        return null;
    }
}

