/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.expr.Keyword;
import gnu.expr.QuoteExp;
import gnu.expr.Special;
import gnu.kawa.lispexpr.LispLanguage;
import gnu.kawa.lispexpr.ReadTable;
import gnu.kawa.lispexpr.ReadTableEntry;
import gnu.kawa.lispexpr.ReaderIgnoreRestOfLine;
import gnu.kawa.lispexpr.ReaderParens;
import gnu.lists.Convert;
import gnu.lists.F32Vector;
import gnu.lists.F64Vector;
import gnu.lists.FString;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.lists.S16Vector;
import gnu.lists.S32Vector;
import gnu.lists.S64Vector;
import gnu.lists.S8Vector;
import gnu.lists.Sequence;
import gnu.lists.SimpleVector;
import gnu.lists.U16Vector;
import gnu.lists.U32Vector;
import gnu.lists.U64Vector;
import gnu.lists.U8Vector;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Values;
import gnu.math.Complex;
import gnu.math.DComplex;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.RatNum;
import gnu.math.RealNum;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.IOException;

public class LispReader
extends Lexer {
    public static final char TOKEN_ESCAPE_CHAR = '\uffff';
    protected boolean seenEscapes;
    static final int SCM_COMPLEX = 1;
    public static final int SCM_NUMBERS = 1;

    public LispReader(LineBufferedReader lineBufferedReader) {
        super(lineBufferedReader);
    }

    public LispReader(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages) {
        super(lineBufferedReader, sourceMessages);
    }

    public final void readNestedComment(char c, char c2) throws IOException, SyntaxException {
        int n = 1;
        int n2 = this.port.getLineNumber();
        int n3 = this.port.getColumnNumber();
        do {
            int n4;
            if ((n4 = this.read()) == 124) {
                n4 = this.read();
                if (n4 == c) {
                    --n;
                }
            } else if (n4 == c && (n4 = this.read()) == c2) {
                ++n;
            }
            if (n4 >= 0) continue;
            this.eofError("unexpected end-of-file in " + c + c2 + " comment starting here", n2 + 1, n3 - 1);
            return;
        } while (n > 0);
    }

    static char getReadCase() {
        int n;
        try {
            String string = Environment.getCurrent().get("symbol-read-case", (Object)"P").toString();
            n = string.charAt(0);
            if (n != 80) {
                if (n == 117) {
                    n = 85;
                } else if (n == 100 || n == 108 || n == 76) {
                    n = 68;
                } else if (n == 105) {
                    n = 73;
                }
            }
        }
        catch (Exception exception) {
            n = 80;
        }
        return (char)n;
    }

    public Object readValues(int n, ReadTable readTable) throws IOException, SyntaxException {
        return this.readValues(n, readTable.lookup(n), readTable);
    }

    public Object readValues(int n, ReadTableEntry readTableEntry, ReadTable readTable) throws IOException, SyntaxException {
        int n2 = this.tokenBufferLength;
        if (readTableEntry == null) {
            String string = "invalid character #\\" + (char)n;
            if (this.interactive) {
                this.fatal(string);
            } else {
                this.error(string);
            }
            return Values.empty;
        }
        int n3 = readTableEntry.getKind();
        this.seenEscapes = false;
        switch (n3) {
            case 1: {
                return Values.empty;
            }
            case 5: 
            case 6: {
                Object object2 = readTableEntry.read(this, n, -1);
                return object2;
            }
            case 2: {
                if (n != readTable.postfixLookupOperator) break;
                this.tokenBufferAppend(n);
                n = this.read();
            }
        }
        this.readToken(n, LispReader.getReadCase(), readTable);
        int n4 = this.tokenBufferLength;
        if (this.seenEscapes) {
            return this.returnSymbol(n2, n4, readTable);
        }
        return this.handleToken(n2, n4, readTable);
    }

    /*
     * Enabled aggressive block sorting
     */
    void readToken(int n, char c, ReadTable readTable) throws IOException, SyntaxException {
        boolean bl = false;
        while (true) {
            ReadTableEntry readTableEntry;
            if (n < 0) {
                if (!bl) return;
                this.eofError("unexpected EOF between escapes");
            }
            if ((readTableEntry = readTable.lookup(n)) == null) {
                if (!bl) {
                    this.unread(n);
                    return;
                }
                this.tokenBufferAppend(65535);
                this.tokenBufferAppend(n);
            } else {
                int n2 = readTableEntry.getKind();
                if (n == readTable.postfixLookupOperator && !bl && this.validPostfixLookupStart(readTable)) {
                    n2 = 5;
                }
                if (n2 == 3) {
                    n = this.read();
                    if (n < 0) {
                        this.eofError("unexpected EOF after single escape");
                    }
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(n);
                    this.seenEscapes = true;
                } else if (n2 == 4) {
                    bl = !bl;
                } else if (bl) {
                    this.tokenBufferAppend(65535);
                    this.tokenBufferAppend(n);
                } else {
                    switch (n2) {
                        case 2: 
                        case 6: {
                            if (c == 'U' || c == 'I' && Character.isLowerCase((char)n)) {
                                n = Character.toUpperCase((char)n);
                            } else if (c == 'D' || c == 'I' && Character.isUpperCase((char)n)) {
                                n = Character.toLowerCase((char)n);
                            }
                            this.tokenBufferAppend(n);
                            break;
                        }
                        case 4: {
                            bl = true;
                            this.seenEscapes = true;
                            break;
                        }
                        case 5: {
                            this.unread(n);
                            return;
                        }
                        case 1: {
                            this.unread(n);
                            return;
                        }
                    }
                }
            }
            n = this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws IOException, SyntaxException {
        char c = ((InPort)this.port).readState;
        int n = this.tokenBufferLength;
        ((InPort)this.port).readState = (char)32;
        try {
            int n2;
            int n3;
            int n4;
            Object object2;
            ReadTable readTable = ReadTable.getCurrent();
            do {
                n3 = this.port.getLineNumber();
                n2 = this.port.getColumnNumber();
                n4 = this.port.read();
                if (n4 >= 0) continue;
                object2 = Sequence.eofValue;
                return object2;
            } while ((object2 = this.readValues(n4, readTable)) == Values.empty);
            Object object3 = this.handlePostfix(object2, readTable, n3, n2);
            return object3;
        }
        finally {
            this.tokenBufferLength = n;
            ((InPort)this.port).readState = c;
        }
    }

    protected boolean validPostfixLookupStart(ReadTable readTable) throws IOException {
        ReadTableEntry readTableEntry;
        int n = this.port.peek();
        if (n < 0 || n == 58 || (readTableEntry = readTable.lookup(n)) == null || n == readTable.postfixLookupOperator) {
            return false;
        }
        if (n == 44) {
            return true;
        }
        int n2 = readTableEntry.getKind();
        return n2 == 2 || n2 == 6 || n2 == 4 || n2 == 3;
    }

    Object handlePostfix(Object object2, ReadTable readTable, int n, int n2) throws IOException, SyntaxException {
        int n3;
        if (object2 == QuoteExp.voidExp) {
            object2 = Values.empty;
        }
        while ((n3 = this.port.peek()) >= 0 && n3 == readTable.postfixLookupOperator) {
            this.port.read();
            if (!this.validPostfixLookupStart(readTable)) {
                this.unread();
                break;
            }
            n3 = this.port.read();
            Object object3 = this.readValues(n3, readTable.lookup(n3), readTable);
            object2 = LList.list2(object2, LList.list2(readTable.makeSymbol("quasiquote"), object3));
            object2 = PairWithPosition.make(LispLanguage.lookup_sym, object2, this.port.getName(), n + 1, n2 + 1);
        }
        return object2;
    }

    private boolean isPotentialNumber(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (Character.isDigit(c)) {
                ++n3;
                continue;
            }
            if (c == '-' || c == '+') {
                if (i + 1 != n2) continue;
                return false;
            }
            if (c == '#') {
                return true;
            }
            if (!(Character.isLetter(c) || c == '/' || c == '_' || c == '^' ? i == n : c != '.')) continue;
            return false;
        }
        return n3 > 0;
    }

    public static Object parseNumber(CharSequence charSequence, int n) {
        char[] cArray = charSequence instanceof FString ? ((FString)charSequence).data : ((Object)charSequence).toString().toCharArray();
        int n2 = charSequence.length();
        return LispReader.parseNumber(cArray, 0, n2, '\u0000', n, 1);
    }

    public static Object parseNumber(char[] cArray, int n, int n2, char c, int n3, int n4) {
        Object object2;
        int n5;
        int n6;
        int n7;
        char c2;
        int n8;
        int n9;
        block83: {
            n9 = n;
            n8 = n + n2;
            if (n9 >= n8) {
                return "no digits";
            }
            c2 = cArray[n9++];
            while (c2 == '#') {
                if (n9 >= n8) {
                    return "no digits";
                }
                c2 = cArray[n9++];
                switch (c2) {
                    case 'B': 
                    case 'b': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 2;
                        break;
                    }
                    case 'O': 
                    case 'o': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 8;
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 10;
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        if (n3 != 0) {
                            return "duplicate radix specifier";
                        }
                        n3 = 16;
                        break;
                    }
                    case 'E': 
                    case 'I': 
                    case 'e': 
                    case 'i': {
                        if (c != '\u0000') {
                            if (c == ' ') {
                                return "non-prefix exactness specifier";
                            }
                            return "duplicate exactness specifier";
                        }
                        c = c2;
                        break;
                    }
                    default: {
                        n7 = 0;
                        while ((n6 = Character.digit(c2, 10)) >= 0) {
                            n7 = 10 * n7 + n6;
                            if (n9 >= n8) {
                                return "missing letter after '#'";
                            }
                            c2 = cArray[n9++];
                        }
                        if (c2 == 'R' || c2 == 'r') {
                            if (n3 != 0) {
                                return "duplicate radix specifier";
                            }
                            if (n7 < 2 || n7 > 35) {
                                return "invalid radix specifier";
                            }
                            n3 = n7;
                            break;
                        }
                        return "unknown modifier '#" + c2 + '\'';
                    }
                }
                if (n9 >= n8) {
                    return "no digits";
                }
                c2 = cArray[n9++];
            }
            if (c == '\u0000') {
                c = (char)32;
            }
            if (n3 == 0) {
                n7 = n2;
                do {
                    if (--n7 >= 0) continue;
                    n3 = 10;
                    break block83;
                } while (cArray[n + n7] != '.');
                n3 = 10;
            }
        }
        n6 = n7 = c2 == '-' ? 1 : 0;
        if (c2 == '-' || c2 == '+') {
            if (n9 >= n8) {
                return "no digits following sign";
            }
            c2 = cArray[n9++];
        }
        if ((c2 == 'i' || c2 == 'I') && n9 == n8 && n == n9 - 2 && (n4 & 1) != 0) {
            char c3 = cArray[n];
            if (c3 != '+' && c3 != '-') {
                return "no digits";
            }
            if (c == 'i' || c == 'I') {
                return new DComplex(0.0, n7 != 0 ? -1.0 : 1.0);
            }
            return n7 != 0 ? Complex.imMinusOne() : Complex.imOne();
        }
        int n10 = n9 - 1;
        boolean bl = false;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        IntNum intNum = null;
        long l = 0L;
        block15: while (true) {
            if ((n5 = Character.digit(c2, n3)) >= 0) {
                if (bl && n13 < 0) {
                    return "digit after '#' in number";
                }
                if (n12 < 0) {
                    n12 = n9 - 1;
                }
                l = (long)n3 * l + (long)n5;
            } else {
                switch (c2) {
                    case '.': {
                        if (n13 >= 0) {
                            return "duplicate '.' in number";
                        }
                        if (n3 != 10) {
                            return "'.' in non-decimal number";
                        }
                        n13 = n9 - 1;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'L': 
                    case 'S': 
                    case 'd': 
                    case 'e': 
                    case 'f': 
                    case 'l': 
                    case 's': {
                        if (n9 == n8 || n3 != 10) {
                            --n9;
                            break block15;
                        }
                        char c4 = cArray[n9];
                        int n14 = n9 - 1;
                        if (c4 == '+' || c4 == '-') {
                            if (++n9 >= n8 || Character.digit(cArray[n9], 10) < 0) {
                                return "missing exponent digits";
                            }
                        } else if (Character.digit(c4, 10) < 0) {
                            --n9;
                            break block15;
                        }
                        if (n11 >= 0) {
                            return "duplicate exponent";
                        }
                        if (n3 != 10) {
                            return "exponent in non-decimal number";
                        }
                        if (n12 < 0) {
                            return "mantissa with no digits";
                        }
                        n11 = n14;
                        while (++n9 < n8 && Character.digit(cArray[n9], 10) >= 0) {
                        }
                        break block15;
                    }
                    case '/': {
                        if (intNum != null) {
                            return "multiple fraction symbol '/'";
                        }
                        if (n12 < 0) {
                            return "no digits before fraction symbol '/'";
                        }
                        if (n11 >= 0 || n13 >= 0) {
                            return "fraction symbol '/' following exponent or '.'";
                        }
                        intNum = LispReader.valueOf(cArray, n12, n9 - n12, n3, n7 != 0, l);
                        n12 = -1;
                        l = 0L;
                        n7 = 0;
                        bl = false;
                        bl3 = false;
                        break;
                    }
                    default: {
                        --n9;
                        break block15;
                    }
                }
            }
            if (n9 == n8) break;
            c2 = cArray[n9++];
        }
        if (n12 < 0) {
            return "no digits";
        }
        if (bl || bl3) {
            // empty if block
        }
        n5 = c == 'i' || c == 'I' || c == ' ' && bl ? 1 : 0;
        Object object3 = null;
        if (n11 >= 0 || n13 >= 0) {
            char c5;
            if (n12 > n13 && n13 >= 0) {
                n12 = n13;
            }
            if (intNum != null) {
                return "floating-point number after fraction symbol '/'";
            }
            object2 = new String(cArray, n12, n9 - n12);
            if (n11 >= 0 && (c5 = cArray[n11]) != 'e' && c5 != 'E') {
                int n15 = n11 - n12;
                object2 = ((String)object2).substring(0, n15) + 'e' + ((String)object2).substring(n15 + 1);
            }
            double d = Convert.parseDouble((String)object2);
            object3 = new DFloNum(n7 != 0 ? -d : d);
        } else {
            object2 = LispReader.valueOf(cArray, n12, n9 - n12, n3, n7 != 0, l);
            if (intNum == null) {
                object3 = object2;
            } else if (((IntNum)object2).isZero()) {
                boolean bl4 = intNum.isZero();
                if (n5 != 0) {
                    object3 = new DFloNum(bl4 ? Double.NaN : (n6 != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY));
                } else {
                    if (bl4) {
                        return "0/0 is undefined";
                    }
                    object3 = RatNum.make(intNum, (IntNum)object2);
                }
            } else {
                object3 = RatNum.make(intNum, (IntNum)object2);
            }
            if (n5 != 0 && ((Complex)object3).isExact()) {
                object3 = new DFloNum(n6 != 0 && ((RealNum)object3).isZero() ? -0.0 : ((Complex)object3).doubleValue());
            }
        }
        if (c == 'e' || c == 'E') {
            object3 = ((RealNum)object3).toExact();
        }
        if (n9 < n8) {
            char c6;
            if ((c2 = cArray[n9++]) == '@') {
                object2 = LispReader.parseNumber(cArray, n9, n8 - n9, c, 10, n4);
                if (object2 instanceof String) {
                    return object2;
                }
                if (!(object2 instanceof RealNum)) {
                    return "invalid complex polar constant";
                }
                RealNum realNum = (RealNum)object2;
                if (((RealNum)object3).isZero() && !realNum.isExact()) {
                    return new DFloNum(0.0);
                }
                return Complex.polar((RealNum)object3, realNum);
            }
            if (c2 == '-' || c2 == '+') {
                if ((object2 = LispReader.parseNumber(cArray, --n9, n8 - n9, c, 10, n4)) instanceof String) {
                    return object2;
                }
                if (!(object2 instanceof Complex)) {
                    return "invalid numeric constant (" + object2 + ")";
                }
                Complex complex = (Complex)object2;
                RealNum realNum = complex.re();
                if (!realNum.isZero()) {
                    return "invalid numeric constant";
                }
                return Complex.make((RealNum)object3, complex.im());
            }
            int n16 = 0;
            while (true) {
                if (!Character.isLetter(c2)) {
                    --n9;
                    break;
                }
                ++n16;
                if (n9 == n8) break;
                c2 = cArray[n9++];
            }
            if (n16 == 1 && ((c6 = cArray[n9 - 1]) == 'i' || c6 == 'I')) {
                if (n9 < n8) {
                    return "junk after imaginary suffix 'i'";
                }
                return Complex.make(IntNum.zero(), (RealNum)object3);
            }
            return "excess junk after number";
        }
        return object3;
    }

    private static IntNum valueOf(char[] cArray, int n, int n2, int n3, boolean bl, long l) {
        if (n2 + n3 <= 28) {
            return IntNum.make(bl ? -l : l);
        }
        return IntNum.valueOf(cArray, n, n2, n3, bl);
    }

    protected Object returnSymbol(int n, int n2, ReadTable readTable) {
        char c;
        int n3;
        int n4;
        int n5;
        int n6 = LispReader.getReadCase();
        if (n6 == 73) {
            n5 = 0;
            n4 = 0;
            for (n3 = n; n3 < n2; ++n3) {
                c = this.tokenBuffer[n3];
                if (c == '\uffff') {
                    ++n3;
                    continue;
                }
                if (Character.isLowerCase(c)) {
                    ++n4;
                    continue;
                }
                if (!Character.isUpperCase(c)) continue;
                ++n5;
            }
            n6 = n4 == 0 ? 68 : (n5 == 0 ? 85 : 80);
        }
        n5 = -1;
        n4 = n;
        for (n3 = n; n3 < n2; ++n3) {
            c = this.tokenBuffer[n3];
            if (c == '\uffff') {
                if (++n3 >= n2) continue;
                this.tokenBuffer[n4++] = this.tokenBuffer[n3];
                continue;
            }
            if (c == ':') {
                n5 = n5 >= 0 ? -1 : n4;
            } else if (n6 == 85) {
                c = Character.toUpperCase(c);
            } else if (n6 == 68) {
                c = Character.toLowerCase(c);
            }
            this.tokenBuffer[n4++] = c;
        }
        n2 = n4;
        n3 = n2 - n;
        if (readTable.initialColonIsKeyword && n5 == n && n3 > 1) {
            String string = new String(this.tokenBuffer, ++n, n2 - n);
            return Keyword.make(string.intern());
        }
        if (readTable.finalColonIsKeyword && n5 == n2 - 1 && n3 > 1) {
            String string = new String(this.tokenBuffer, n, n3 - 1);
            return Keyword.make(string.intern());
        }
        return readTable.makeSymbol(new String(this.tokenBuffer, n, n3));
    }

    public Object handleToken(int n, int n2, ReadTable readTable) {
        Object object2 = LispReader.parseNumber(this.tokenBuffer, n, n2 - n, '\u0000', 0, 1);
        if (object2 != null && !(object2 instanceof String)) {
            return object2;
        }
        return this.returnSymbol(n, n2, readTable);
    }

    public int readEscape() throws IOException, SyntaxException {
        int n = this.read();
        if (n < 0) {
            this.eofError("unexpected EOF in character literal");
            return -1;
        }
        return this.readEscape(n);
    }

    public final int readEscape(int n) throws IOException, SyntaxException {
        block0 : switch ((char)n) {
            case 'a': {
                n = 7;
                break;
            }
            case 'b': {
                n = 8;
                break;
            }
            case 't': {
                n = 9;
                break;
            }
            case 'n': {
                n = 10;
                break;
            }
            case 'v': {
                n = 11;
                break;
            }
            case 'f': {
                n = 12;
                break;
            }
            case 'r': {
                n = 13;
                break;
            }
            case 'e': {
                n = 27;
                break;
            }
            case '\"': {
                n = 34;
                break;
            }
            case '\\': {
                n = 92;
                break;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                while (true) {
                    if (n < 0) {
                        this.eofError("unexpected EOF in literal");
                        return -1;
                    }
                    if (n == 10) break;
                    if (n == 13) {
                        if (this.peek() == 10) {
                            this.skip();
                        }
                        n = 10;
                        break;
                    }
                    if (n != 32 && n != 9) {
                        this.unread(n);
                        break;
                    }
                    n = this.read();
                }
                if (n != 10) break;
                do {
                    if ((n = this.read()) >= 0) continue;
                    this.eofError("unexpected EOF in literal");
                    return -1;
                } while (n == 32 || n == 9);
                this.unread(n);
                return -2;
            }
            case 'M': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                return n | 0x80;
            }
            case 'C': {
                n = this.read();
                if (n != 45) {
                    this.error("Invalid escape character syntax");
                    return 63;
                }
            }
            case '^': {
                n = this.read();
                if (n == 92) {
                    n = this.readEscape();
                }
                if (n == 63) {
                    return 127;
                }
                return n & 0x9F;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                n -= 48;
                int n2 = 0;
                while (++n2 < 3) {
                    int n3 = this.read();
                    int n4 = Character.digit((char)n3, 8);
                    if (n4 >= 0) {
                        n = (n << 3) + n4;
                        continue;
                    }
                    if (n3 < 0) break block0;
                    this.unread(n3);
                    break block0;
                }
                break;
            }
            case 'u': {
                n = 0;
                int n5 = 4;
                while (--n5 >= 0) {
                    int n6;
                    int n7 = this.read();
                    if (n7 < 0) {
                        this.eofError("premature EOF in \\u escape");
                    }
                    if ((n6 = Character.digit((char)n7, 16)) < 0) {
                        this.error("non-hex character following \\u");
                    }
                    n = 16 * n + n6;
                }
                break;
            }
            case 'x': {
                int n8;
                int n9;
                n = 0;
                while ((n9 = Character.digit((char)(n8 = this.read()), 16)) >= 0) {
                    n = (n << 4) + n9;
                }
                if (n8 == 59 || n8 < 0) break;
                this.unread(n8);
                break;
            }
        }
        return n;
    }

    public final Object readObject(int n) throws IOException, SyntaxException {
        this.unread(n);
        return this.readObject();
    }

    public Object readCommand() throws IOException, SyntaxException {
        return this.readObject();
    }

    protected Object makeNil() {
        return LList.Empty;
    }

    protected Object makePair(Object object2, int n, int n2) {
        String string = this.port.getName();
        if (string != null && n >= 0) {
            return PairWithPosition.make(object2, LList.Empty, string, n + 1, n2 + 1);
        }
        return Pair.make(object2, LList.Empty);
    }

    protected void setCdr(Object object2, Object object3) {
        ((PairWithPosition)object2).setCdrBackdoor(object3);
    }

    public static Object readNumberWithRadix(int n, LispReader lispReader, int n2) throws IOException, SyntaxException {
        int n3 = lispReader.tokenBufferLength - n;
        lispReader.readToken(lispReader.read(), 'P', ReadTable.getCurrent());
        int n4 = lispReader.tokenBufferLength;
        if (n3 == n4) {
            lispReader.error("missing numeric token");
            return IntNum.zero();
        }
        Object object2 = LispReader.parseNumber(lispReader.tokenBuffer, n3, n4 - n3, '\u0000', n2, 0);
        if (object2 instanceof String) {
            lispReader.error((String)object2);
            return IntNum.zero();
        }
        if (object2 == null) {
            lispReader.error("invalid numeric constant");
            return IntNum.zero();
        }
        return object2;
    }

    public static Object readCharacter(LispReader lispReader) throws IOException, SyntaxException {
        int n;
        int n2;
        int n3 = lispReader.read();
        if (n3 < 0) {
            lispReader.eofError("unexpected EOF in character literal");
        }
        int n4 = lispReader.tokenBufferLength;
        lispReader.tokenBufferAppend(n3);
        lispReader.readToken(lispReader.read(), 'D', ReadTable.getCurrent());
        char[] cArray = lispReader.tokenBuffer;
        int n5 = lispReader.tokenBufferLength - n4;
        if (n5 == 1) {
            return Char.make(cArray[n4]);
        }
        String string = new String(cArray, n4, n5);
        n3 = Char.nameToChar(string);
        if (n3 >= 0) {
            return Char.make(n3);
        }
        n3 = cArray[n4];
        if (n3 == 120 || n3 == 88) {
            n2 = 0;
            n = 1;
            while (true) {
                if (n == n5) {
                    return Char.make(n2);
                }
                int n6 = Character.digit(cArray[n4 + n], 16);
                if (n6 < 0 || (n2 = 16 * n2 + n6) > 0x10FFFF) break;
                ++n;
            }
        }
        if ((n3 = Character.digit(n3, 8)) >= 0) {
            n2 = n3;
            n = 1;
            while (true) {
                if (n == n5) {
                    return Char.make(n2);
                }
                n3 = Character.digit(cArray[n4 + n], 8);
                if (n3 < 0) break;
                n2 = 8 * n2 + n3;
                ++n;
            }
        }
        lispReader.error("unknown character name: " + string);
        return Char.make(63);
    }

    public static Object readSpecial(LispReader lispReader) throws IOException, SyntaxException {
        int n = lispReader.read();
        if (n < 0) {
            lispReader.eofError("unexpected EOF in #! special form");
        }
        if (n == 47 && lispReader.getLineNumber() == 0 && lispReader.getColumnNumber() == 3) {
            ReaderIgnoreRestOfLine.getInstance().read(lispReader, 35, 1);
            return Values.empty;
        }
        int n2 = lispReader.tokenBufferLength;
        lispReader.tokenBufferAppend(n);
        lispReader.readToken(lispReader.read(), 'D', ReadTable.getCurrent());
        int n3 = lispReader.tokenBufferLength - n2;
        String string = new String(lispReader.tokenBuffer, n2, n3);
        if (string.equals("optional")) {
            return Special.optional;
        }
        if (string.equals("rest")) {
            return Special.rest;
        }
        if (string.equals("key")) {
            return Special.key;
        }
        if (string.equals("eof")) {
            return Special.eof;
        }
        if (string.equals("void")) {
            return QuoteExp.voidExp;
        }
        if (string.equals("default")) {
            return Special.dfault;
        }
        if (string.equals("undefined")) {
            return Special.undefined;
        }
        if (string.equals("abstract")) {
            return Special.abstractSpecial;
        }
        if (string.equals("null")) {
            return null;
        }
        lispReader.error("unknown named constant #!" + string);
        return null;
    }

    public static SimpleVector readSimpleVector(LispReader lispReader, char c) throws IOException, SyntaxException {
        int n;
        int n2 = 0;
        while (true) {
            int n3;
            if ((n = lispReader.read()) < 0) {
                lispReader.eofError("unexpected EOF reading uniform vector");
            }
            if ((n3 = Character.digit((char)n, 10)) < 0) break;
            n2 = n2 * 10 + n3;
        }
        if (n2 != 8 && n2 != 16 && n2 != 32 && n2 != 64 || c == 'F' && n2 < 32 || n != 40) {
            lispReader.error("invalid uniform vector syntax");
            return null;
        }
        Object object2 = ReaderParens.readList(lispReader, 40, -1, 41);
        int n4 = LList.listLength(object2, false);
        if (n4 < 0) {
            lispReader.error("invalid elements in uniform vector syntax");
            return null;
        }
        Sequence sequence = (Sequence)object2;
        switch (c) {
            case 'F': {
                switch (n2) {
                    case 32: {
                        return new F32Vector(sequence);
                    }
                    case 64: {
                        return new F64Vector(sequence);
                    }
                }
            }
            case 'S': {
                switch (n2) {
                    case 8: {
                        return new S8Vector(sequence);
                    }
                    case 16: {
                        return new S16Vector(sequence);
                    }
                    case 32: {
                        return new S32Vector(sequence);
                    }
                    case 64: {
                        return new S64Vector(sequence);
                    }
                }
            }
            case 'U': {
                switch (n2) {
                    case 8: {
                        return new U8Vector(sequence);
                    }
                    case 16: {
                        return new U16Vector(sequence);
                    }
                    case 32: {
                        return new U32Vector(sequence);
                    }
                    case 64: {
                        return new U64Vector(sequence);
                    }
                }
            }
        }
        return null;
    }
}

