/*
 * Decompiled with CFR 0.152.
 */
package org.domterm.websocket;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.domterm.Backend;
import org.domterm.ClassBackend;
import org.domterm.ProcessBackend;
import org.domterm.pty.PTY;
import org.domterm.pty.PtyBackend;
import org.domterm.util.StringBufferedWriter;
import org.domterm.util.WTDebug;
import org.java_websocket.WebSocket;
import org.java_websocket.exceptions.WebsocketNotConnectedException;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class DomServer
extends WebSocketServer {
    static int verbose = 0;
    Map<WebSocket, Backend> backendMap = new IdentityHashMap<WebSocket, Backend>();
    Set<Backend> pendingBackends = new HashSet<Backend>();
    String pending = null;
    String[] backendArgs;
    static String domtermPath;
    static int runBrowser;

    public DomServer(int n, String[] stringArray) throws UnknownHostException {
        super(new InetSocketAddress(n));
        this.backendArgs = stringArray;
    }

    public DomServer(InetSocketAddress inetSocketAddress, String[] stringArray) {
        super(inetSocketAddress);
        this.backendArgs = stringArray;
    }

    public static void fatal(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    protected Backend createBackend(WebSocket webSocket) throws Exception {
        return this.createBackend();
    }

    protected Backend createBackend() throws Exception {
        String[] stringArray;
        int n;
        WTDebug.init();
        Backend backend = null;
        String[] stringArray2 = this.backendArgs;
        int n2 = 32;
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray = stringArray2[n];
            if (stringArray.equals("--pty") || stringArray.equals("-e")) {
                n2 = 84;
                continue;
            }
            if (stringArray.equals("--shell") || stringArray.equals("--pipe") || stringArray.equals("--process")) {
                n2 = 83;
                continue;
            }
            if (stringArray.equals("--class")) {
                if (n + 1 == stringArray2.length) {
                    DomServer.fatal("missing class name");
                }
                Method method = null;
                String string = stringArray2[n + 1];
                try {
                    method = ClassBackend.getMainMethod(string);
                }
                catch (Throwable throwable) {
                    DomServer.fatal("caught " + throwable + " trying to load class " + string);
                }
                String[] stringArray3 = new String[stringArray2.length - n - 2];
                System.arraycopy(stringArray2, n + 2, stringArray3, 0, stringArray3.length);
                backend = new ClassBackend(method, stringArray3);
                break;
            }
            if (stringArray.length() != 0 && stringArray.charAt(0) != '-') break;
            DomServer.fatal("unknown argument '" + (String)stringArray + "'");
        }
        if (backend == null) {
            stringArray = new String[stringArray2.length - n];
            System.arraycopy(stringArray2, n, stringArray, 0, stringArray.length);
            if (n2 == 84 || n2 == 32) {
                try {
                    PTY.checkLoaded();
                    n2 = 84;
                }
                catch (Throwable throwable) {
                    if (n2 == 32) {
                        n2 = 83;
                        System.err.println("(no pty in java.library.path - using --process)");
                    }
                    DomServer.fatal("caught " + throwable);
                }
            }
            try {
                backend = n2 == 83 ? new ProcessBackend(stringArray) : new PtyBackend(stringArray);
            }
            catch (Throwable throwable) {
                DomServer.fatal("caught " + throwable);
            }
        }
        return backend;
    }

    @Override
    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        try {
            if (verbose > 0) {
                WTDebug.println("received onOpen from " + webSocket);
            }
            Backend backend = this.createBackend(webSocket);
            this.backendMap.put(webSocket, backend);
            this.pendingBackends.add(backend);
        }
        catch (Throwable throwable) {
            WTDebug.println("onOpen caught " + throwable);
            throw new RuntimeException(throwable);
        }
    }

    public static void setExitOnClose(boolean bl) {
        runBrowser = bl ? 0 : -1;
    }

    @Override
    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        if (verbose > 0) {
            WTDebug.println("onClose called");
        }
        Backend backend = this.backendMap.get(webSocket);
        this.backendMap.remove(webSocket);
        backend.close(this.backendMap.isEmpty());
        if (runBrowser >= 0) {
            System.exit(0);
        }
    }

    @Override
    public void onMessage(WebSocket webSocket, String string) {
        Backend backend = this.backendMap.get(webSocket);
        if (verbose > 0) {
            WTDebug.println("received msg [" + WTDebug.toQuoted(string) + "] from " + webSocket);
        }
        if (this.pending != null) {
            string = this.pending + string;
            this.pending = null;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = -1;
        if (n2 >= 10 && string.charAt(0) == '\u0092' && string.substring(1, 9).equals("VERSION ") && (n3 = string.indexOf(10)) > 0) {
            backend.addVersionInfo(string.substring(9, n3));
            n2 -= ++n3;
            string = string.substring(n3);
        }
        if (this.pendingBackends.remove(backend)) {
            try {
                backend.versionInfo = backend.versionInfo + ";Java-WebSocket-server";
                backend.run(new ReplWriter(webSocket));
                backend.sendSessionName();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        while (n < n2) {
            if (string.charAt(n) == '\u0092') {
                backend.processInputCharacters(string.substring(0, n));
                int n4 = string.indexOf(10, n + 1);
                if (n4 >= 0) {
                    int n5;
                    for (n5 = n + 1; n5 < n4 && string.charAt(n5) != ' '; ++n5) {
                    }
                    String string2 = string.substring(n + 1, n5);
                    while (n5 < n4 && string.charAt(n5) == ' ') {
                        ++n5;
                    }
                    backend.reportEvent(string2, string.substring(n5, n4));
                    string = string.substring(n4 + 1);
                    n = -1;
                    n2 = string.length();
                } else {
                    this.pending = string.substring(n);
                    string = "";
                    n = -1;
                    n2 = 0;
                }
            }
            ++n;
        }
        backend.processInputCharacters(string);
    }

    @Override
    public void onFragment(WebSocket webSocket, Framedata framedata) {
        WTDebug.println("onFragment called");
        System.out.println("received fragment: " + framedata);
    }

    @Override
    public void onError(WebSocket webSocket, Exception exception) {
        WTDebug.println("onError called");
        exception.printStackTrace();
        this.backendMap.remove(webSocket);
        if (webSocket != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 32;
        String string = null;
        domtermPath = System.getProperty("java.library.path");
        int n3 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            if (stringArray2.equals("--port")) {
                if (n + 1 == stringArray.length) {
                    DomServer.fatal("missing port number");
                }
                stringArray2 = stringArray[++n];
                try {
                    n3 = Integer.parseInt((String)stringArray2);
                }
                catch (Exception exception) {
                    DomServer.fatal("bad port number '" + (String)stringArray2 + "'");
                }
                continue;
            }
            if (stringArray2.startsWith("--domterm-path=")) {
                domtermPath = stringArray2.substring(15);
                continue;
            }
            if (stringArray2.equals("--browser")) {
                runBrowser = 0;
                continue;
            }
            if (stringArray2.startsWith("--browser=")) {
                runBrowser = 0;
                string = stringArray2.substring(10);
                continue;
            }
            if (stringArray2.equals("--firefox")) {
                runBrowser = 1;
                continue;
            }
            if (stringArray2.equals("--chrome")) {
                runBrowser = 2;
                continue;
            }
            if (!stringArray2.equals("--qtdomterm") && !stringArray2.equals("--qtwebengine")) break;
            runBrowser = 3;
        }
        stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        if (n3 == -1) {
            n3 = runBrowser >= 0 ? 0 : 8025;
        }
        try {
            Object object;
            Object object2;
            DomServer domServer = new DomServer(n3, stringArray2);
            domServer.start();
            n3 = domServer.getPort();
            String string2 = "file://" + domtermPath + "/repl-client.html#ws=//localhost:" + n3 + "/";
            if (runBrowser == 0) {
                if (string == null) {
                    Desktop.getDesktop().browse(new URI(string2));
                } else {
                    object2 = Runtime.getRuntime().exec(new String[]{string, string2});
                }
            } else if (runBrowser == 1) {
                object2 = DomServer.firefoxCommand();
                object = Runtime.getRuntime().exec(new String[]{object2, "-app", domtermPath + "/xulapp/application.ini", "-wspath", "ws://localhost:" + n3});
            } else if (runBrowser == 2) {
                object2 = DomServer.chromeCommand();
                object = "--app=" + string2;
                Process process = Runtime.getRuntime().exec(new String[]{object2, object});
            } else if (runBrowser == 3) {
                object2 = domtermPath + "/bin/qtdomterm";
                object = Runtime.getRuntime().exec(new String[]{object2, "--connect", "localhost:" + n3});
                ((Process)object).waitFor();
            } else {
                System.out.println("DomTerm server started on port: " + n3);
                object2 = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Please press a key to stop the server.");
                ((BufferedReader)object2).readLine();
            }
            if (runBrowser >= 0) {
                object = object2 = new Object();
                synchronized (object) {
                    object2.wait();
                }
            }
            domServer.stop();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public static String chromeCommand() {
        String string = "google-chrome";
        String string2 = System.getenv("CHROME_BIN");
        if (string2 != null && new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    public static String firefoxCommand() {
        String string = "firefox";
        String string2 = "/Applications/Firefox.app/Contents/MacOS/firefox";
        if (new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    static {
        runBrowser = -1;
    }

    static class ReplWriter
    extends StringBufferedWriter {
        WebSocket session;

        ReplWriter(WebSocket webSocket) {
            super(true);
            this.session = webSocket;
        }

        @Override
        protected void writeRaw(String string) throws IOException {
            try {
                this.session.send(string);
            }
            catch (WebsocketNotConnectedException websocketNotConnectedException) {
                // empty catch block
            }
        }

        @Override
        public void close() throws IOException {
            if (this.session != null) {
                this.write("\u001b[99;99u");
                super.close();
                this.session = null;
            }
        }
    }
}

