/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class MainDialog
extends JFrame {
    private final JTextArea textArea = new JTextArea();

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Legacy behavior, it is fine to use default encoding for console redirects")
    public MainDialog() throws HeadlessException, IOException {
        super("Jenkins Console");
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setMinimumSize(new Dimension(400, 150));
        pane.setPreferredSize(new Dimension(400, 150));
        this.add(pane);
        this.setDefaultCloseOperation(3);
        this.setLocationByPlatform(true);
        PipedOutputStream out = new PipedOutputStream();
        PrintStream pout = new PrintStream(out);
        System.setErr(pout);
        System.setOut(pout);
        BufferedReader in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
        new Thread(() -> {
            try {
                while (true) {
                    String line;
                    if ((line = in.readLine()) == null) {
                        continue;
                    }
                    String text = line;
                    SwingUtilities.invokeLater(() -> {
                        this.textArea.append(text + '\n');
                        this.scrollDown();
                    });
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).start();
        this.pack();
    }

    private void scrollDown() {
        int pos = this.textArea.getDocument().getEndPosition().getOffset();
        this.textArea.getCaret().setDot(pos);
        this.textArea.requestFocus();
    }
}

