/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.omegat.gui.glossary.DefaultGlossaryRenderer;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.HttpConnectionUtils;
import org.omegat.util.gui.Styles;

public interface IGlossaryRenderer {
    public static final AttributeSet NO_ATTRIBUTES = Styles.createAttributeSet(null, null, false, null);
    public static final AttributeSet PRIORITY_ATTRIBUTES = Styles.createAttributeSet(null, null, true, null);
    public static final AttributeSet SOURCE_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_SOURCE.getColor(), null, null, null);
    public static final AttributeSet TARGET_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_TARGET.getColor(), null, null, null);
    public static final AttributeSet NOTES_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_NOTE.getColor(), null, null, null);

    public String getName();

    public String getId();

    public void render(GlossaryEntry var1, IRenderTarget<?> var2);

    default public void render(GlossaryEntry entry, StyledDocument doc) {
        DocTarget trg = new DocTarget(doc);
        this.render(entry, trg);
        trg.append("\n\n");
    }

    default public String renderToHtml(GlossaryEntry entry) {
        HtmlTarget trg = new HtmlTarget();
        this.render(entry, trg);
        return trg.get();
    }

    public static class HtmlTarget
    implements IRenderTarget<String> {
        private final StringBuilder buf = new StringBuilder();

        @Override
        public void append(String str) {
            this.append(str, null);
        }

        @Override
        public void append(String str, AttributeSet attr) {
            if (attr != null) {
                Color attrColor;
                if (StyleConstants.isBold(attr)) {
                    this.buf.append("<b>");
                }
                if (StyleConstants.isItalic(attr)) {
                    this.buf.append("<i>");
                }
                if ((attrColor = StyleConstants.getForeground(attr)) != Color.black) {
                    String colorString = String.format("%02x%02x%02x", attrColor.getRed(), attrColor.getGreen(), attrColor.getBlue());
                    this.buf.append("<font color=#").append(colorString).append(">");
                }
            }
            String doc = HttpConnectionUtils.decodeHttpURLs(str);
            this.buf.append(doc);
            if (attr != null) {
                Color attrColor = StyleConstants.getForeground(attr);
                if (attrColor != Color.black) {
                    this.buf.append("</font>");
                }
                if (StyleConstants.isItalic(attr)) {
                    this.buf.append("</i>");
                }
                if (StyleConstants.isBold(attr)) {
                    this.buf.append("</b>");
                }
            }
        }

        @Override
        public void startIndent(AttributeSet attr) {
            this.append("&nbsp;&nbsp;", attr);
        }

        @Override
        public String get() {
            return "<html><p>" + this.buf.toString().replace("\n", "<br>") + "</p></html>";
        }
    }

    public static class DocTarget
    implements IRenderTarget<Void> {
        private final StyledDocument doc;

        DocTarget(StyledDocument doc) {
            this.doc = doc;
        }

        @Override
        public void append(String str) {
            this.append(str, null);
        }

        @Override
        public void append(String str, AttributeSet attr) {
            try {
                this.doc.insertString(this.doc.getLength(), str, attr);
            }
            catch (BadLocationException e) {
                Logger.getLogger(DefaultGlossaryRenderer.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }

        @Override
        public void startIndent(AttributeSet attr) {
            this.append("\n  ", attr);
        }

        @Override
        public Void get() {
            return null;
        }
    }

    public static interface IRenderTarget<T> {
        public void append(String var1);

        public void append(String var1, AttributeSet var2);

        public void startIndent(AttributeSet var1);

        public T get();
    }
}

