/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.nodes;

import org.htmlparser.Remark;
import org.htmlparser.lexer.Cursor;
import org.htmlparser.lexer.Page;
import org.htmlparser.nodes.AbstractNode;
import org.htmlparser.util.ParserException;
import org.htmlparser.visitors.NodeVisitor;

public class RemarkNode
extends AbstractNode
implements Remark {
    protected String mText;

    public RemarkNode(String text) {
        super(null, 0, 0);
        this.setText(text);
    }

    public RemarkNode(Page page, int start, int end) {
        super(page, start, end);
        this.mText = null;
    }

    @Override
    public String getText() {
        int end;
        int start;
        String ret = null == this.mText ? ((start = this.getStartPosition() + 4) >= (end = this.getEndPosition() - 3) ? "" : this.mPage.getText(start, end)) : this.mText;
        return ret;
    }

    @Override
    public void setText(String text) {
        this.mText = text;
        if (text.startsWith("<!--") && text.endsWith("-->")) {
            this.mText = text.substring(4, text.length() - 3);
        }
        this.nodeBegin = 0;
        this.nodeEnd = this.mText.length();
    }

    @Override
    public String toPlainTextString() {
        return "";
    }

    @Override
    public String toHtml(boolean verbatim) {
        String ret;
        if (null == this.mText) {
            ret = this.mPage.getText(this.getStartPosition(), this.getEndPosition());
        } else {
            StringBuffer buffer = new StringBuffer(this.mText.length() + 7);
            buffer.append("<!--");
            buffer.append(this.mText);
            buffer.append("-->");
            ret = buffer.toString();
        }
        return ret;
    }

    @Override
    public String toString() {
        int startpos = this.getStartPosition();
        int endpos = this.getEndPosition();
        StringBuffer ret = new StringBuffer(endpos - startpos + 20);
        if (null == this.mText) {
            Cursor start = new Cursor(this.getPage(), startpos);
            Cursor end = new Cursor(this.getPage(), endpos);
            ret.append("Rem (");
            ret.append(start);
            ret.append(",");
            ret.append(end);
            ret.append("): ");
            start.setPosition(startpos + 4);
            endpos -= 3;
            while (start.getPosition() < endpos) {
                try {
                    char c = this.mPage.getCharacter(start);
                    switch (c) {
                        case '\t': {
                            ret.append("\\t");
                            break;
                        }
                        case '\n': {
                            ret.append("\\n");
                            break;
                        }
                        case '\r': {
                            ret.append("\\r");
                            break;
                        }
                        default: {
                            ret.append(c);
                            break;
                        }
                    }
                }
                catch (ParserException parserException) {
                    // empty catch block
                }
                if (77 > ret.length()) continue;
                ret.append("...");
                break;
            }
        } else {
            ret.append("Rem (");
            ret.append(startpos);
            ret.append(",");
            ret.append(endpos);
            ret.append("): ");
            for (int i = 0; i < this.mText.length(); ++i) {
                char c = this.mText.charAt(i);
                switch (c) {
                    case '\t': {
                        ret.append("\\t");
                        break;
                    }
                    case '\n': {
                        ret.append("\\n");
                        break;
                    }
                    case '\r': {
                        ret.append("\\r");
                        break;
                    }
                    default: {
                        ret.append(c);
                    }
                }
                if (77 > ret.length()) continue;
                ret.append("...");
                break;
            }
        }
        return ret.toString();
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visitRemarkNode(this);
    }
}

