/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.os.Build;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ViewParentCompatICS;
import android.support.v4.view.ViewParentCompatKitKat;
import android.support.v4.view.ViewParentCompatLollipop;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;

public class ViewParentCompat {
    static final ViewParentCompatImpl IMPL;

    private ViewParentCompat() {
    }

    public static boolean requestSendAccessibilityEvent(ViewParent parent, View child, AccessibilityEvent event) {
        return IMPL.requestSendAccessibilityEvent(parent, child, event);
    }

    public static boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
        return IMPL.onStartNestedScroll(parent, child, target, nestedScrollAxes);
    }

    public static void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
        IMPL.onNestedScrollAccepted(parent, child, target, nestedScrollAxes);
    }

    public static void onStopNestedScroll(ViewParent parent, View target) {
        IMPL.onStopNestedScroll(parent, target);
    }

    public static void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        IMPL.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
    }

    public static void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
        IMPL.onNestedPreScroll(parent, target, dx, dy, consumed);
    }

    public static boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
        return IMPL.onNestedFling(parent, target, velocityX, velocityY, consumed);
    }

    public static boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
        return IMPL.onNestedPreFling(parent, target, velocityX, velocityY);
    }

    public static void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
        IMPL.notifySubtreeAccessibilityStateChanged(parent, child, source, changeType);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 21 ? new ViewParentCompatLollipopImpl() : (version >= 19 ? new ViewParentCompatKitKatImpl() : (version >= 14 ? new ViewParentCompatICSImpl() : new ViewParentCompatStubImpl()));
    }

    static class ViewParentCompatLollipopImpl
    extends ViewParentCompatKitKatImpl {
        ViewParentCompatLollipopImpl() {
        }

        @Override
        public boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
            return ViewParentCompatLollipop.onStartNestedScroll(parent, child, target, nestedScrollAxes);
        }

        @Override
        public void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
            ViewParentCompatLollipop.onNestedScrollAccepted(parent, child, target, nestedScrollAxes);
        }

        @Override
        public void onStopNestedScroll(ViewParent parent, View target) {
            ViewParentCompatLollipop.onStopNestedScroll(parent, target);
        }

        @Override
        public void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            ViewParentCompatLollipop.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        }

        @Override
        public void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
            ViewParentCompatLollipop.onNestedPreScroll(parent, target, dx, dy, consumed);
        }

        @Override
        public boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
            return ViewParentCompatLollipop.onNestedFling(parent, target, velocityX, velocityY, consumed);
        }

        @Override
        public boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
            return ViewParentCompatLollipop.onNestedPreFling(parent, target, velocityX, velocityY);
        }
    }

    static class ViewParentCompatKitKatImpl
    extends ViewParentCompatICSImpl {
        ViewParentCompatKitKatImpl() {
        }

        @Override
        public void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
            ViewParentCompatKitKat.notifySubtreeAccessibilityStateChanged(parent, child, source, changeType);
        }
    }

    static class ViewParentCompatICSImpl
    extends ViewParentCompatStubImpl {
        ViewParentCompatICSImpl() {
        }

        @Override
        public boolean requestSendAccessibilityEvent(ViewParent parent, View child, AccessibilityEvent event) {
            return ViewParentCompatICS.requestSendAccessibilityEvent(parent, child, event);
        }
    }

    static class ViewParentCompatStubImpl
    implements ViewParentCompatImpl {
        ViewParentCompatStubImpl() {
        }

        @Override
        public boolean requestSendAccessibilityEvent(ViewParent parent, View child, AccessibilityEvent event) {
            if (child == null) {
                return false;
            }
            AccessibilityManager manager = (AccessibilityManager)child.getContext().getSystemService("accessibility");
            manager.sendAccessibilityEvent(event);
            return true;
        }

        @Override
        public boolean onStartNestedScroll(ViewParent parent, View child, View target, int nestedScrollAxes) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onStartNestedScroll(child, target, nestedScrollAxes);
            }
            return false;
        }

        @Override
        public void onNestedScrollAccepted(ViewParent parent, View child, View target, int nestedScrollAxes) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedScrollAccepted(child, target, nestedScrollAxes);
            }
        }

        @Override
        public void onStopNestedScroll(ViewParent parent, View target) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onStopNestedScroll(target);
            }
        }

        @Override
        public void onNestedScroll(ViewParent parent, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            }
        }

        @Override
        public void onNestedPreScroll(ViewParent parent, View target, int dx, int dy, int[] consumed) {
            if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedPreScroll(target, dx, dy, consumed);
            }
        }

        @Override
        public boolean onNestedFling(ViewParent parent, View target, float velocityX, float velocityY, boolean consumed) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onNestedFling(target, velocityX, velocityY, consumed);
            }
            return false;
        }

        @Override
        public boolean onNestedPreFling(ViewParent parent, View target, float velocityX, float velocityY) {
            if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onNestedPreFling(target, velocityX, velocityY);
            }
            return false;
        }

        @Override
        public void notifySubtreeAccessibilityStateChanged(ViewParent parent, View child, View source, int changeType) {
        }
    }

    static interface ViewParentCompatImpl {
        public boolean requestSendAccessibilityEvent(ViewParent var1, View var2, AccessibilityEvent var3);

        public boolean onStartNestedScroll(ViewParent var1, View var2, View var3, int var4);

        public void onNestedScrollAccepted(ViewParent var1, View var2, View var3, int var4);

        public void onStopNestedScroll(ViewParent var1, View var2);

        public void onNestedScroll(ViewParent var1, View var2, int var3, int var4, int var5, int var6);

        public void onNestedPreScroll(ViewParent var1, View var2, int var3, int var4, int[] var5);

        public boolean onNestedFling(ViewParent var1, View var2, float var3, float var4, boolean var5);

        public boolean onNestedPreFling(ViewParent var1, View var2, float var3, float var4);

        public void notifySubtreeAccessibilityStateChanged(ViewParent var1, View var2, View var3, int var4);
    }
}

