10 PRINT "PROGRAM FILE 85: GENERAL CAPABILITIES OF GOSUB/RETURN."
20 PRINT "    ANSI STANDARD 10.4"
30 PRINT
40 PRINT "SECTION 85.1: SIMPLE NESTING OF GOSUBS."
50 PRINT
60 PRINT "THIS SECTION TESTS THAT SUBROUTINES MAY CALL ONE ANOTHER"
70 PRINT "AND THAT A SUBROUTINE MAY BE CALLED FROM SEVERAL PLACES."
80 PRINT
90 PRINT "                  BEGIN TEST."
100 PRINT
400 LET F=0
500 LET X=0
510 GOSUB 570
520 IF X=11 THEN 530
525 LET F=1
530 LET X=0
540 GOSUB 600
550 IF X=8 THEN 560
555 LET F=1
560 GOTO 700
570 LET X=X+8
580 GOSUB 640
590 RETURN
600 GOSUB 640
610 GOSUB 670
620 LET X=X+4
630 RETURN
640 LET X=X+2
650 GOSUB 670
660 RETURN
670 LET X=X+1
680 RETURN
700 PRINT
710 IF F=0 THEN 740
720 PRINT "***  TEST FAILED  ***"
730 GOTO 750
740 PRINT "***  TEST PASSED  ***"
750 PRINT
1000 PRINT "                  END TEST."
1010 PRINT
1020 PRINT
1030 PRINT "SECTION 85.2: STACKING OF RETURN ADDRESSES."
1040 PRINT
1050 PRINT "THIS SECTION TESTS THAT RETURN ADDRESSES ARE PROPERLY"
1060 PRINT "STACKED BY GOSUBS (INCLUDING SEVERAL EXECUTIONS OF THE"
1070 PRINT "SAME GOSUB) AND UNSTACKED BY CORRESPONDING RETURNS."
1080 PRINT
1090 PRINT "                 BEGIN TEST."
1100 PRINT
1150 LET F=0
1200 LET I0=3
1210 LET J0=4
1220 GOSUB 1500
1230 IF K0=4 THEN 1250
1240 LET F=1
1250 LET I0=2
1260 LET J0=7
1270 GOSUB 1500
1280 IF K0=21 THEN 1300
1290 LET F=1
1300 LET I0=4
1310 LET J0=8
1320 GOSUB 1500
1330 IF K0=70 THEN 1350
1340 LET F=1
1350 GOTO 1900
1500 REM TEST RECURSIVE USE OF GOSUB
1510 LET L9=0
1520 LET M0=0
1540 GOSUB 1570
1560 RETURN
1570 REM BINOMIAL COEFFICIENT SUBROUTINE
1580 REM FIND K0=BIN(I0,J0)
1590 REM ADD 1 TO LEVEL-COUNTER (L9) AND SAVE STATE
1600 LET L9=L9+1
1610 LET M(L9)=M0
1620 LET I(L9)=I0
1630 LET J(L9)=J0
1640 IF I0=0 THEN 1670
1650 IF I0=J0 THEN 1670
1660 GOTO 1740
1670 LET K0=1
1680 REM RESTORE STATE
1690 LET I0=I(L9)
1700 LET J0=J(L9)
1710 LET M0=M(L9)
1720 LET L9=L9-1
1730 RETURN
1740 REM BIN(I0,J0)=BIN(I0,J0-1)+BIN(I0-1,J0-1)
1750 LET J0=J0-1
1760 GOSUB 1570
1770 LET M0=K0
1780 LET I0=I0-1
1790 GOSUB 1570
1800 LET K0=K0+M0
1810 REM RESTORE STATE
1820 LET I0=I(L9)
1830 LET J0=J(L9)
1840 LET M0=M(L9)
1850 LET L9=L9-1
1860 RETURN
1900 PRINT
1910 IF F=0 THEN 1940
1920 PRINT "***  TEST FAILED  ***"
1930 GOTO 1950
1940 PRINT "***  TEST PASSED  ***"
1950 PRINT
2000 PRINT "                  END TEST."
2010 PRINT
2020 PRINT
2030 PRINT "SECTION 85.3: GOSUB WITHOUT RETURN."
2040 PRINT
2050 PRINT "THIS SECTION TESTS THAT PROGRAM EXECUTION MAY VALIDLY"
2060 PRINT "TERMINATE EVEN THOUGH MORE GOSUBS HAVE BEEN EXECUTED "
2070 PRINT "THAN RETURNS."
2080 PRINT
2090 PRINT "                  BEGIN TEST."
2100 PRINT
2110 GOSUB 2200
2120 PRINT "***  TEST FAILED  ***"
2130 GOTO 2990
2200 PRINT "IF PROGRAM TERMINATES NORMALLY, THEN"
2220 PRINT "***  TEST PASSED  ***"
2990 PRINT
3000 PRINT "                   END TEST."
3010 PRINT
3020 PRINT "END PROGRAM 85"
4000 END
