10 PRINT "PROGRAM FILE 140: RUNS TEST FOR THE RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 140.1: RUNS TEST FOR THE RND FUNCTION."
50 PRINT
60 PRINT "THIS PROGRAM COUNTS HOW MANY RUNS OF A GIVEN LENGTH OCCUR"
70 PRINT "WITHIN A SERIES OF RANDOM NUMBERS. A RUN IS A SUBSEQUENCE"
80 PRINT "OF THE NUMBERS WITHIN WHICH THE VALUES ARE IN ASCENDING"
90 PRINT "ORDER. THE RESULTS ARE COMPARED WITH THE EXPECTED OUTCOME"
100 PRINT "FOR UNIFORM RANDOM NUMBERS, AND CHI-SQUARE IS COMPUTED"
110 PRINT "AND DISPLAYED. ALL RUNS OF LENGTH >= 6 ARE CONSOLIDATED"
120 PRINT "INT ONE CATEGORY."
130 PRINT
140 PRINT "***** THIS TEST IS INFORMATIVE ONLY *****"
150 PRINT
160 PRINT "                  BEGIN TEST"
170 PRINT
180 LET T=6
190 LET N=5000
200 REM ZERO OUT TYPE COUNTS FOR RUNS
210 FOR I=1 TO T
220 LET C(I)=0
230 NEXT I
240 LET Y=RND
250 REM GATHER STATS ON N TRIALS
260 LET N1=1
270 REM COUNT LENGTH OF NEW RUN
280 LET K=1
290 LET X=RND
300 LET N1=N1+1
310 IF N1>N THEN 390
320 REM TO TEST RUNS DOWN, SIMPLY CHANGE "<" TO ">" IN NEXT LINE
330 IF X<Y THEN 390
340 REM RUN CONTINUES
350 LET K=K+1
360 LET Y=X
370 GOTO 290
380 REM END OF THIS RUN
390 LET Y=X
400 IF K<=T THEN 420
410 LET K=T
420 LET C(K)=C(K)+1
430 IF N1<=N THEN 280
440 PRINT "RUN LENGTH","ACTUAL COUNT","EXPECTED COUNT"
450 REM INITIALIZE FOR CALCULATION
460 REM CHI-SQUARE NOT COMPUTED SIMILARLY TO OTHER TESTS
470 FOR I=1 TO T
480 REM READ B-ARRAY VALUES
490 READ F
500 LET W(I)=C(I) - N*F
510 IF I<T THEN 530
520 PRINT ">=";
530 PRINT I,C(I),N*F
540 NEXT I
550 LET S=0
560 REM COMPUTE MATRIX SUM
570 FOR I=1 TO T
580 FOR J=1 TO T
590 REM READ A-MATRIX VALUES
600 READ F
610 LET S=S+(W(I)*W(J)*F)
620 NEXT J
630 NEXT I
640 LET V=S/N
650 PRINT
660 PRINT "FOR 6 D.F., SHOULD HAVE 1.63539 <= CHI-SQ <= 12.5916"
670 PRINT "(5% TAIL ON EACH END.)"
680 PRINT
690 PRINT "ACTUAL CHI-SQ = ";V
700 REM V SHOULD BE DISTRIBUTED AS CHI-SQ WITH 6 D.F
710 PRINT
720 IF V<1.63539 THEN 760
730 IF V>12.5916 THEN 760
740 PRINT "*** INFORMATIVE TEST PASSED ***"
750 GOTO 770
760 PRINT "*** INFORMATIVE TEST FAILED ***"
770 PRINT
780 PRINT "                 END TEST"
790 PRINT
800 PRINT "END PROGRAM 140"
810 REM DATA FOR B-ARRAY:
820 DATA .166667,.208333,9.16667E-2,2.63889E-2,5.75397E-3,1.19048E-3
830 REM DATA FOR (CONCEPTUAL) A-MATRIX:
840 DATA 4529.4, 9044.9, 13568, 18091, 22615, 27892
850 DATA 9044.9, 18097,  27139, 36187, 45234, 55789
860 DATA 13568,  27139,  40721, 54281, 67852, 83685
870 DATA 18091,  36187,  54281, 72414, 90470, 111580
880 DATA 22615,  45234,  67852, 90470, 113262,139476
890 DATA 27892,  55789,  83685, 111580,139476,172860
900 END
