// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/aiplatform/v1beta1/vizier_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [VizierService.GetStudy][google.cloud.aiplatform.v1beta1.VizierService.GetStudy].
type GetStudyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Study resource.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStudyRequest) Reset() {
	*x = GetStudyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetStudyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStudyRequest) ProtoMessage() {}

func (x *GetStudyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStudyRequest.ProtoReflect.Descriptor instead.
func (*GetStudyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetStudyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VizierService.CreateStudy][google.cloud.aiplatform.v1beta1.VizierService.CreateStudy].
type CreateStudyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to create the CustomJob in.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Study configuration used to create the Study.
	Study *Study `protobuf:"bytes,2,opt,name=study,proto3" json:"study,omitempty"`
}

func (x *CreateStudyRequest) Reset() {
	*x = CreateStudyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateStudyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStudyRequest) ProtoMessage() {}

func (x *CreateStudyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStudyRequest.ProtoReflect.Descriptor instead.
func (*CreateStudyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{1}
}

func (x *CreateStudyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateStudyRequest) GetStudy() *Study {
	if x != nil {
		return x.Study
	}
	return nil
}

// Request message for
// [VizierService.ListStudies][google.cloud.aiplatform.v1beta1.VizierService.ListStudies].
type ListStudiesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to list the Study from.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	// If unspecified, there are no subsequent pages.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The maximum number of studies to return per "page" of results.
	// If unspecified, service will pick an appropriate default.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListStudiesRequest) Reset() {
	*x = ListStudiesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStudiesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudiesRequest) ProtoMessage() {}

func (x *ListStudiesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStudiesRequest.ProtoReflect.Descriptor instead.
func (*ListStudiesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListStudiesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListStudiesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStudiesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for
// [VizierService.ListStudies][google.cloud.aiplatform.v1beta1.VizierService.ListStudies].
type ListStudiesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The studies associated with the project.
	Studies []*Study `protobuf:"bytes,1,rep,name=studies,proto3" json:"studies,omitempty"`
	// Passes this token as the `page_token` field of the request for a
	// subsequent call.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListStudiesResponse) Reset() {
	*x = ListStudiesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListStudiesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStudiesResponse) ProtoMessage() {}

func (x *ListStudiesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStudiesResponse.ProtoReflect.Descriptor instead.
func (*ListStudiesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{3}
}

func (x *ListStudiesResponse) GetStudies() []*Study {
	if x != nil {
		return x.Studies
	}
	return nil
}

func (x *ListStudiesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [VizierService.DeleteStudy][google.cloud.aiplatform.v1beta1.VizierService.DeleteStudy].
type DeleteStudyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Study resource to be deleted.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteStudyRequest) Reset() {
	*x = DeleteStudyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteStudyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStudyRequest) ProtoMessage() {}

func (x *DeleteStudyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStudyRequest.ProtoReflect.Descriptor instead.
func (*DeleteStudyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteStudyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VizierService.LookupStudy][google.cloud.aiplatform.v1beta1.VizierService.LookupStudy].
type LookupStudyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Location to get the Study from.
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The user-defined display name of the Study
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *LookupStudyRequest) Reset() {
	*x = LookupStudyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LookupStudyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LookupStudyRequest) ProtoMessage() {}

func (x *LookupStudyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LookupStudyRequest.ProtoReflect.Descriptor instead.
func (*LookupStudyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{5}
}

func (x *LookupStudyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *LookupStudyRequest) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Request message for
// [VizierService.SuggestTrials][google.cloud.aiplatform.v1beta1.VizierService.SuggestTrials].
type SuggestTrialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location that the Study belongs to.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The number of suggestions requested. It must be positive.
	SuggestionCount int32 `protobuf:"varint,2,opt,name=suggestion_count,json=suggestionCount,proto3" json:"suggestion_count,omitempty"`
	// Required. The identifier of the client that is requesting the suggestion.
	//
	// If multiple SuggestTrialsRequests have the same `client_id`,
	// the service will return the identical suggested Trial if the Trial is
	// pending, and provide a new Trial if the last suggested Trial was completed.
	ClientId string `protobuf:"bytes,3,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. This allows you to specify the "context" for a Trial; a context
	// is a slice (a subspace) of the search space.
	//
	// Typical uses for contexts:
	// 1) You are using Vizier to tune a server for best performance, but there's
	//   a strong weekly cycle.  The context specifies the day-of-week.
	//   This allows Tuesday to generalize from Wednesday without assuming that
	//   everything is identical.
	// 2) Imagine you're optimizing some medical treatment for people.
	//   As they walk in the door, you know certain facts about them
	//   (e.g. sex, weight, height, blood-pressure).  Put that information in the
	//   context, and Vizier will adapt its suggestions to the patient.
	// 3) You want to do a fair A/B test efficiently.  Specify the "A" and "B"
	//   conditions as contexts, and Vizier will generalize between "A" and "B"
	//   conditions.  If they are similar, this will allow Vizier to converge
	//   to the optimum faster than if "A" and "B" were separate Studies.
	//   NOTE: You can also enter contexts as REQUESTED Trials, e.g. via the
	//   CreateTrial() RPC; that's the asynchronous option where you don't need a
	//   close association between contexts and suggestions.
	//
	// NOTE: All the Parameters you set in a context MUST be defined in the
	//   Study.
	// NOTE: You must supply 0 or $suggestion_count contexts.
	//   If you don't supply any contexts, Vizier will make suggestions
	//   from the full search space specified in the StudySpec; if you supply
	//   a full set of context, each suggestion will match the corresponding
	//   context.
	// NOTE: A Context with no features set matches anything, and allows
	//   suggestions from the full search space.
	// NOTE: Contexts MUST lie within the search space specified in the
	//   StudySpec.  It's an error if they don't.
	// NOTE: Contexts preferentially match ACTIVE then REQUESTED trials before
	//   new suggestions are generated.
	// NOTE: Generation of suggestions involves a match between a Context and
	//   (optionally) a REQUESTED trial; if that match is not fully specified, a
	//   suggestion will be geneated in the merged subspace.
	Contexts []*TrialContext `protobuf:"bytes,4,rep,name=contexts,proto3" json:"contexts,omitempty"`
}

func (x *SuggestTrialsRequest) Reset() {
	*x = SuggestTrialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestTrialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestTrialsRequest) ProtoMessage() {}

func (x *SuggestTrialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestTrialsRequest.ProtoReflect.Descriptor instead.
func (*SuggestTrialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{6}
}

func (x *SuggestTrialsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestTrialsRequest) GetSuggestionCount() int32 {
	if x != nil {
		return x.SuggestionCount
	}
	return 0
}

func (x *SuggestTrialsRequest) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *SuggestTrialsRequest) GetContexts() []*TrialContext {
	if x != nil {
		return x.Contexts
	}
	return nil
}

// Response message for
// [VizierService.SuggestTrials][google.cloud.aiplatform.v1beta1.VizierService.SuggestTrials].
type SuggestTrialsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Trials.
	Trials []*Trial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
	// The state of the Study.
	StudyState Study_State `protobuf:"varint,2,opt,name=study_state,json=studyState,proto3,enum=google.cloud.aiplatform.v1beta1.Study_State" json:"study_state,omitempty"`
	// The time at which the operation was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time at which operation processing completed.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *SuggestTrialsResponse) Reset() {
	*x = SuggestTrialsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestTrialsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestTrialsResponse) ProtoMessage() {}

func (x *SuggestTrialsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestTrialsResponse.ProtoReflect.Descriptor instead.
func (*SuggestTrialsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{7}
}

func (x *SuggestTrialsResponse) GetTrials() []*Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *SuggestTrialsResponse) GetStudyState() Study_State {
	if x != nil {
		return x.StudyState
	}
	return Study_STATE_UNSPECIFIED
}

func (x *SuggestTrialsResponse) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *SuggestTrialsResponse) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// Details of operations that perform Trials suggestion.
type SuggestTrialsMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for suggesting Trials.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// The identifier of the client that is requesting the suggestion.
	//
	// If multiple SuggestTrialsRequests have the same `client_id`,
	// the service will return the identical suggested Trial if the Trial is
	// pending, and provide a new Trial if the last suggested Trial was completed.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
}

func (x *SuggestTrialsMetadata) Reset() {
	*x = SuggestTrialsMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SuggestTrialsMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestTrialsMetadata) ProtoMessage() {}

func (x *SuggestTrialsMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestTrialsMetadata.ProtoReflect.Descriptor instead.
func (*SuggestTrialsMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{8}
}

func (x *SuggestTrialsMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *SuggestTrialsMetadata) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

// Request message for
// [VizierService.CreateTrial][google.cloud.aiplatform.v1beta1.VizierService.CreateTrial].
type CreateTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Study to create the Trial in.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The Trial to create.
	Trial *Trial `protobuf:"bytes,2,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *CreateTrialRequest) Reset() {
	*x = CreateTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTrialRequest) ProtoMessage() {}

func (x *CreateTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTrialRequest.ProtoReflect.Descriptor instead.
func (*CreateTrialRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{9}
}

func (x *CreateTrialRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTrialRequest) GetTrial() *Trial {
	if x != nil {
		return x.Trial
	}
	return nil
}

// Request message for
// [VizierService.GetTrial][google.cloud.aiplatform.v1beta1.VizierService.GetTrial].
type GetTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Trial resource.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTrialRequest) Reset() {
	*x = GetTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTrialRequest) ProtoMessage() {}

func (x *GetTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTrialRequest.ProtoReflect.Descriptor instead.
func (*GetTrialRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{10}
}

func (x *GetTrialRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VizierService.ListTrials][google.cloud.aiplatform.v1beta1.VizierService.ListTrials].
type ListTrialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the Study to list the Trial from.
	// Format: `projects/{project}/locations/{location}/studies/{study}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. A page token to request the next page of results.
	// If unspecified, there are no subsequent pages.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The number of Trials to retrieve per "page" of results.
	// If unspecified, the service will pick an appropriate default.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *ListTrialsRequest) Reset() {
	*x = ListTrialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTrialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrialsRequest) ProtoMessage() {}

func (x *ListTrialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrialsRequest.ProtoReflect.Descriptor instead.
func (*ListTrialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListTrialsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTrialsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTrialsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// Response message for
// [VizierService.ListTrials][google.cloud.aiplatform.v1beta1.VizierService.ListTrials].
type ListTrialsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Trials associated with the Study.
	Trials []*Trial `protobuf:"bytes,1,rep,name=trials,proto3" json:"trials,omitempty"`
	// Pass this token as the `page_token` field of the request for a
	// subsequent call.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTrialsResponse) Reset() {
	*x = ListTrialsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTrialsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTrialsResponse) ProtoMessage() {}

func (x *ListTrialsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTrialsResponse.ProtoReflect.Descriptor instead.
func (*ListTrialsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{12}
}

func (x *ListTrialsResponse) GetTrials() []*Trial {
	if x != nil {
		return x.Trials
	}
	return nil
}

func (x *ListTrialsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [VizierService.AddTrialMeasurement][google.cloud.aiplatform.v1beta1.VizierService.AddTrialMeasurement].
type AddTrialMeasurementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the trial to add measurement.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	TrialName string `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
	// Required. The measurement to be added to a Trial.
	Measurement *Measurement `protobuf:"bytes,3,opt,name=measurement,proto3" json:"measurement,omitempty"`
}

func (x *AddTrialMeasurementRequest) Reset() {
	*x = AddTrialMeasurementRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AddTrialMeasurementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddTrialMeasurementRequest) ProtoMessage() {}

func (x *AddTrialMeasurementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddTrialMeasurementRequest.ProtoReflect.Descriptor instead.
func (*AddTrialMeasurementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{13}
}

func (x *AddTrialMeasurementRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

func (x *AddTrialMeasurementRequest) GetMeasurement() *Measurement {
	if x != nil {
		return x.Measurement
	}
	return nil
}

// Request message for
// [VizierService.CompleteTrial][google.cloud.aiplatform.v1beta1.VizierService.CompleteTrial].
type CompleteTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Trial's name.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. If provided, it will be used as the completed Trial's
	// final_measurement; Otherwise, the service will auto-select a
	// previously reported measurement as the final-measurement
	FinalMeasurement *Measurement `protobuf:"bytes,2,opt,name=final_measurement,json=finalMeasurement,proto3" json:"final_measurement,omitempty"`
	// Optional. True if the Trial cannot be run with the given Parameter, and
	// final_measurement will be ignored.
	TrialInfeasible bool `protobuf:"varint,3,opt,name=trial_infeasible,json=trialInfeasible,proto3" json:"trial_infeasible,omitempty"`
	// Optional. A human readable reason why the trial was infeasible. This should
	// only be provided if `trial_infeasible` is true.
	InfeasibleReason string `protobuf:"bytes,4,opt,name=infeasible_reason,json=infeasibleReason,proto3" json:"infeasible_reason,omitempty"`
}

func (x *CompleteTrialRequest) Reset() {
	*x = CompleteTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CompleteTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteTrialRequest) ProtoMessage() {}

func (x *CompleteTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteTrialRequest.ProtoReflect.Descriptor instead.
func (*CompleteTrialRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{14}
}

func (x *CompleteTrialRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CompleteTrialRequest) GetFinalMeasurement() *Measurement {
	if x != nil {
		return x.FinalMeasurement
	}
	return nil
}

func (x *CompleteTrialRequest) GetTrialInfeasible() bool {
	if x != nil {
		return x.TrialInfeasible
	}
	return false
}

func (x *CompleteTrialRequest) GetInfeasibleReason() string {
	if x != nil {
		return x.InfeasibleReason
	}
	return ""
}

// Request message for
// [VizierService.DeleteTrial][google.cloud.aiplatform.v1beta1.VizierService.DeleteTrial].
type DeleteTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Trial's name.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTrialRequest) Reset() {
	*x = DeleteTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTrialRequest) ProtoMessage() {}

func (x *DeleteTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTrialRequest.ProtoReflect.Descriptor instead.
func (*DeleteTrialRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteTrialRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VizierService.CheckTrialEarlyStoppingState][google.cloud.aiplatform.v1beta1.VizierService.CheckTrialEarlyStoppingState].
type CheckTrialEarlyStoppingStateRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Trial's name.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	TrialName string `protobuf:"bytes,1,opt,name=trial_name,json=trialName,proto3" json:"trial_name,omitempty"`
}

func (x *CheckTrialEarlyStoppingStateRequest) Reset() {
	*x = CheckTrialEarlyStoppingStateRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckTrialEarlyStoppingStateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckTrialEarlyStoppingStateRequest) ProtoMessage() {}

func (x *CheckTrialEarlyStoppingStateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckTrialEarlyStoppingStateRequest.ProtoReflect.Descriptor instead.
func (*CheckTrialEarlyStoppingStateRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{16}
}

func (x *CheckTrialEarlyStoppingStateRequest) GetTrialName() string {
	if x != nil {
		return x.TrialName
	}
	return ""
}

// Response message for
// [VizierService.CheckTrialEarlyStoppingState][google.cloud.aiplatform.v1beta1.VizierService.CheckTrialEarlyStoppingState].
type CheckTrialEarlyStoppingStateResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// True if the Trial should stop.
	ShouldStop bool `protobuf:"varint,1,opt,name=should_stop,json=shouldStop,proto3" json:"should_stop,omitempty"`
}

func (x *CheckTrialEarlyStoppingStateResponse) Reset() {
	*x = CheckTrialEarlyStoppingStateResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckTrialEarlyStoppingStateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckTrialEarlyStoppingStateResponse) ProtoMessage() {}

func (x *CheckTrialEarlyStoppingStateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckTrialEarlyStoppingStateResponse.ProtoReflect.Descriptor instead.
func (*CheckTrialEarlyStoppingStateResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{17}
}

func (x *CheckTrialEarlyStoppingStateResponse) GetShouldStop() bool {
	if x != nil {
		return x.ShouldStop
	}
	return false
}

// This message will be placed in the metadata field of a
// google.longrunning.Operation associated with a CheckTrialEarlyStoppingState
// request.
type CheckTrialEarlyStoppingStateMetatdata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Operation metadata for suggesting Trials.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// The name of the Study that the Trial belongs to.
	Study string `protobuf:"bytes,2,opt,name=study,proto3" json:"study,omitempty"`
	// The Trial name.
	Trial string `protobuf:"bytes,3,opt,name=trial,proto3" json:"trial,omitempty"`
}

func (x *CheckTrialEarlyStoppingStateMetatdata) Reset() {
	*x = CheckTrialEarlyStoppingStateMetatdata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CheckTrialEarlyStoppingStateMetatdata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckTrialEarlyStoppingStateMetatdata) ProtoMessage() {}

func (x *CheckTrialEarlyStoppingStateMetatdata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckTrialEarlyStoppingStateMetatdata.ProtoReflect.Descriptor instead.
func (*CheckTrialEarlyStoppingStateMetatdata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{18}
}

func (x *CheckTrialEarlyStoppingStateMetatdata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *CheckTrialEarlyStoppingStateMetatdata) GetStudy() string {
	if x != nil {
		return x.Study
	}
	return ""
}

func (x *CheckTrialEarlyStoppingStateMetatdata) GetTrial() string {
	if x != nil {
		return x.Trial
	}
	return ""
}

// Request message for
// [VizierService.StopTrial][google.cloud.aiplatform.v1beta1.VizierService.StopTrial].
type StopTrialRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Trial's name.
	// Format:
	// `projects/{project}/locations/{location}/studies/{study}/trials/{trial}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopTrialRequest) Reset() {
	*x = StopTrialRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopTrialRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopTrialRequest) ProtoMessage() {}

func (x *StopTrialRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopTrialRequest.ProtoReflect.Descriptor instead.
func (*StopTrialRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{19}
}

func (x *StopTrialRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for
// [VizierService.ListOptimalTrials][google.cloud.aiplatform.v1beta1.VizierService.ListOptimalTrials].
type ListOptimalTrialsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Study that the optimal Trial belongs to.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ListOptimalTrialsRequest) Reset() {
	*x = ListOptimalTrialsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOptimalTrialsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOptimalTrialsRequest) ProtoMessage() {}

func (x *ListOptimalTrialsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOptimalTrialsRequest.ProtoReflect.Descriptor instead.
func (*ListOptimalTrialsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{20}
}

func (x *ListOptimalTrialsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for
// [VizierService.ListOptimalTrials][google.cloud.aiplatform.v1beta1.VizierService.ListOptimalTrials].
type ListOptimalTrialsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The pareto-optimal Trials for multiple objective Study or the
	// optimal trial for single objective Study. The definition of
	// pareto-optimal can be checked in wiki page.
	// https://en.wikipedia.org/wiki/Pareto_efficiency
	OptimalTrials []*Trial `protobuf:"bytes,1,rep,name=optimal_trials,json=optimalTrials,proto3" json:"optimal_trials,omitempty"`
}

func (x *ListOptimalTrialsResponse) Reset() {
	*x = ListOptimalTrialsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOptimalTrialsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOptimalTrialsResponse) ProtoMessage() {}

func (x *ListOptimalTrialsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOptimalTrialsResponse.ProtoReflect.Descriptor instead.
func (*ListOptimalTrialsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP(), []int{21}
}

func (x *ListOptimalTrialsResponse) GetOptimalTrials() []*Trial {
	if x != nil {
		return x.OptimalTrials
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_vizier_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x76, 0x69, 0x7a, 0x69, 0x65, 0x72, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x74, 0x75,
	0x64, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x4e, 0x0a, 0x0f, 0x47,
	0x65, 0x74, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x75, 0x64, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x73, 0x74, 0x75, 0x64, 0x79, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x53, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x7f, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x40, 0x0a, 0x07, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x07, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x51, 0x0a, 0x12, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7f, 0x0a, 0x12,
	0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0xf9, 0x01,
	0x0a, 0x14, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x73, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x4e, 0x0a, 0x08, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x73, 0x22, 0x98, 0x02, 0x0a, 0x15, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x3e, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x06, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x73, 0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x74, 0x75, 0x64, 0x79, 0x5f, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x73, 0x74, 0x75, 0x64, 0x79, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a, 0x15, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64,
	0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x22, 0x98, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21,
	0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x75, 0x64,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x0a, 0x05, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x4e, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9a, 0x01, 0x0a,
	0x11, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x7c, 0x0a, 0x12, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3e, 0x0a, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x06, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb9, 0x01, 0x0a, 0x1a, 0x41, 0x64, 0x64, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x53,
	0x0a, 0x0b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x22, 0x95, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x66, 0x69, 0x6e,
	0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x49,
	0x6e, 0x66, 0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x69, 0x6e, 0x66,
	0x65, 0x61, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x6e, 0x66, 0x65, 0x61,
	0x73, 0x69, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x51, 0x0a, 0x12, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6d,
	0x0a, 0x23, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c,
	0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x52, 0x09, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x47, 0x0a,
	0x24, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c, 0x79,
	0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x5f,
	0x73, 0x74, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x68, 0x6f, 0x75,
	0x6c, 0x64, 0x53, 0x74, 0x6f, 0x70, 0x22, 0xb9, 0x01, 0x0a, 0x25, 0x43, 0x68, 0x65, 0x63, 0x6b,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69,
	0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x74, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x75, 0x64, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74, 0x75, 0x64, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x22, 0x4f, 0x0a, 0x10, 0x53, 0x74, 0x6f, 0x70, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x5b, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3f, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x22, 0x6a, 0x0a, 0x19, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x61, 0x6c, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a,
	0x0e, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x61, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x0d, 0x6f,
	0x70, 0x74, 0x69, 0x6d, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x32, 0xa1, 0x18, 0x0a,
	0x0d, 0x56, 0x69, 0x7a, 0x69, 0x65, 0x72, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xba,
	0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x22, 0x4e, 0xda, 0x41, 0x0c,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x74, 0x75, 0x64, 0x79, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x39, 0x3a, 0x05, 0x73, 0x74, 0x75, 0x64, 0x79, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x12, 0xa5, 0x01, 0x0a, 0x08,
	0x47, 0x65, 0x74, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x75, 0x64, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75,
	0x64, 0x79, 0x22, 0x3f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x32, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xbb, 0x01, 0x0a, 0x0b, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64,
	0x69, 0x65, 0x73, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x75, 0x64, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53,
	0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65,
	0x73, 0x12, 0x9b, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64,
	0x79, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3f,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xb7, 0x01, 0x0a, 0x0b, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x75, 0x64, 0x79, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x53, 0x74, 0x75, 0x64, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x75, 0x64, 0x79, 0x22, 0x4b, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a,
	0x22, 0x37, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69,
	0x65, 0x73, 0x3a, 0x6c, 0x6f, 0x6f, 0x6b, 0x75, 0x70, 0x12, 0xe4, 0x01, 0x0a, 0x0d, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x35, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x7d, 0xca, 0x41, 0x2e, 0x0a, 0x15, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x15, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x12, 0xc3, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x57, 0xda,
	0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x42, 0x3a, 0x05, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x39, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0xae, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x48, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72,
	0x69, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc1, 0x01, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x12, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x13,
	0x41, 0x64, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x64, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x5e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x58,
	0x3a, 0x01, 0x2a, 0x22, 0x53, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x65, 0x61,
	0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0xbd, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x47, 0x3a, 0x01, 0x2a, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x12, 0xa4, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xbd, 0x02, 0x0a, 0x1c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61,
	0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72,
	0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01, 0xca, 0x41, 0x4d, 0x0a, 0x24, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x25, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72,
	0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x4d,
	0x65, 0x74, 0x61, 0x74, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x61, 0x3a, 0x01,
	0x2a, 0x22, 0x5c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x74, 0x72, 0x69,
	0x61, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x45, 0x61, 0x72,
	0x6c, 0x79, 0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0xb1, 0x01, 0x0a, 0x09, 0x53, 0x74, 0x6f, 0x70, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x74, 0x6f, 0x70, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x22, 0x49, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x43,
	0x3a, 0x01, 0x2a, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x69,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x74, 0x6f, 0x70, 0x12, 0xeb, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6d, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x4f, 0x70, 0x74, 0x69, 0x6d, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6d,
	0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x5f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x50, 0x3a, 0x01, 0x2a, 0x22, 0x4b, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x74,
	0x75, 0x64, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x3a,
	0x6c, 0x69, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6d, 0x61, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2,
	0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x42, 0xe9, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x12, 0x56, 0x69, 0x7a, 0x69, 0x65, 0x72,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61,
	0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31,
	0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c,
	0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_aiplatform_v1beta1_vizier_service_proto_goTypes = []interface{}{
	(*GetStudyRequest)(nil),                       // 0: google.cloud.aiplatform.v1beta1.GetStudyRequest
	(*CreateStudyRequest)(nil),                    // 1: google.cloud.aiplatform.v1beta1.CreateStudyRequest
	(*ListStudiesRequest)(nil),                    // 2: google.cloud.aiplatform.v1beta1.ListStudiesRequest
	(*ListStudiesResponse)(nil),                   // 3: google.cloud.aiplatform.v1beta1.ListStudiesResponse
	(*DeleteStudyRequest)(nil),                    // 4: google.cloud.aiplatform.v1beta1.DeleteStudyRequest
	(*LookupStudyRequest)(nil),                    // 5: google.cloud.aiplatform.v1beta1.LookupStudyRequest
	(*SuggestTrialsRequest)(nil),                  // 6: google.cloud.aiplatform.v1beta1.SuggestTrialsRequest
	(*SuggestTrialsResponse)(nil),                 // 7: google.cloud.aiplatform.v1beta1.SuggestTrialsResponse
	(*SuggestTrialsMetadata)(nil),                 // 8: google.cloud.aiplatform.v1beta1.SuggestTrialsMetadata
	(*CreateTrialRequest)(nil),                    // 9: google.cloud.aiplatform.v1beta1.CreateTrialRequest
	(*GetTrialRequest)(nil),                       // 10: google.cloud.aiplatform.v1beta1.GetTrialRequest
	(*ListTrialsRequest)(nil),                     // 11: google.cloud.aiplatform.v1beta1.ListTrialsRequest
	(*ListTrialsResponse)(nil),                    // 12: google.cloud.aiplatform.v1beta1.ListTrialsResponse
	(*AddTrialMeasurementRequest)(nil),            // 13: google.cloud.aiplatform.v1beta1.AddTrialMeasurementRequest
	(*CompleteTrialRequest)(nil),                  // 14: google.cloud.aiplatform.v1beta1.CompleteTrialRequest
	(*DeleteTrialRequest)(nil),                    // 15: google.cloud.aiplatform.v1beta1.DeleteTrialRequest
	(*CheckTrialEarlyStoppingStateRequest)(nil),   // 16: google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateRequest
	(*CheckTrialEarlyStoppingStateResponse)(nil),  // 17: google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateResponse
	(*CheckTrialEarlyStoppingStateMetatdata)(nil), // 18: google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateMetatdata
	(*StopTrialRequest)(nil),                      // 19: google.cloud.aiplatform.v1beta1.StopTrialRequest
	(*ListOptimalTrialsRequest)(nil),              // 20: google.cloud.aiplatform.v1beta1.ListOptimalTrialsRequest
	(*ListOptimalTrialsResponse)(nil),             // 21: google.cloud.aiplatform.v1beta1.ListOptimalTrialsResponse
	(*Study)(nil),                                 // 22: google.cloud.aiplatform.v1beta1.Study
	(*TrialContext)(nil),                          // 23: google.cloud.aiplatform.v1beta1.TrialContext
	(*Trial)(nil),                                 // 24: google.cloud.aiplatform.v1beta1.Trial
	(Study_State)(0),                              // 25: google.cloud.aiplatform.v1beta1.Study.State
	(*timestamppb.Timestamp)(nil),                 // 26: google.protobuf.Timestamp
	(*GenericOperationMetadata)(nil),              // 27: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*Measurement)(nil),                           // 28: google.cloud.aiplatform.v1beta1.Measurement
	(*emptypb.Empty)(nil),                         // 29: google.protobuf.Empty
	(*longrunningpb.Operation)(nil),               // 30: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_vizier_service_proto_depIdxs = []int32{
	22, // 0: google.cloud.aiplatform.v1beta1.CreateStudyRequest.study:type_name -> google.cloud.aiplatform.v1beta1.Study
	22, // 1: google.cloud.aiplatform.v1beta1.ListStudiesResponse.studies:type_name -> google.cloud.aiplatform.v1beta1.Study
	23, // 2: google.cloud.aiplatform.v1beta1.SuggestTrialsRequest.contexts:type_name -> google.cloud.aiplatform.v1beta1.TrialContext
	24, // 3: google.cloud.aiplatform.v1beta1.SuggestTrialsResponse.trials:type_name -> google.cloud.aiplatform.v1beta1.Trial
	25, // 4: google.cloud.aiplatform.v1beta1.SuggestTrialsResponse.study_state:type_name -> google.cloud.aiplatform.v1beta1.Study.State
	26, // 5: google.cloud.aiplatform.v1beta1.SuggestTrialsResponse.start_time:type_name -> google.protobuf.Timestamp
	26, // 6: google.cloud.aiplatform.v1beta1.SuggestTrialsResponse.end_time:type_name -> google.protobuf.Timestamp
	27, // 7: google.cloud.aiplatform.v1beta1.SuggestTrialsMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	24, // 8: google.cloud.aiplatform.v1beta1.CreateTrialRequest.trial:type_name -> google.cloud.aiplatform.v1beta1.Trial
	24, // 9: google.cloud.aiplatform.v1beta1.ListTrialsResponse.trials:type_name -> google.cloud.aiplatform.v1beta1.Trial
	28, // 10: google.cloud.aiplatform.v1beta1.AddTrialMeasurementRequest.measurement:type_name -> google.cloud.aiplatform.v1beta1.Measurement
	28, // 11: google.cloud.aiplatform.v1beta1.CompleteTrialRequest.final_measurement:type_name -> google.cloud.aiplatform.v1beta1.Measurement
	27, // 12: google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateMetatdata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	24, // 13: google.cloud.aiplatform.v1beta1.ListOptimalTrialsResponse.optimal_trials:type_name -> google.cloud.aiplatform.v1beta1.Trial
	1,  // 14: google.cloud.aiplatform.v1beta1.VizierService.CreateStudy:input_type -> google.cloud.aiplatform.v1beta1.CreateStudyRequest
	0,  // 15: google.cloud.aiplatform.v1beta1.VizierService.GetStudy:input_type -> google.cloud.aiplatform.v1beta1.GetStudyRequest
	2,  // 16: google.cloud.aiplatform.v1beta1.VizierService.ListStudies:input_type -> google.cloud.aiplatform.v1beta1.ListStudiesRequest
	4,  // 17: google.cloud.aiplatform.v1beta1.VizierService.DeleteStudy:input_type -> google.cloud.aiplatform.v1beta1.DeleteStudyRequest
	5,  // 18: google.cloud.aiplatform.v1beta1.VizierService.LookupStudy:input_type -> google.cloud.aiplatform.v1beta1.LookupStudyRequest
	6,  // 19: google.cloud.aiplatform.v1beta1.VizierService.SuggestTrials:input_type -> google.cloud.aiplatform.v1beta1.SuggestTrialsRequest
	9,  // 20: google.cloud.aiplatform.v1beta1.VizierService.CreateTrial:input_type -> google.cloud.aiplatform.v1beta1.CreateTrialRequest
	10, // 21: google.cloud.aiplatform.v1beta1.VizierService.GetTrial:input_type -> google.cloud.aiplatform.v1beta1.GetTrialRequest
	11, // 22: google.cloud.aiplatform.v1beta1.VizierService.ListTrials:input_type -> google.cloud.aiplatform.v1beta1.ListTrialsRequest
	13, // 23: google.cloud.aiplatform.v1beta1.VizierService.AddTrialMeasurement:input_type -> google.cloud.aiplatform.v1beta1.AddTrialMeasurementRequest
	14, // 24: google.cloud.aiplatform.v1beta1.VizierService.CompleteTrial:input_type -> google.cloud.aiplatform.v1beta1.CompleteTrialRequest
	15, // 25: google.cloud.aiplatform.v1beta1.VizierService.DeleteTrial:input_type -> google.cloud.aiplatform.v1beta1.DeleteTrialRequest
	16, // 26: google.cloud.aiplatform.v1beta1.VizierService.CheckTrialEarlyStoppingState:input_type -> google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateRequest
	19, // 27: google.cloud.aiplatform.v1beta1.VizierService.StopTrial:input_type -> google.cloud.aiplatform.v1beta1.StopTrialRequest
	20, // 28: google.cloud.aiplatform.v1beta1.VizierService.ListOptimalTrials:input_type -> google.cloud.aiplatform.v1beta1.ListOptimalTrialsRequest
	22, // 29: google.cloud.aiplatform.v1beta1.VizierService.CreateStudy:output_type -> google.cloud.aiplatform.v1beta1.Study
	22, // 30: google.cloud.aiplatform.v1beta1.VizierService.GetStudy:output_type -> google.cloud.aiplatform.v1beta1.Study
	3,  // 31: google.cloud.aiplatform.v1beta1.VizierService.ListStudies:output_type -> google.cloud.aiplatform.v1beta1.ListStudiesResponse
	29, // 32: google.cloud.aiplatform.v1beta1.VizierService.DeleteStudy:output_type -> google.protobuf.Empty
	22, // 33: google.cloud.aiplatform.v1beta1.VizierService.LookupStudy:output_type -> google.cloud.aiplatform.v1beta1.Study
	30, // 34: google.cloud.aiplatform.v1beta1.VizierService.SuggestTrials:output_type -> google.longrunning.Operation
	24, // 35: google.cloud.aiplatform.v1beta1.VizierService.CreateTrial:output_type -> google.cloud.aiplatform.v1beta1.Trial
	24, // 36: google.cloud.aiplatform.v1beta1.VizierService.GetTrial:output_type -> google.cloud.aiplatform.v1beta1.Trial
	12, // 37: google.cloud.aiplatform.v1beta1.VizierService.ListTrials:output_type -> google.cloud.aiplatform.v1beta1.ListTrialsResponse
	24, // 38: google.cloud.aiplatform.v1beta1.VizierService.AddTrialMeasurement:output_type -> google.cloud.aiplatform.v1beta1.Trial
	24, // 39: google.cloud.aiplatform.v1beta1.VizierService.CompleteTrial:output_type -> google.cloud.aiplatform.v1beta1.Trial
	29, // 40: google.cloud.aiplatform.v1beta1.VizierService.DeleteTrial:output_type -> google.protobuf.Empty
	30, // 41: google.cloud.aiplatform.v1beta1.VizierService.CheckTrialEarlyStoppingState:output_type -> google.longrunning.Operation
	24, // 42: google.cloud.aiplatform.v1beta1.VizierService.StopTrial:output_type -> google.cloud.aiplatform.v1beta1.Trial
	21, // 43: google.cloud.aiplatform.v1beta1.VizierService.ListOptimalTrials:output_type -> google.cloud.aiplatform.v1beta1.ListOptimalTrialsResponse
	29, // [29:44] is the sub-list for method output_type
	14, // [14:29] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_vizier_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_vizier_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_vizier_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_study_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetStudyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateStudyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStudiesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListStudiesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteStudyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LookupStudyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestTrialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestTrialsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SuggestTrialsMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTrialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTrialsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AddTrialMeasurementRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CompleteTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckTrialEarlyStoppingStateRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckTrialEarlyStoppingStateResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CheckTrialEarlyStoppingStateMetatdata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopTrialRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOptimalTrialsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListOptimalTrialsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_vizier_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_vizier_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_vizier_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_vizier_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_vizier_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// VizierServiceClient is the client API for VizierService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VizierServiceClient interface {
	// Creates a Study. A resource name will be generated after creation of the
	// Study.
	CreateStudy(ctx context.Context, in *CreateStudyRequest, opts ...grpc.CallOption) (*Study, error)
	// Gets a Study by name.
	GetStudy(ctx context.Context, in *GetStudyRequest, opts ...grpc.CallOption) (*Study, error)
	// Lists all the studies in a region for an associated project.
	ListStudies(ctx context.Context, in *ListStudiesRequest, opts ...grpc.CallOption) (*ListStudiesResponse, error)
	// Deletes a Study.
	DeleteStudy(ctx context.Context, in *DeleteStudyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Looks a study up using the user-defined display_name field instead of the
	// fully qualified resource name.
	LookupStudy(ctx context.Context, in *LookupStudyRequest, opts ...grpc.CallOption) (*Study, error)
	// Adds one or more Trials to a Study, with parameter values
	// suggested by Vertex AI Vizier. Returns a long-running
	// operation associated with the generation of Trial suggestions.
	// When this long-running operation succeeds, it will contain
	// a
	// [SuggestTrialsResponse][google.cloud.aiplatform.v1beta1.SuggestTrialsResponse].
	SuggestTrials(ctx context.Context, in *SuggestTrialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a user provided Trial to a Study.
	CreateTrial(ctx context.Context, in *CreateTrialRequest, opts ...grpc.CallOption) (*Trial, error)
	// Gets a Trial.
	GetTrial(ctx context.Context, in *GetTrialRequest, opts ...grpc.CallOption) (*Trial, error)
	// Lists the Trials associated with a Study.
	ListTrials(ctx context.Context, in *ListTrialsRequest, opts ...grpc.CallOption) (*ListTrialsResponse, error)
	// Adds a measurement of the objective metrics to a Trial. This measurement
	// is assumed to have been taken before the Trial is complete.
	AddTrialMeasurement(ctx context.Context, in *AddTrialMeasurementRequest, opts ...grpc.CallOption) (*Trial, error)
	// Marks a Trial as complete.
	CompleteTrial(ctx context.Context, in *CompleteTrialRequest, opts ...grpc.CallOption) (*Trial, error)
	// Deletes a Trial.
	DeleteTrial(ctx context.Context, in *DeleteTrialRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Checks  whether a Trial should stop or not. Returns a
	// long-running operation. When the operation is successful,
	// it will contain a
	// [CheckTrialEarlyStoppingStateResponse][google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateResponse].
	CheckTrialEarlyStoppingState(ctx context.Context, in *CheckTrialEarlyStoppingStateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Stops a Trial.
	StopTrial(ctx context.Context, in *StopTrialRequest, opts ...grpc.CallOption) (*Trial, error)
	// Lists the pareto-optimal Trials for multi-objective Study or the
	// optimal Trials for single-objective Study. The definition of
	// pareto-optimal can be checked in wiki page.
	// https://en.wikipedia.org/wiki/Pareto_efficiency
	ListOptimalTrials(ctx context.Context, in *ListOptimalTrialsRequest, opts ...grpc.CallOption) (*ListOptimalTrialsResponse, error)
}

type vizierServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVizierServiceClient(cc grpc.ClientConnInterface) VizierServiceClient {
	return &vizierServiceClient{cc}
}

func (c *vizierServiceClient) CreateStudy(ctx context.Context, in *CreateStudyRequest, opts ...grpc.CallOption) (*Study, error) {
	out := new(Study)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/CreateStudy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) GetStudy(ctx context.Context, in *GetStudyRequest, opts ...grpc.CallOption) (*Study, error) {
	out := new(Study)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/GetStudy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) ListStudies(ctx context.Context, in *ListStudiesRequest, opts ...grpc.CallOption) (*ListStudiesResponse, error) {
	out := new(ListStudiesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/ListStudies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) DeleteStudy(ctx context.Context, in *DeleteStudyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/DeleteStudy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) LookupStudy(ctx context.Context, in *LookupStudyRequest, opts ...grpc.CallOption) (*Study, error) {
	out := new(Study)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/LookupStudy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) SuggestTrials(ctx context.Context, in *SuggestTrialsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/SuggestTrials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) CreateTrial(ctx context.Context, in *CreateTrialRequest, opts ...grpc.CallOption) (*Trial, error) {
	out := new(Trial)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/CreateTrial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) GetTrial(ctx context.Context, in *GetTrialRequest, opts ...grpc.CallOption) (*Trial, error) {
	out := new(Trial)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/GetTrial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) ListTrials(ctx context.Context, in *ListTrialsRequest, opts ...grpc.CallOption) (*ListTrialsResponse, error) {
	out := new(ListTrialsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/ListTrials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) AddTrialMeasurement(ctx context.Context, in *AddTrialMeasurementRequest, opts ...grpc.CallOption) (*Trial, error) {
	out := new(Trial)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/AddTrialMeasurement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) CompleteTrial(ctx context.Context, in *CompleteTrialRequest, opts ...grpc.CallOption) (*Trial, error) {
	out := new(Trial)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/CompleteTrial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) DeleteTrial(ctx context.Context, in *DeleteTrialRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/DeleteTrial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) CheckTrialEarlyStoppingState(ctx context.Context, in *CheckTrialEarlyStoppingStateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/CheckTrialEarlyStoppingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) StopTrial(ctx context.Context, in *StopTrialRequest, opts ...grpc.CallOption) (*Trial, error) {
	out := new(Trial)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/StopTrial", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vizierServiceClient) ListOptimalTrials(ctx context.Context, in *ListOptimalTrialsRequest, opts ...grpc.CallOption) (*ListOptimalTrialsResponse, error) {
	out := new(ListOptimalTrialsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1beta1.VizierService/ListOptimalTrials", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VizierServiceServer is the server API for VizierService service.
type VizierServiceServer interface {
	// Creates a Study. A resource name will be generated after creation of the
	// Study.
	CreateStudy(context.Context, *CreateStudyRequest) (*Study, error)
	// Gets a Study by name.
	GetStudy(context.Context, *GetStudyRequest) (*Study, error)
	// Lists all the studies in a region for an associated project.
	ListStudies(context.Context, *ListStudiesRequest) (*ListStudiesResponse, error)
	// Deletes a Study.
	DeleteStudy(context.Context, *DeleteStudyRequest) (*emptypb.Empty, error)
	// Looks a study up using the user-defined display_name field instead of the
	// fully qualified resource name.
	LookupStudy(context.Context, *LookupStudyRequest) (*Study, error)
	// Adds one or more Trials to a Study, with parameter values
	// suggested by Vertex AI Vizier. Returns a long-running
	// operation associated with the generation of Trial suggestions.
	// When this long-running operation succeeds, it will contain
	// a
	// [SuggestTrialsResponse][google.cloud.aiplatform.v1beta1.SuggestTrialsResponse].
	SuggestTrials(context.Context, *SuggestTrialsRequest) (*longrunningpb.Operation, error)
	// Adds a user provided Trial to a Study.
	CreateTrial(context.Context, *CreateTrialRequest) (*Trial, error)
	// Gets a Trial.
	GetTrial(context.Context, *GetTrialRequest) (*Trial, error)
	// Lists the Trials associated with a Study.
	ListTrials(context.Context, *ListTrialsRequest) (*ListTrialsResponse, error)
	// Adds a measurement of the objective metrics to a Trial. This measurement
	// is assumed to have been taken before the Trial is complete.
	AddTrialMeasurement(context.Context, *AddTrialMeasurementRequest) (*Trial, error)
	// Marks a Trial as complete.
	CompleteTrial(context.Context, *CompleteTrialRequest) (*Trial, error)
	// Deletes a Trial.
	DeleteTrial(context.Context, *DeleteTrialRequest) (*emptypb.Empty, error)
	// Checks  whether a Trial should stop or not. Returns a
	// long-running operation. When the operation is successful,
	// it will contain a
	// [CheckTrialEarlyStoppingStateResponse][google.cloud.aiplatform.v1beta1.CheckTrialEarlyStoppingStateResponse].
	CheckTrialEarlyStoppingState(context.Context, *CheckTrialEarlyStoppingStateRequest) (*longrunningpb.Operation, error)
	// Stops a Trial.
	StopTrial(context.Context, *StopTrialRequest) (*Trial, error)
	// Lists the pareto-optimal Trials for multi-objective Study or the
	// optimal Trials for single-objective Study. The definition of
	// pareto-optimal can be checked in wiki page.
	// https://en.wikipedia.org/wiki/Pareto_efficiency
	ListOptimalTrials(context.Context, *ListOptimalTrialsRequest) (*ListOptimalTrialsResponse, error)
}

// UnimplementedVizierServiceServer can be embedded to have forward compatible implementations.
type UnimplementedVizierServiceServer struct {
}

func (*UnimplementedVizierServiceServer) CreateStudy(context.Context, *CreateStudyRequest) (*Study, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateStudy not implemented")
}
func (*UnimplementedVizierServiceServer) GetStudy(context.Context, *GetStudyRequest) (*Study, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStudy not implemented")
}
func (*UnimplementedVizierServiceServer) ListStudies(context.Context, *ListStudiesRequest) (*ListStudiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListStudies not implemented")
}
func (*UnimplementedVizierServiceServer) DeleteStudy(context.Context, *DeleteStudyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteStudy not implemented")
}
func (*UnimplementedVizierServiceServer) LookupStudy(context.Context, *LookupStudyRequest) (*Study, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LookupStudy not implemented")
}
func (*UnimplementedVizierServiceServer) SuggestTrials(context.Context, *SuggestTrialsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuggestTrials not implemented")
}
func (*UnimplementedVizierServiceServer) CreateTrial(context.Context, *CreateTrialRequest) (*Trial, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTrial not implemented")
}
func (*UnimplementedVizierServiceServer) GetTrial(context.Context, *GetTrialRequest) (*Trial, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrial not implemented")
}
func (*UnimplementedVizierServiceServer) ListTrials(context.Context, *ListTrialsRequest) (*ListTrialsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTrials not implemented")
}
func (*UnimplementedVizierServiceServer) AddTrialMeasurement(context.Context, *AddTrialMeasurementRequest) (*Trial, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddTrialMeasurement not implemented")
}
func (*UnimplementedVizierServiceServer) CompleteTrial(context.Context, *CompleteTrialRequest) (*Trial, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteTrial not implemented")
}
func (*UnimplementedVizierServiceServer) DeleteTrial(context.Context, *DeleteTrialRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrial not implemented")
}
func (*UnimplementedVizierServiceServer) CheckTrialEarlyStoppingState(context.Context, *CheckTrialEarlyStoppingStateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckTrialEarlyStoppingState not implemented")
}
func (*UnimplementedVizierServiceServer) StopTrial(context.Context, *StopTrialRequest) (*Trial, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopTrial not implemented")
}
func (*UnimplementedVizierServiceServer) ListOptimalTrials(context.Context, *ListOptimalTrialsRequest) (*ListOptimalTrialsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListOptimalTrials not implemented")
}

func RegisterVizierServiceServer(s *grpc.Server, srv VizierServiceServer) {
	s.RegisterService(&_VizierService_serviceDesc, srv)
}

func _VizierService_CreateStudy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateStudyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).CreateStudy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/CreateStudy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).CreateStudy(ctx, req.(*CreateStudyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_GetStudy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStudyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).GetStudy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/GetStudy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).GetStudy(ctx, req.(*GetStudyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_ListStudies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListStudiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).ListStudies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/ListStudies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).ListStudies(ctx, req.(*ListStudiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_DeleteStudy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteStudyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).DeleteStudy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/DeleteStudy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).DeleteStudy(ctx, req.(*DeleteStudyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_LookupStudy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LookupStudyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).LookupStudy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/LookupStudy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).LookupStudy(ctx, req.(*LookupStudyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_SuggestTrials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuggestTrialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).SuggestTrials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/SuggestTrials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).SuggestTrials(ctx, req.(*SuggestTrialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_CreateTrial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTrialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).CreateTrial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/CreateTrial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).CreateTrial(ctx, req.(*CreateTrialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_GetTrial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTrialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).GetTrial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/GetTrial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).GetTrial(ctx, req.(*GetTrialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_ListTrials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTrialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).ListTrials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/ListTrials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).ListTrials(ctx, req.(*ListTrialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_AddTrialMeasurement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddTrialMeasurementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).AddTrialMeasurement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/AddTrialMeasurement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).AddTrialMeasurement(ctx, req.(*AddTrialMeasurementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_CompleteTrial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteTrialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).CompleteTrial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/CompleteTrial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).CompleteTrial(ctx, req.(*CompleteTrialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_DeleteTrial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTrialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).DeleteTrial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/DeleteTrial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).DeleteTrial(ctx, req.(*DeleteTrialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_CheckTrialEarlyStoppingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckTrialEarlyStoppingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).CheckTrialEarlyStoppingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/CheckTrialEarlyStoppingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).CheckTrialEarlyStoppingState(ctx, req.(*CheckTrialEarlyStoppingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_StopTrial_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopTrialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).StopTrial(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/StopTrial",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).StopTrial(ctx, req.(*StopTrialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VizierService_ListOptimalTrials_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOptimalTrialsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VizierServiceServer).ListOptimalTrials(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1beta1.VizierService/ListOptimalTrials",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VizierServiceServer).ListOptimalTrials(ctx, req.(*ListOptimalTrialsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VizierService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1beta1.VizierService",
	HandlerType: (*VizierServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateStudy",
			Handler:    _VizierService_CreateStudy_Handler,
		},
		{
			MethodName: "GetStudy",
			Handler:    _VizierService_GetStudy_Handler,
		},
		{
			MethodName: "ListStudies",
			Handler:    _VizierService_ListStudies_Handler,
		},
		{
			MethodName: "DeleteStudy",
			Handler:    _VizierService_DeleteStudy_Handler,
		},
		{
			MethodName: "LookupStudy",
			Handler:    _VizierService_LookupStudy_Handler,
		},
		{
			MethodName: "SuggestTrials",
			Handler:    _VizierService_SuggestTrials_Handler,
		},
		{
			MethodName: "CreateTrial",
			Handler:    _VizierService_CreateTrial_Handler,
		},
		{
			MethodName: "GetTrial",
			Handler:    _VizierService_GetTrial_Handler,
		},
		{
			MethodName: "ListTrials",
			Handler:    _VizierService_ListTrials_Handler,
		},
		{
			MethodName: "AddTrialMeasurement",
			Handler:    _VizierService_AddTrialMeasurement_Handler,
		},
		{
			MethodName: "CompleteTrial",
			Handler:    _VizierService_CompleteTrial_Handler,
		},
		{
			MethodName: "DeleteTrial",
			Handler:    _VizierService_DeleteTrial_Handler,
		},
		{
			MethodName: "CheckTrialEarlyStoppingState",
			Handler:    _VizierService_CheckTrialEarlyStoppingState_Handler,
		},
		{
			MethodName: "StopTrial",
			Handler:    _VizierService_StopTrial_Handler,
		},
		{
			MethodName: "ListOptimalTrials",
			Handler:    _VizierService_ListOptimalTrials_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1beta1/vizier_service.proto",
}
