// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/gkebackup/v1/restore.proto

package gkebackuppb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible values for state of the Restore.
type Restore_State int32

const (
	// The Restore resource is in the process of being created.
	Restore_STATE_UNSPECIFIED Restore_State = 0
	// The Restore resource has been created and the associated RestoreJob
	// Kubernetes resource has been injected into target cluster.
	Restore_CREATING Restore_State = 1
	// The gkebackup agent in the cluster has begun executing the restore
	// operation.
	Restore_IN_PROGRESS Restore_State = 2
	// The restore operation has completed successfully. Restored workloads may
	// not yet be operational.
	Restore_SUCCEEDED Restore_State = 3
	// The restore operation has failed.
	Restore_FAILED Restore_State = 4
	// This Restore resource is in the process of being deleted.
	Restore_DELETING Restore_State = 5
)

// Enum value maps for Restore_State.
var (
	Restore_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "IN_PROGRESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "DELETING",
	}
	Restore_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"IN_PROGRESS":       2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"DELETING":          5,
	}
)

func (x Restore_State) Enum() *Restore_State {
	p := new(Restore_State)
	*p = x
	return p
}

func (x Restore_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Restore_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[0].Descriptor()
}

func (Restore_State) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[0]
}

func (x Restore_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Restore_State.Descriptor instead.
func (Restore_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{0, 0}
}

// Defines how volume data should be restored.
type RestoreConfig_VolumeDataRestorePolicy int32

const (
	// Unspecified (illegal).
	RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED RestoreConfig_VolumeDataRestorePolicy = 0
	// For each PVC to be restored, create a new underlying volume and PV
	// from the corresponding VolumeBackup contained within the Backup.
	RestoreConfig_RESTORE_VOLUME_DATA_FROM_BACKUP RestoreConfig_VolumeDataRestorePolicy = 1
	// For each PVC to be restored, attempt to reuse the original PV contained
	// in the Backup (with its original underlying volume). This option
	// is likely only usable when restoring a workload to its original cluster.
	RestoreConfig_REUSE_VOLUME_HANDLE_FROM_BACKUP RestoreConfig_VolumeDataRestorePolicy = 2
	// For each PVC to be restored, create PVC without any particular
	// action to restore data. In this case, the normal Kubernetes provisioning
	// logic would kick in, and this would likely result in either dynamically
	// provisioning blank PVs or binding to statically provisioned PVs.
	RestoreConfig_NO_VOLUME_DATA_RESTORATION RestoreConfig_VolumeDataRestorePolicy = 3
)

// Enum value maps for RestoreConfig_VolumeDataRestorePolicy.
var (
	RestoreConfig_VolumeDataRestorePolicy_name = map[int32]string{
		0: "VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED",
		1: "RESTORE_VOLUME_DATA_FROM_BACKUP",
		2: "REUSE_VOLUME_HANDLE_FROM_BACKUP",
		3: "NO_VOLUME_DATA_RESTORATION",
	}
	RestoreConfig_VolumeDataRestorePolicy_value = map[string]int32{
		"VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED": 0,
		"RESTORE_VOLUME_DATA_FROM_BACKUP":        1,
		"REUSE_VOLUME_HANDLE_FROM_BACKUP":        2,
		"NO_VOLUME_DATA_RESTORATION":             3,
	}
)

func (x RestoreConfig_VolumeDataRestorePolicy) Enum() *RestoreConfig_VolumeDataRestorePolicy {
	p := new(RestoreConfig_VolumeDataRestorePolicy)
	*p = x
	return p
}

func (x RestoreConfig_VolumeDataRestorePolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_VolumeDataRestorePolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[1].Descriptor()
}

func (RestoreConfig_VolumeDataRestorePolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[1]
}

func (x RestoreConfig_VolumeDataRestorePolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_VolumeDataRestorePolicy.Descriptor instead.
func (RestoreConfig_VolumeDataRestorePolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 0}
}

// Defines the behavior for handling the situation where cluster-scoped
// resources being restored already exist in the target cluster.
type RestoreConfig_ClusterResourceConflictPolicy int32

const (
	// Unspecified. Only allowed if no cluster-scoped resources will be
	// restored.
	RestoreConfig_CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED RestoreConfig_ClusterResourceConflictPolicy = 0
	// Do not attempt to restore the conflicting resource.
	RestoreConfig_USE_EXISTING_VERSION RestoreConfig_ClusterResourceConflictPolicy = 1
	// Delete the existing version before re-creating it from the Backup.
	// This is a dangerous option which could cause unintentional
	// data loss if used inappropriately. For example, deleting a CRD will
	// cause Kubernetes to delete all CRs of that type.
	RestoreConfig_USE_BACKUP_VERSION RestoreConfig_ClusterResourceConflictPolicy = 2
)

// Enum value maps for RestoreConfig_ClusterResourceConflictPolicy.
var (
	RestoreConfig_ClusterResourceConflictPolicy_name = map[int32]string{
		0: "CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED",
		1: "USE_EXISTING_VERSION",
		2: "USE_BACKUP_VERSION",
	}
	RestoreConfig_ClusterResourceConflictPolicy_value = map[string]int32{
		"CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED": 0,
		"USE_EXISTING_VERSION":                         1,
		"USE_BACKUP_VERSION":                           2,
	}
)

func (x RestoreConfig_ClusterResourceConflictPolicy) Enum() *RestoreConfig_ClusterResourceConflictPolicy {
	p := new(RestoreConfig_ClusterResourceConflictPolicy)
	*p = x
	return p
}

func (x RestoreConfig_ClusterResourceConflictPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_ClusterResourceConflictPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[2].Descriptor()
}

func (RestoreConfig_ClusterResourceConflictPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[2]
}

func (x RestoreConfig_ClusterResourceConflictPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_ClusterResourceConflictPolicy.Descriptor instead.
func (RestoreConfig_ClusterResourceConflictPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 1}
}

// Defines the behavior for handling the situation where sets of namespaced
// resources being restored already exist in the target cluster.
type RestoreConfig_NamespacedResourceRestoreMode int32

const (
	// Unspecified (invalid).
	RestoreConfig_NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED RestoreConfig_NamespacedResourceRestoreMode = 0
	// When conflicting top-level resources (either Namespaces or
	// ProtectedApplications, depending upon the scope) are encountered, this
	// will first trigger a delete of the conflicting resource AND ALL OF ITS
	// REFERENCED RESOURCES (e.g., all resources in the Namespace or all
	// resources referenced by the ProtectedApplication) before restoring the
	// resources from the Backup. This mode should only be used when you are
	// intending to revert some portion of a cluster to an earlier state.
	RestoreConfig_DELETE_AND_RESTORE RestoreConfig_NamespacedResourceRestoreMode = 1
	// If conflicting top-level resources (either Namespaces or
	// ProtectedApplications, depending upon the scope) are encountered at the
	// beginning of a restore process, the Restore will fail.  If a conflict
	// occurs during the restore process itself (e.g., because an out of band
	// process creates conflicting resources), a conflict will be reported.
	RestoreConfig_FAIL_ON_CONFLICT RestoreConfig_NamespacedResourceRestoreMode = 2
	// This mode merges the backup and the target cluster and skips the
	// conflicting resources. If a single resource to restore exists in the
	// cluster before restoration, the resource will be skipped, otherwise it
	// will be restored.
	RestoreConfig_MERGE_SKIP_ON_CONFLICT RestoreConfig_NamespacedResourceRestoreMode = 3
	// This mode merges the backup and the target cluster and skips the
	// conflicting resources except volume data. If a PVC to restore already
	// exists, this mode will restore/reconnect the volume without overwriting
	// the PVC. It is similar to MERGE_SKIP_ON_CONFLICT except that it will
	// apply the volume data policy for the conflicting PVCs:
	//   - RESTORE_VOLUME_DATA_FROM_BACKUP: restore data only and respect the
	//     reclaim policy of the original PV;
	//   - REUSE_VOLUME_HANDLE_FROM_BACKUP: reconnect and respect the reclaim
	//     policy of the original PV;
	//   - NO_VOLUME_DATA_RESTORATION: new provision and respect the reclaim
	//     policy of the original PV.
	//
	// Note that this mode could cause data loss as the original PV can be
	// retained or deleted depending on its reclaim policy.
	RestoreConfig_MERGE_REPLACE_VOLUME_ON_CONFLICT RestoreConfig_NamespacedResourceRestoreMode = 4
	// This mode merges the backup and the target cluster and replaces the
	// conflicting resources with the ones in the backup. If a single resource
	// to restore exists in the cluster before restoration, the resource will be
	// replaced with the one from the backup. To replace an existing resource,
	// the first attempt is to update the resource to match the one from the
	// backup; if the update fails, the second attempt is to delete the resource
	// and restore it from the backup.
	// Note that this mode could cause data loss as it replaces the existing
	// resources in the target cluster, and the original PV can be retained or
	// deleted depending on its reclaim policy.
	RestoreConfig_MERGE_REPLACE_ON_CONFLICT RestoreConfig_NamespacedResourceRestoreMode = 5
)

// Enum value maps for RestoreConfig_NamespacedResourceRestoreMode.
var (
	RestoreConfig_NamespacedResourceRestoreMode_name = map[int32]string{
		0: "NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED",
		1: "DELETE_AND_RESTORE",
		2: "FAIL_ON_CONFLICT",
		3: "MERGE_SKIP_ON_CONFLICT",
		4: "MERGE_REPLACE_VOLUME_ON_CONFLICT",
		5: "MERGE_REPLACE_ON_CONFLICT",
	}
	RestoreConfig_NamespacedResourceRestoreMode_value = map[string]int32{
		"NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED": 0,
		"DELETE_AND_RESTORE":                           1,
		"FAIL_ON_CONFLICT":                             2,
		"MERGE_SKIP_ON_CONFLICT":                       3,
		"MERGE_REPLACE_VOLUME_ON_CONFLICT":             4,
		"MERGE_REPLACE_ON_CONFLICT":                    5,
	}
)

func (x RestoreConfig_NamespacedResourceRestoreMode) Enum() *RestoreConfig_NamespacedResourceRestoreMode {
	p := new(RestoreConfig_NamespacedResourceRestoreMode)
	*p = x
	return p
}

func (x RestoreConfig_NamespacedResourceRestoreMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_NamespacedResourceRestoreMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[3].Descriptor()
}

func (RestoreConfig_NamespacedResourceRestoreMode) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[3]
}

func (x RestoreConfig_NamespacedResourceRestoreMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_NamespacedResourceRestoreMode.Descriptor instead.
func (RestoreConfig_NamespacedResourceRestoreMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 2}
}

// Possible values for operations of a transformation rule action.
type RestoreConfig_TransformationRuleAction_Op int32

const (
	// Unspecified operation
	RestoreConfig_TransformationRuleAction_OP_UNSPECIFIED RestoreConfig_TransformationRuleAction_Op = 0
	// The "remove" operation removes the value at the target location.
	RestoreConfig_TransformationRuleAction_REMOVE RestoreConfig_TransformationRuleAction_Op = 1
	// The "move" operation removes the value at a specified location and
	// adds it to the target location.
	RestoreConfig_TransformationRuleAction_MOVE RestoreConfig_TransformationRuleAction_Op = 2
	// The "copy" operation copies the value at a specified location to the
	// target location.
	RestoreConfig_TransformationRuleAction_COPY RestoreConfig_TransformationRuleAction_Op = 3
	// The "add" operation performs one of the following functions,
	// depending upon what the target location references:
	// 1. If the target location specifies an array index, a new value is
	// inserted into the array at the specified index.
	// 2. If the target location specifies an object member that does not
	// already exist, a new member is added to the object.
	// 3. If the target location specifies an object member that does exist,
	// that member's value is replaced.
	RestoreConfig_TransformationRuleAction_ADD RestoreConfig_TransformationRuleAction_Op = 4
	// The "test" operation tests that a value at the target location is
	// equal to a specified value.
	RestoreConfig_TransformationRuleAction_TEST RestoreConfig_TransformationRuleAction_Op = 5
	// The "replace" operation replaces the value at the target location
	// with a new value.  The operation object MUST contain a "value" member
	// whose content specifies the replacement value.
	RestoreConfig_TransformationRuleAction_REPLACE RestoreConfig_TransformationRuleAction_Op = 6
)

// Enum value maps for RestoreConfig_TransformationRuleAction_Op.
var (
	RestoreConfig_TransformationRuleAction_Op_name = map[int32]string{
		0: "OP_UNSPECIFIED",
		1: "REMOVE",
		2: "MOVE",
		3: "COPY",
		4: "ADD",
		5: "TEST",
		6: "REPLACE",
	}
	RestoreConfig_TransformationRuleAction_Op_value = map[string]int32{
		"OP_UNSPECIFIED": 0,
		"REMOVE":         1,
		"MOVE":           2,
		"COPY":           3,
		"ADD":            4,
		"TEST":           5,
		"REPLACE":        6,
	}
)

func (x RestoreConfig_TransformationRuleAction_Op) Enum() *RestoreConfig_TransformationRuleAction_Op {
	p := new(RestoreConfig_TransformationRuleAction_Op)
	*p = x
	return p
}

func (x RestoreConfig_TransformationRuleAction_Op) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RestoreConfig_TransformationRuleAction_Op) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_gkebackup_v1_restore_proto_enumTypes[4].Descriptor()
}

func (RestoreConfig_TransformationRuleAction_Op) Type() protoreflect.EnumType {
	return &file_google_cloud_gkebackup_v1_restore_proto_enumTypes[4]
}

func (x RestoreConfig_TransformationRuleAction_Op) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RestoreConfig_TransformationRuleAction_Op.Descriptor instead.
func (RestoreConfig_TransformationRuleAction_Op) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 3, 0}
}

// Represents both a request to Restore some portion of a Backup into
// a target GKE cluster and a record of the restore operation itself.
type Restore struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The full name of the Restore resource.
	// Format: `projects/*/locations/*/restorePlans/*/restores/*`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server generated global unique identifier of
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The timestamp when this Restore resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when this Restore resource was last
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User specified descriptive string for this Restore.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Immutable. A reference to the
	// [Backup][google.cloud.gkebackup.v1.Backup] used as the source from which
	// this Restore will restore. Note that this Backup must be a sub-resource of
	// the RestorePlan's
	// [backup_plan][google.cloud.gkebackup.v1.RestorePlan.backup_plan]. Format:
	// `projects/*/locations/*/backupPlans/*/backups/*`.
	Backup string `protobuf:"bytes,6,opt,name=backup,proto3" json:"backup,omitempty"`
	// Output only. The target cluster into which this Restore will restore data.
	// Valid formats:
	//
	//   - `projects/*/locations/*/clusters/*`
	//   - `projects/*/zones/*/clusters/*`
	//
	// Inherited from parent RestorePlan's
	// [cluster][google.cloud.gkebackup.v1.RestorePlan.cluster] value.
	Cluster string `protobuf:"bytes,7,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Output only. Configuration of the Restore.  Inherited from parent
	// RestorePlan's
	// [restore_config][google.cloud.gkebackup.v1.RestorePlan.restore_config].
	RestoreConfig *RestoreConfig `protobuf:"bytes,8,opt,name=restore_config,json=restoreConfig,proto3" json:"restore_config,omitempty"`
	// A set of custom labels supplied by user.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The current state of the Restore.
	State Restore_State `protobuf:"varint,10,opt,name=state,proto3,enum=google.cloud.gkebackup.v1.Restore_State" json:"state,omitempty"`
	// Output only. Human-readable description of why the Restore is in its
	// current state.
	StateReason string `protobuf:"bytes,11,opt,name=state_reason,json=stateReason,proto3" json:"state_reason,omitempty"`
	// Output only. Timestamp of when the restore operation completed.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Output only. Number of resources restored during the restore execution.
	ResourcesRestoredCount int32 `protobuf:"varint,13,opt,name=resources_restored_count,json=resourcesRestoredCount,proto3" json:"resources_restored_count,omitempty"`
	// Output only. Number of resources excluded during the restore execution.
	ResourcesExcludedCount int32 `protobuf:"varint,14,opt,name=resources_excluded_count,json=resourcesExcludedCount,proto3" json:"resources_excluded_count,omitempty"`
	// Output only. Number of resources that failed to be restored during the
	// restore execution.
	ResourcesFailedCount int32 `protobuf:"varint,15,opt,name=resources_failed_count,json=resourcesFailedCount,proto3" json:"resources_failed_count,omitempty"`
	// Output only. Number of volumes restored during the restore execution.
	VolumesRestoredCount int32 `protobuf:"varint,16,opt,name=volumes_restored_count,json=volumesRestoredCount,proto3" json:"volumes_restored_count,omitempty"`
	// Output only. `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a restore from overwriting each other.
	// It is strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform restore updates in order to avoid
	// race conditions: An `etag` is returned in the response to `GetRestore`,
	// and systems are expected to put that etag in the request to
	// `UpdateRestore` or `DeleteRestore` to ensure that their change will be
	// applied to the same version of the resource.
	Etag string `protobuf:"bytes,17,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. Immutable. Filters resources for `Restore`. If not specified, the
	// scope of the restore will remain the same as defined in the `RestorePlan`.
	// If this is specified, and no resources are matched by the
	// `inclusion_filters` or everyting is excluded by the `exclusion_filters`,
	// nothing will be restored. This filter can only be specified if the value of
	// [namespaced_resource_restore_mode][google.cloud.gkebackup.v1.RestoreConfig.namespaced_resource_restore_mode]
	// is set to `MERGE_SKIP_ON_CONFLICT`, `MERGE_REPLACE_VOLUME_ON_CONFLICT` or
	// `MERGE_REPLACE_ON_CONFLICT`.
	Filter *Restore_Filter `protobuf:"bytes,18,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Immutable. Overrides the volume data restore policies selected in
	// the Restore Config for override-scoped resources.
	VolumeDataRestorePolicyOverrides []*VolumeDataRestorePolicyOverride `protobuf:"bytes,19,rep,name=volume_data_restore_policy_overrides,json=volumeDataRestorePolicyOverrides,proto3" json:"volume_data_restore_policy_overrides,omitempty"`
}

func (x *Restore) Reset() {
	*x = Restore{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Restore) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Restore) ProtoMessage() {}

func (x *Restore) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Restore.ProtoReflect.Descriptor instead.
func (*Restore) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{0}
}

func (x *Restore) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Restore) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Restore) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Restore) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Restore) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Restore) GetBackup() string {
	if x != nil {
		return x.Backup
	}
	return ""
}

func (x *Restore) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *Restore) GetRestoreConfig() *RestoreConfig {
	if x != nil {
		return x.RestoreConfig
	}
	return nil
}

func (x *Restore) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Restore) GetState() Restore_State {
	if x != nil {
		return x.State
	}
	return Restore_STATE_UNSPECIFIED
}

func (x *Restore) GetStateReason() string {
	if x != nil {
		return x.StateReason
	}
	return ""
}

func (x *Restore) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *Restore) GetResourcesRestoredCount() int32 {
	if x != nil {
		return x.ResourcesRestoredCount
	}
	return 0
}

func (x *Restore) GetResourcesExcludedCount() int32 {
	if x != nil {
		return x.ResourcesExcludedCount
	}
	return 0
}

func (x *Restore) GetResourcesFailedCount() int32 {
	if x != nil {
		return x.ResourcesFailedCount
	}
	return 0
}

func (x *Restore) GetVolumesRestoredCount() int32 {
	if x != nil {
		return x.VolumesRestoredCount
	}
	return 0
}

func (x *Restore) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Restore) GetFilter() *Restore_Filter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *Restore) GetVolumeDataRestorePolicyOverrides() []*VolumeDataRestorePolicyOverride {
	if x != nil {
		return x.VolumeDataRestorePolicyOverrides
	}
	return nil
}

// Configuration of a restore.
type RestoreConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies the mechanism to be used to restore volume data.
	// Default: VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED (will be treated as
	// NO_VOLUME_DATA_RESTORATION).
	VolumeDataRestorePolicy RestoreConfig_VolumeDataRestorePolicy `protobuf:"varint,1,opt,name=volume_data_restore_policy,json=volumeDataRestorePolicy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_VolumeDataRestorePolicy" json:"volume_data_restore_policy,omitempty"`
	// Optional. Defines the behavior for handling the situation where
	// cluster-scoped resources being restored already exist in the target
	// cluster. This MUST be set to a value other than
	// CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED if
	// [cluster_resource_restore_scope][google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope]
	// is not empty.
	ClusterResourceConflictPolicy RestoreConfig_ClusterResourceConflictPolicy `protobuf:"varint,2,opt,name=cluster_resource_conflict_policy,json=clusterResourceConflictPolicy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_ClusterResourceConflictPolicy" json:"cluster_resource_conflict_policy,omitempty"`
	// Optional. Defines the behavior for handling the situation where sets of
	// namespaced resources being restored already exist in the target cluster.
	// This MUST be set to a value other than
	// NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED.
	NamespacedResourceRestoreMode RestoreConfig_NamespacedResourceRestoreMode `protobuf:"varint,3,opt,name=namespaced_resource_restore_mode,json=namespacedResourceRestoreMode,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_NamespacedResourceRestoreMode" json:"namespaced_resource_restore_mode,omitempty"`
	// Optional. Identifies the cluster-scoped resources to restore from the
	// Backup. Not specifying it means NO cluster resource will be restored.
	ClusterResourceRestoreScope *RestoreConfig_ClusterResourceRestoreScope `protobuf:"bytes,4,opt,name=cluster_resource_restore_scope,json=clusterResourceRestoreScope,proto3" json:"cluster_resource_restore_scope,omitempty"`
	// Specifies the namespaced resources to restore from the Backup.
	// Only one of the entries may be specified. If not specified, NO namespaced
	// resources will be restored.
	//
	// Note: Resources will never be restored into *managed* namespaces such as
	// `kube-system`, `kube-public`, or `kube-node-lease`. These namespaces
	// are silently skipped when
	// [all_namespaces][google.cloud.gkebackup.v1.RestoreConfig.all_namespaces] is
	// selected. Listing them explicitly will result in an error.
	//
	// Types that are assignable to NamespacedResourceRestoreScope:
	//
	//	*RestoreConfig_AllNamespaces
	//	*RestoreConfig_SelectedNamespaces
	//	*RestoreConfig_SelectedApplications
	//	*RestoreConfig_NoNamespaces
	//	*RestoreConfig_ExcludedNamespaces
	NamespacedResourceRestoreScope isRestoreConfig_NamespacedResourceRestoreScope `protobuf_oneof:"namespaced_resource_restore_scope"`
	// Optional. A list of transformation rules to be applied against Kubernetes
	// resources as they are selected for restoration from a Backup. Rules are
	// executed in order defined - this order matters, as changes made by a rule
	// may impact the filtering logic of subsequent rules. An empty list means no
	// substitution will occur.
	SubstitutionRules []*RestoreConfig_SubstitutionRule `protobuf:"bytes,8,rep,name=substitution_rules,json=substitutionRules,proto3" json:"substitution_rules,omitempty"`
	// Optional. A list of transformation rules to be applied against Kubernetes
	// resources as they are selected for restoration from a Backup. Rules are
	// executed in order defined - this order matters, as changes made by a rule
	// may impact the filtering logic of subsequent rules. An empty list means no
	// transformation will occur.
	TransformationRules []*RestoreConfig_TransformationRule `protobuf:"bytes,11,rep,name=transformation_rules,json=transformationRules,proto3" json:"transformation_rules,omitempty"`
	// Optional. A table that binds volumes by their scope to a restore policy.
	// Bindings must have a unique scope. Any volumes not scoped in the bindings
	// are subject to the policy defined in volume_data_restore_policy.
	VolumeDataRestorePolicyBindings []*RestoreConfig_VolumeDataRestorePolicyBinding `protobuf:"bytes,12,rep,name=volume_data_restore_policy_bindings,json=volumeDataRestorePolicyBindings,proto3" json:"volume_data_restore_policy_bindings,omitempty"`
	// Optional. RestoreOrder contains custom ordering to use on a Restore.
	RestoreOrder *RestoreConfig_RestoreOrder `protobuf:"bytes,13,opt,name=restore_order,json=restoreOrder,proto3" json:"restore_order,omitempty"`
}

func (x *RestoreConfig) Reset() {
	*x = RestoreConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig) ProtoMessage() {}

func (x *RestoreConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig.ProtoReflect.Descriptor instead.
func (*RestoreConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1}
}

func (x *RestoreConfig) GetVolumeDataRestorePolicy() RestoreConfig_VolumeDataRestorePolicy {
	if x != nil {
		return x.VolumeDataRestorePolicy
	}
	return RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
}

func (x *RestoreConfig) GetClusterResourceConflictPolicy() RestoreConfig_ClusterResourceConflictPolicy {
	if x != nil {
		return x.ClusterResourceConflictPolicy
	}
	return RestoreConfig_CLUSTER_RESOURCE_CONFLICT_POLICY_UNSPECIFIED
}

func (x *RestoreConfig) GetNamespacedResourceRestoreMode() RestoreConfig_NamespacedResourceRestoreMode {
	if x != nil {
		return x.NamespacedResourceRestoreMode
	}
	return RestoreConfig_NAMESPACED_RESOURCE_RESTORE_MODE_UNSPECIFIED
}

func (x *RestoreConfig) GetClusterResourceRestoreScope() *RestoreConfig_ClusterResourceRestoreScope {
	if x != nil {
		return x.ClusterResourceRestoreScope
	}
	return nil
}

func (m *RestoreConfig) GetNamespacedResourceRestoreScope() isRestoreConfig_NamespacedResourceRestoreScope {
	if m != nil {
		return m.NamespacedResourceRestoreScope
	}
	return nil
}

func (x *RestoreConfig) GetAllNamespaces() bool {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_AllNamespaces); ok {
		return x.AllNamespaces
	}
	return false
}

func (x *RestoreConfig) GetSelectedNamespaces() *Namespaces {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_SelectedNamespaces); ok {
		return x.SelectedNamespaces
	}
	return nil
}

func (x *RestoreConfig) GetSelectedApplications() *NamespacedNames {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_SelectedApplications); ok {
		return x.SelectedApplications
	}
	return nil
}

func (x *RestoreConfig) GetNoNamespaces() bool {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_NoNamespaces); ok {
		return x.NoNamespaces
	}
	return false
}

func (x *RestoreConfig) GetExcludedNamespaces() *Namespaces {
	if x, ok := x.GetNamespacedResourceRestoreScope().(*RestoreConfig_ExcludedNamespaces); ok {
		return x.ExcludedNamespaces
	}
	return nil
}

func (x *RestoreConfig) GetSubstitutionRules() []*RestoreConfig_SubstitutionRule {
	if x != nil {
		return x.SubstitutionRules
	}
	return nil
}

func (x *RestoreConfig) GetTransformationRules() []*RestoreConfig_TransformationRule {
	if x != nil {
		return x.TransformationRules
	}
	return nil
}

func (x *RestoreConfig) GetVolumeDataRestorePolicyBindings() []*RestoreConfig_VolumeDataRestorePolicyBinding {
	if x != nil {
		return x.VolumeDataRestorePolicyBindings
	}
	return nil
}

func (x *RestoreConfig) GetRestoreOrder() *RestoreConfig_RestoreOrder {
	if x != nil {
		return x.RestoreOrder
	}
	return nil
}

type isRestoreConfig_NamespacedResourceRestoreScope interface {
	isRestoreConfig_NamespacedResourceRestoreScope()
}

type RestoreConfig_AllNamespaces struct {
	// Restore all namespaced resources in the Backup if set to "True".
	// Specifying this field to "False" is an error.
	AllNamespaces bool `protobuf:"varint,5,opt,name=all_namespaces,json=allNamespaces,proto3,oneof"`
}

type RestoreConfig_SelectedNamespaces struct {
	// A list of selected Namespaces to restore from the Backup. The listed
	// Namespaces and all resources contained in them will be restored.
	SelectedNamespaces *Namespaces `protobuf:"bytes,6,opt,name=selected_namespaces,json=selectedNamespaces,proto3,oneof"`
}

type RestoreConfig_SelectedApplications struct {
	// A list of selected ProtectedApplications to restore. The listed
	// ProtectedApplications and all the resources to which they refer will be
	// restored.
	SelectedApplications *NamespacedNames `protobuf:"bytes,7,opt,name=selected_applications,json=selectedApplications,proto3,oneof"`
}

type RestoreConfig_NoNamespaces struct {
	// Do not restore any namespaced resources if set to "True".
	// Specifying this field to "False" is not allowed.
	NoNamespaces bool `protobuf:"varint,9,opt,name=no_namespaces,json=noNamespaces,proto3,oneof"`
}

type RestoreConfig_ExcludedNamespaces struct {
	// A list of selected namespaces excluded from restoration. All
	// namespaces except those in this list will be restored.
	ExcludedNamespaces *Namespaces `protobuf:"bytes,10,opt,name=excluded_namespaces,json=excludedNamespaces,proto3,oneof"`
}

func (*RestoreConfig_AllNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_SelectedNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_SelectedApplications) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_NoNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

func (*RestoreConfig_ExcludedNamespaces) isRestoreConfig_NamespacedResourceRestoreScope() {}

// Defines a selector to identify a single or a group of resources.
// Conditions in the selector are optional, but at least one field
// should be set to a non-empty value. If a condition is not specified,
// no restrictions will be applied on that dimension.
// If more than one condition is specified, a resource will be selected
// if and only if all conditions are met.
type ResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Selects resources using their Kubernetes GroupKinds. If
	// specified, only resources of provided GroupKind will be selected.
	GroupKind *RestoreConfig_GroupKind `protobuf:"bytes,1,opt,name=group_kind,json=groupKind,proto3" json:"group_kind,omitempty"`
	// Optional. Selects resources using their resource names. If specified,
	// only resources with the provided name will be selected.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Selects resources using their namespaces. This only applies to
	// namespace scoped resources and cannot be used for selecting
	// cluster scoped resources. If specified, only resources in the provided
	// namespace will be selected. If not specified, the filter will apply to
	// both cluster scoped and namespace scoped resources (e.g. name or label).
	// The [Namespace](https://pkg.go.dev/k8s.io/api/core/v1#Namespace) resource
	// itself will be restored if and only if any resources within the namespace
	// are restored.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Optional. Selects resources using Kubernetes
	// [labels](https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/).
	// If specified, a resource will be selected if and only if the resource
	// has all of the provided labels and all the label values match.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ResourceSelector) Reset() {
	*x = ResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceSelector) ProtoMessage() {}

func (x *ResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceSelector.ProtoReflect.Descriptor instead.
func (*ResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{2}
}

func (x *ResourceSelector) GetGroupKind() *RestoreConfig_GroupKind {
	if x != nil {
		return x.GroupKind
	}
	return nil
}

func (x *ResourceSelector) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ResourceSelector) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *ResourceSelector) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Defines an override to apply a VolumeDataRestorePolicy for scoped resources.
type VolumeDataRestorePolicyOverride struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VolumeDataRestorePolicy to apply when restoring volumes in
	// scope.
	Policy RestoreConfig_VolumeDataRestorePolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_VolumeDataRestorePolicy" json:"policy,omitempty"`
	// Types that are assignable to Scope:
	//
	//	*VolumeDataRestorePolicyOverride_SelectedPvcs
	Scope isVolumeDataRestorePolicyOverride_Scope `protobuf_oneof:"scope"`
}

func (x *VolumeDataRestorePolicyOverride) Reset() {
	*x = VolumeDataRestorePolicyOverride{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VolumeDataRestorePolicyOverride) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VolumeDataRestorePolicyOverride) ProtoMessage() {}

func (x *VolumeDataRestorePolicyOverride) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VolumeDataRestorePolicyOverride.ProtoReflect.Descriptor instead.
func (*VolumeDataRestorePolicyOverride) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{3}
}

func (x *VolumeDataRestorePolicyOverride) GetPolicy() RestoreConfig_VolumeDataRestorePolicy {
	if x != nil {
		return x.Policy
	}
	return RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
}

func (m *VolumeDataRestorePolicyOverride) GetScope() isVolumeDataRestorePolicyOverride_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (x *VolumeDataRestorePolicyOverride) GetSelectedPvcs() *NamespacedNames {
	if x, ok := x.GetScope().(*VolumeDataRestorePolicyOverride_SelectedPvcs); ok {
		return x.SelectedPvcs
	}
	return nil
}

type isVolumeDataRestorePolicyOverride_Scope interface {
	isVolumeDataRestorePolicyOverride_Scope()
}

type VolumeDataRestorePolicyOverride_SelectedPvcs struct {
	// A list of PVCs to apply the policy override to.
	SelectedPvcs *NamespacedNames `protobuf:"bytes,2,opt,name=selected_pvcs,json=selectedPvcs,proto3,oneof"`
}

func (*VolumeDataRestorePolicyOverride_SelectedPvcs) isVolumeDataRestorePolicyOverride_Scope() {}

// Defines the filter for `Restore`. This filter can be used to further
// refine the resource selection of the `Restore` beyond the coarse-grained
// scope defined in the `RestorePlan`. `exclusion_filters` take precedence
// over `inclusion_filters`. If a resource matches both `inclusion_filters`
// and `exclusion_filters`, it will not be restored.
type Restore_Filter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Selects resources for restoration. If specified, only resources
	// which match `inclusion_filters` will be selected for restoration. A
	// resource will be selected if it matches any `ResourceSelector` of the
	// `inclusion_filters`.
	InclusionFilters []*ResourceSelector `protobuf:"bytes,1,rep,name=inclusion_filters,json=inclusionFilters,proto3" json:"inclusion_filters,omitempty"`
	// Optional. Excludes resources from restoration. If specified,
	// a resource will not be restored if it matches
	// any `ResourceSelector` of the `exclusion_filters`.
	ExclusionFilters []*ResourceSelector `protobuf:"bytes,2,rep,name=exclusion_filters,json=exclusionFilters,proto3" json:"exclusion_filters,omitempty"`
}

func (x *Restore_Filter) Reset() {
	*x = Restore_Filter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Restore_Filter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Restore_Filter) ProtoMessage() {}

func (x *Restore_Filter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Restore_Filter.ProtoReflect.Descriptor instead.
func (*Restore_Filter) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Restore_Filter) GetInclusionFilters() []*ResourceSelector {
	if x != nil {
		return x.InclusionFilters
	}
	return nil
}

func (x *Restore_Filter) GetExclusionFilters() []*ResourceSelector {
	if x != nil {
		return x.ExclusionFilters
	}
	return nil
}

// This is a direct map to the Kubernetes GroupKind type
// [GroupKind](https://godoc.org/k8s.io/apimachinery/pkg/runtime/schema#GroupKind)
// and is used for identifying specific "types" of resources to restore.
type RestoreConfig_GroupKind struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. API group string of a Kubernetes resource, e.g.
	// "apiextensions.k8s.io", "storage.k8s.io", etc.
	// Note: use empty string for core API group
	ResourceGroup string `protobuf:"bytes,1,opt,name=resource_group,json=resourceGroup,proto3" json:"resource_group,omitempty"`
	// Optional. Kind of a Kubernetes resource, must be in UpperCamelCase
	// (PascalCase) and singular form. E.g. "CustomResourceDefinition",
	// "StorageClass", etc.
	ResourceKind string `protobuf:"bytes,2,opt,name=resource_kind,json=resourceKind,proto3" json:"resource_kind,omitempty"`
}

func (x *RestoreConfig_GroupKind) Reset() {
	*x = RestoreConfig_GroupKind{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_GroupKind) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_GroupKind) ProtoMessage() {}

func (x *RestoreConfig_GroupKind) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_GroupKind.ProtoReflect.Descriptor instead.
func (*RestoreConfig_GroupKind) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 0}
}

func (x *RestoreConfig_GroupKind) GetResourceGroup() string {
	if x != nil {
		return x.ResourceGroup
	}
	return ""
}

func (x *RestoreConfig_GroupKind) GetResourceKind() string {
	if x != nil {
		return x.ResourceKind
	}
	return ""
}

// Defines the scope of cluster-scoped resources to restore.
//
// Some group kinds are not reasonable choices for a restore, and will cause
// an error if selected here. Any scope selection that would restore
// "all valid" resources automatically excludes these group kinds.
// - gkebackup.gke.io/BackupJob
// - gkebackup.gke.io/RestoreJob
// - metrics.k8s.io/NodeMetrics
// - migration.k8s.io/StorageState
// - migration.k8s.io/StorageVersionMigration
// - Node
// - snapshot.storage.k8s.io/VolumeSnapshotContent
// - storage.k8s.io/CSINode
//
// Some group kinds are driven by restore configuration elsewhere,
// and will cause an error if selected here.
// - Namespace
// - PersistentVolume
type RestoreConfig_ClusterResourceRestoreScope struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of cluster-scoped resource group kinds to restore from
	// the backup. If specified, only the selected resources will be restored.
	// Mutually exclusive to any other field in the message.
	SelectedGroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,1,rep,name=selected_group_kinds,json=selectedGroupKinds,proto3" json:"selected_group_kinds,omitempty"`
	// Optional. A list of cluster-scoped resource group kinds to NOT restore
	// from the backup. If specified, all valid cluster-scoped resources will be
	// restored except for those specified in the list.
	// Mutually exclusive to any other field in the message.
	ExcludedGroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,2,rep,name=excluded_group_kinds,json=excludedGroupKinds,proto3" json:"excluded_group_kinds,omitempty"`
	// Optional. If True, all valid cluster-scoped resources will be restored.
	// Mutually exclusive to any other field in the message.
	AllGroupKinds bool `protobuf:"varint,3,opt,name=all_group_kinds,json=allGroupKinds,proto3" json:"all_group_kinds,omitempty"`
	// Optional. If True, no cluster-scoped resources will be restored.
	// This has the same restore scope as if the message is not defined.
	// Mutually exclusive to any other field in the message.
	NoGroupKinds bool `protobuf:"varint,4,opt,name=no_group_kinds,json=noGroupKinds,proto3" json:"no_group_kinds,omitempty"`
}

func (x *RestoreConfig_ClusterResourceRestoreScope) Reset() {
	*x = RestoreConfig_ClusterResourceRestoreScope{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_ClusterResourceRestoreScope) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_ClusterResourceRestoreScope) ProtoMessage() {}

func (x *RestoreConfig_ClusterResourceRestoreScope) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_ClusterResourceRestoreScope.ProtoReflect.Descriptor instead.
func (*RestoreConfig_ClusterResourceRestoreScope) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 1}
}

func (x *RestoreConfig_ClusterResourceRestoreScope) GetSelectedGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.SelectedGroupKinds
	}
	return nil
}

func (x *RestoreConfig_ClusterResourceRestoreScope) GetExcludedGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.ExcludedGroupKinds
	}
	return nil
}

func (x *RestoreConfig_ClusterResourceRestoreScope) GetAllGroupKinds() bool {
	if x != nil {
		return x.AllGroupKinds
	}
	return false
}

func (x *RestoreConfig_ClusterResourceRestoreScope) GetNoGroupKinds() bool {
	if x != nil {
		return x.NoGroupKinds
	}
	return false
}

// A transformation rule to be applied against Kubernetes resources as they
// are selected for restoration from a Backup. A rule contains both filtering
// logic (which resources are subject to substitution) and substitution logic.
type RestoreConfig_SubstitutionRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. (Filtering parameter) Any resource subject to substitution must
	// be contained within one of the listed Kubernetes Namespace in the Backup.
	// If this field is not provided, no namespace filtering will be performed
	// (all resources in all Namespaces, including all cluster-scoped resources,
	// will be candidates for substitution).
	// To mix cluster-scoped and namespaced resources in the same rule, use an
	// empty string ("") as one of the target namespaces.
	TargetNamespaces []string `protobuf:"bytes,1,rep,name=target_namespaces,json=targetNamespaces,proto3" json:"target_namespaces,omitempty"`
	// Optional. (Filtering parameter) Any resource subject to substitution must
	// belong to one of the listed "types". If this field is not provided, no
	// type filtering will be performed (all resources of all types matching
	// previous filtering parameters will be candidates for substitution).
	TargetGroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,2,rep,name=target_group_kinds,json=targetGroupKinds,proto3" json:"target_group_kinds,omitempty"`
	// Required. This is a [JSONPath]
	// (https://kubernetes.io/docs/reference/kubectl/jsonpath/)
	// expression that matches specific fields of candidate
	// resources and it operates as both a filtering parameter (resources that
	// are not matched with this expression will not be candidates for
	// substitution) as well as a field identifier (identifies exactly which
	// fields out of the candidate resources will be modified).
	TargetJsonPath string `protobuf:"bytes,3,opt,name=target_json_path,json=targetJsonPath,proto3" json:"target_json_path,omitempty"`
	// Optional. (Filtering parameter) This is a [regular expression]
	// (https://en.wikipedia.org/wiki/Regular_expression)
	// that is compared against the fields matched by the target_json_path
	// expression (and must also have passed the previous filters).
	// Substitution will not be performed against fields whose
	// value does not match this expression. If this field is NOT specified,
	// then ALL fields matched by the target_json_path expression will undergo
	// substitution. Note that an empty (e.g., "", rather than unspecified)
	// value for this field will only match empty fields.
	OriginalValuePattern string `protobuf:"bytes,4,opt,name=original_value_pattern,json=originalValuePattern,proto3" json:"original_value_pattern,omitempty"`
	// Optional. This is the new value to set for any fields that pass the
	// filtering and selection criteria. To remove a value from a Kubernetes
	// resource, either leave this field unspecified, or set it to the empty
	// string ("").
	NewValue string `protobuf:"bytes,5,opt,name=new_value,json=newValue,proto3" json:"new_value,omitempty"`
}

func (x *RestoreConfig_SubstitutionRule) Reset() {
	*x = RestoreConfig_SubstitutionRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_SubstitutionRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_SubstitutionRule) ProtoMessage() {}

func (x *RestoreConfig_SubstitutionRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_SubstitutionRule.ProtoReflect.Descriptor instead.
func (*RestoreConfig_SubstitutionRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 2}
}

func (x *RestoreConfig_SubstitutionRule) GetTargetNamespaces() []string {
	if x != nil {
		return x.TargetNamespaces
	}
	return nil
}

func (x *RestoreConfig_SubstitutionRule) GetTargetGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.TargetGroupKinds
	}
	return nil
}

func (x *RestoreConfig_SubstitutionRule) GetTargetJsonPath() string {
	if x != nil {
		return x.TargetJsonPath
	}
	return ""
}

func (x *RestoreConfig_SubstitutionRule) GetOriginalValuePattern() string {
	if x != nil {
		return x.OriginalValuePattern
	}
	return ""
}

func (x *RestoreConfig_SubstitutionRule) GetNewValue() string {
	if x != nil {
		return x.NewValue
	}
	return ""
}

// TransformationRuleAction defines a TransformationRule action based on the
// JSON Patch RFC (https://www.rfc-editor.org/rfc/rfc6902)
type RestoreConfig_TransformationRuleAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. op specifies the operation to perform.
	Op RestoreConfig_TransformationRuleAction_Op `protobuf:"varint,1,opt,name=op,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_TransformationRuleAction_Op" json:"op,omitempty"`
	// Optional. A string containing a JSON Pointer value that references the
	// location in the target document to move the value from.
	FromPath string `protobuf:"bytes,2,opt,name=from_path,json=fromPath,proto3" json:"from_path,omitempty"`
	// Optional. A string containing a JSON-Pointer value that references a
	// location within the target document where the operation is performed.
	Path string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
	// Optional. A string that specifies the desired value in string format to
	// use for transformation.
	Value string `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *RestoreConfig_TransformationRuleAction) Reset() {
	*x = RestoreConfig_TransformationRuleAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_TransformationRuleAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_TransformationRuleAction) ProtoMessage() {}

func (x *RestoreConfig_TransformationRuleAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_TransformationRuleAction.ProtoReflect.Descriptor instead.
func (*RestoreConfig_TransformationRuleAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 3}
}

func (x *RestoreConfig_TransformationRuleAction) GetOp() RestoreConfig_TransformationRuleAction_Op {
	if x != nil {
		return x.Op
	}
	return RestoreConfig_TransformationRuleAction_OP_UNSPECIFIED
}

func (x *RestoreConfig_TransformationRuleAction) GetFromPath() string {
	if x != nil {
		return x.FromPath
	}
	return ""
}

func (x *RestoreConfig_TransformationRuleAction) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *RestoreConfig_TransformationRuleAction) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// ResourceFilter specifies matching criteria to limit the scope of a
// change to a specific set of kubernetes resources that are selected for
// restoration from a backup.
type RestoreConfig_ResourceFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. (Filtering parameter) Any resource subject to transformation
	// must be contained within one of the listed Kubernetes Namespace in the
	// Backup. If this field is not provided, no namespace filtering will be
	// performed (all resources in all Namespaces, including all cluster-scoped
	// resources, will be candidates for transformation).
	Namespaces []string `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	// Optional. (Filtering parameter) Any resource subject to transformation
	// must belong to one of the listed "types". If this field is not provided,
	// no type filtering will be performed (all resources of all types matching
	// previous filtering parameters will be candidates for transformation).
	GroupKinds []*RestoreConfig_GroupKind `protobuf:"bytes,2,rep,name=group_kinds,json=groupKinds,proto3" json:"group_kinds,omitempty"`
	// Optional. This is a [JSONPath]
	// (https://github.com/json-path/JsonPath/blob/master/README.md)
	// expression that matches specific fields of candidate
	// resources and it operates as a filtering parameter (resources that
	// are not matched with this expression will not be candidates for
	// transformation).
	JsonPath string `protobuf:"bytes,3,opt,name=json_path,json=jsonPath,proto3" json:"json_path,omitempty"`
}

func (x *RestoreConfig_ResourceFilter) Reset() {
	*x = RestoreConfig_ResourceFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_ResourceFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_ResourceFilter) ProtoMessage() {}

func (x *RestoreConfig_ResourceFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_ResourceFilter.ProtoReflect.Descriptor instead.
func (*RestoreConfig_ResourceFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 4}
}

func (x *RestoreConfig_ResourceFilter) GetNamespaces() []string {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

func (x *RestoreConfig_ResourceFilter) GetGroupKinds() []*RestoreConfig_GroupKind {
	if x != nil {
		return x.GroupKinds
	}
	return nil
}

func (x *RestoreConfig_ResourceFilter) GetJsonPath() string {
	if x != nil {
		return x.JsonPath
	}
	return ""
}

// A transformation rule to be applied against Kubernetes resources as they
// are selected for restoration from a Backup. A rule contains both filtering
// logic (which resources are subject to transform) and transformation logic.
type RestoreConfig_TransformationRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A list of transformation rule actions to take against candidate
	// resources. Actions are executed in order defined - this order matters, as
	// they could potentially interfere with each other and the first operation
	// could affect the outcome of the second operation.
	FieldActions []*RestoreConfig_TransformationRuleAction `protobuf:"bytes,1,rep,name=field_actions,json=fieldActions,proto3" json:"field_actions,omitempty"`
	// Optional. This field is used to specify a set of fields that should be
	// used to determine which resources in backup should be acted upon by the
	// supplied transformation rule actions, and this will ensure that only
	// specific resources are affected by transformation rule actions.
	ResourceFilter *RestoreConfig_ResourceFilter `protobuf:"bytes,2,opt,name=resource_filter,json=resourceFilter,proto3" json:"resource_filter,omitempty"`
	// Optional. The description is a user specified string description of the
	// transformation rule.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *RestoreConfig_TransformationRule) Reset() {
	*x = RestoreConfig_TransformationRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_TransformationRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_TransformationRule) ProtoMessage() {}

func (x *RestoreConfig_TransformationRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_TransformationRule.ProtoReflect.Descriptor instead.
func (*RestoreConfig_TransformationRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 5}
}

func (x *RestoreConfig_TransformationRule) GetFieldActions() []*RestoreConfig_TransformationRuleAction {
	if x != nil {
		return x.FieldActions
	}
	return nil
}

func (x *RestoreConfig_TransformationRule) GetResourceFilter() *RestoreConfig_ResourceFilter {
	if x != nil {
		return x.ResourceFilter
	}
	return nil
}

func (x *RestoreConfig_TransformationRule) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// Binds resources in the scope to the given VolumeDataRestorePolicy.
type RestoreConfig_VolumeDataRestorePolicyBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The VolumeDataRestorePolicy to apply when restoring volumes in
	// scope.
	Policy RestoreConfig_VolumeDataRestorePolicy `protobuf:"varint,1,opt,name=policy,proto3,enum=google.cloud.gkebackup.v1.RestoreConfig_VolumeDataRestorePolicy" json:"policy,omitempty"`
	// Types that are assignable to Scope:
	//
	//	*RestoreConfig_VolumeDataRestorePolicyBinding_VolumeType
	Scope isRestoreConfig_VolumeDataRestorePolicyBinding_Scope `protobuf_oneof:"scope"`
}

func (x *RestoreConfig_VolumeDataRestorePolicyBinding) Reset() {
	*x = RestoreConfig_VolumeDataRestorePolicyBinding{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_VolumeDataRestorePolicyBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_VolumeDataRestorePolicyBinding) ProtoMessage() {}

func (x *RestoreConfig_VolumeDataRestorePolicyBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_VolumeDataRestorePolicyBinding.ProtoReflect.Descriptor instead.
func (*RestoreConfig_VolumeDataRestorePolicyBinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 6}
}

func (x *RestoreConfig_VolumeDataRestorePolicyBinding) GetPolicy() RestoreConfig_VolumeDataRestorePolicy {
	if x != nil {
		return x.Policy
	}
	return RestoreConfig_VOLUME_DATA_RESTORE_POLICY_UNSPECIFIED
}

func (m *RestoreConfig_VolumeDataRestorePolicyBinding) GetScope() isRestoreConfig_VolumeDataRestorePolicyBinding_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (x *RestoreConfig_VolumeDataRestorePolicyBinding) GetVolumeType() VolumeTypeEnum_VolumeType {
	if x, ok := x.GetScope().(*RestoreConfig_VolumeDataRestorePolicyBinding_VolumeType); ok {
		return x.VolumeType
	}
	return VolumeTypeEnum_VOLUME_TYPE_UNSPECIFIED
}

type isRestoreConfig_VolumeDataRestorePolicyBinding_Scope interface {
	isRestoreConfig_VolumeDataRestorePolicyBinding_Scope()
}

type RestoreConfig_VolumeDataRestorePolicyBinding_VolumeType struct {
	// The volume type, as determined by the PVC's bound PV,
	// to apply the policy to.
	VolumeType VolumeTypeEnum_VolumeType `protobuf:"varint,2,opt,name=volume_type,json=volumeType,proto3,enum=google.cloud.gkebackup.v1.VolumeTypeEnum_VolumeType,oneof"`
}

func (*RestoreConfig_VolumeDataRestorePolicyBinding_VolumeType) isRestoreConfig_VolumeDataRestorePolicyBinding_Scope() {
}

// Allows customers to specify dependencies between resources
// that Backup for GKE can use to compute a resasonable restore order.
type RestoreConfig_RestoreOrder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Contains a list of group kind dependency pairs provided
	// by the customer, that is used by Backup for GKE to
	// generate a group kind restore order.
	GroupKindDependencies []*RestoreConfig_RestoreOrder_GroupKindDependency `protobuf:"bytes,1,rep,name=group_kind_dependencies,json=groupKindDependencies,proto3" json:"group_kind_dependencies,omitempty"`
}

func (x *RestoreConfig_RestoreOrder) Reset() {
	*x = RestoreConfig_RestoreOrder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_RestoreOrder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_RestoreOrder) ProtoMessage() {}

func (x *RestoreConfig_RestoreOrder) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_RestoreOrder.ProtoReflect.Descriptor instead.
func (*RestoreConfig_RestoreOrder) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 7}
}

func (x *RestoreConfig_RestoreOrder) GetGroupKindDependencies() []*RestoreConfig_RestoreOrder_GroupKindDependency {
	if x != nil {
		return x.GroupKindDependencies
	}
	return nil
}

// Defines a dependency between two group kinds.
type RestoreConfig_RestoreOrder_GroupKindDependency struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The satisfying group kind must be restored first
	// in order to satisfy the dependency.
	Satisfying *RestoreConfig_GroupKind `protobuf:"bytes,1,opt,name=satisfying,proto3" json:"satisfying,omitempty"`
	// Required. The requiring group kind requires that the other
	// group kind be restored first.
	Requiring *RestoreConfig_GroupKind `protobuf:"bytes,2,opt,name=requiring,proto3" json:"requiring,omitempty"`
}

func (x *RestoreConfig_RestoreOrder_GroupKindDependency) Reset() {
	*x = RestoreConfig_RestoreOrder_GroupKindDependency{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreConfig_RestoreOrder_GroupKindDependency) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreConfig_RestoreOrder_GroupKindDependency) ProtoMessage() {}

func (x *RestoreConfig_RestoreOrder_GroupKindDependency) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_gkebackup_v1_restore_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreConfig_RestoreOrder_GroupKindDependency.ProtoReflect.Descriptor instead.
func (*RestoreConfig_RestoreOrder_GroupKindDependency) Descriptor() ([]byte, []int) {
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP(), []int{1, 7, 0}
}

func (x *RestoreConfig_RestoreOrder_GroupKindDependency) GetSatisfying() *RestoreConfig_GroupKind {
	if x != nil {
		return x.Satisfying
	}
	return nil
}

func (x *RestoreConfig_RestoreOrder_GroupKindDependency) GetRequiring() *RestoreConfig_GroupKind {
	if x != nil {
		return x.Requiring
	}
	return nil
}

var File_google_cloud_gkebackup_v1_restore_proto protoreflect.FileDescriptor

var file_google_cloud_gkebackup_v1_restore_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x90, 0x0d, 0x0a, 0x07, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15,
	0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x03, 0x75, 0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x06, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x05,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x42, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x28, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
	0x6e, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x12, 0x54, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x46, 0x0a, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x44,
	0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x0d, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x5f, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x45, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x39, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a,
	0x16, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x14, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61,
	0x67, 0x12, 0x49, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0xe0, 0x41,
	0x05, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x92, 0x01, 0x0a,
	0x24, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x6f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x18, 0x13, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f,
	0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52,
	0x20, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x1a, 0xc6, 0x01, 0x0a, 0x06, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5d, 0x0a, 0x11,
	0x69, 0x6e, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x6e, 0x63, 0x6c, 0x75,
	0x73, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x5d, 0x0a, 0x11, 0x65,
	0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x66, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x47, 0x52, 0x45,
	0x53, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x3a, 0x7d, 0xea,
	0x41, 0x7a, 0x0a, 0x20, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x12, 0x56, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6c, 0x61, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6c, 0x61, 0x6e, 0x7d, 0x2f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x7d, 0x22, 0xfb, 0x1f, 0x0a,
	0x0d, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x82,
	0x01, 0x0a, 0x1a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17, 0x76, 0x6f, 0x6c, 0x75,
	0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x94, 0x01, 0x0a, 0x20, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63,
	0x74, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x63, 0x6c, 0x75,
	0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x6c, 0x69, 0x63, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x94, 0x01, 0x0a, 0x20, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x1d, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x8e, 0x01, 0x0a, 0x1e, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x63, 0x6f,
	0x70, 0x65, 0x12, 0x27, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x0d, 0x61, 0x6c,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x13, 0x73,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x48,
	0x00, 0x52, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x61, 0x0a, 0x15, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x48, 0x00, 0x52, 0x14, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x25, 0x0a, 0x0d, 0x6e, 0x6f, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48,
	0x00, 0x52, 0x0c, 0x6e, 0x6f, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12,
	0x58, 0x0a, 0x13, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x4e,
	0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x6d, 0x0a, 0x12, 0x73, 0x75, 0x62,
	0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x73, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x73, 0x12, 0x9a, 0x01,
	0x0a, 0x23, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1f, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5f, 0x0a, 0x0d, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x72,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x1a, 0x61, 0x0a, 0x09, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x1a, 0xcb,
	0x02, 0x0a, 0x1b, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x63, 0x6f, 0x70, 0x65, 0x12, 0x69,
	0x0a, 0x14, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x73, 0x12, 0x69, 0x0a, 0x14, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x12, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b,
	0x69, 0x6e, 0x64, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x61, 0x6c, 0x6c, 0x5f, 0x67, 0x72, 0x6f, 0x75,
	0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0d, 0x61, 0x6c, 0x6c, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64,
	0x73, 0x12, 0x29, 0x0a, 0x0e, 0x6e, 0x6f, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69,
	0x6e, 0x64, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x6e, 0x6f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x73, 0x1a, 0xb7, 0x02, 0x0a,
	0x10, 0x53, 0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c,
	0x65, 0x12, 0x30, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x73, 0x12, 0x65, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b,
	0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x4a, 0x73, 0x6f, 0x6e, 0x50, 0x61, 0x74, 0x68, 0x12, 0x39, 0x0a, 0x16, 0x6f, 0x72, 0x69,
	0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x70, 0x61, 0x74, 0x74,
	0x65, 0x72, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x50, 0x61, 0x74,
	0x74, 0x65, 0x72, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x6e, 0x65, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6e, 0x65,
	0x77, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0xa5, 0x02, 0x0a, 0x18, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x02, 0x6f, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x6f, 0x70, 0x12, 0x20,
	0x0a, 0x09, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x66, 0x72, 0x6f, 0x6d, 0x50, 0x61, 0x74, 0x68,
	0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x58, 0x0a, 0x02, 0x4f, 0x70, 0x12, 0x12, 0x0a, 0x0e, 0x4f, 0x50,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a,
	0x0a, 0x06, 0x52, 0x45, 0x4d, 0x4f, 0x56, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x4d, 0x4f,
	0x56, 0x45, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x43, 0x4f, 0x50, 0x59, 0x10, 0x03, 0x12, 0x07,
	0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x04, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x53, 0x54, 0x10,
	0x05, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x06, 0x1a, 0xb1,
	0x01, 0x0a, 0x0e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x23, 0x0a, 0x0a, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x12, 0x58, 0x0a, 0x0b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f,
	0x6b, 0x69, 0x6e, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x73,
	0x12, 0x20, 0x0a, 0x09, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6a, 0x73, 0x6f, 0x6e, 0x50, 0x61,
	0x74, 0x68, 0x1a, 0x8f, 0x02, 0x0a, 0x12, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x6b, 0x0a, 0x0d, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x75, 0x6c, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x41,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67,
	0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xe1, 0x01, 0x0a, 0x1e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x5d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x57, 0x0a, 0x0b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x48, 0x00, 0x52, 0x0a, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x07, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x1a, 0xdf, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x12, 0x86, 0x01, 0x0a, 0x17, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
	0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4f, 0x72, 0x64,
	0x65, 0x72, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69,
	0x65, 0x73, 0x1a, 0xc5, 0x01, 0x0a, 0x13, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x79, 0x12, 0x57, 0x0a, 0x0a, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69,
	0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x79,
	0x69, 0x6e, 0x67, 0x12, 0x55, 0x0a, 0x09, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x69, 0x6e, 0x67,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x22, 0xaf, 0x01, 0x0a, 0x17, 0x56,
	0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x2a, 0x0a, 0x26, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45,
	0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x50, 0x4f,
	0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x5f, 0x56, 0x4f,
	0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x52, 0x4f, 0x4d, 0x5f, 0x42,
	0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x52, 0x45, 0x55, 0x53, 0x45,
	0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x48, 0x41, 0x4e, 0x44, 0x4c, 0x45, 0x5f, 0x46,
	0x52, 0x4f, 0x4d, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x10, 0x02, 0x12, 0x1e, 0x0a, 0x1a,
	0x4e, 0x4f, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x52,
	0x45, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x22, 0x83, 0x01, 0x0a,
	0x1d, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x30,
	0x0a, 0x2c, 0x43, 0x4c, 0x55, 0x53, 0x54, 0x45, 0x52, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x5f, 0x50, 0x4f, 0x4c, 0x49,
	0x43, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x55, 0x53, 0x45, 0x5f, 0x45, 0x58, 0x49, 0x53, 0x54, 0x49, 0x4e, 0x47,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x55, 0x53,
	0x45, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x55, 0x50, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x10, 0x02, 0x22, 0xe0, 0x01, 0x0a, 0x1d, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65,
	0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x4d, 0x6f, 0x64, 0x65, 0x12, 0x30, 0x0a, 0x2c, 0x4e, 0x41, 0x4d, 0x45, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x53, 0x54,
	0x4f, 0x52, 0x45, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45,
	0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10, 0x01, 0x12, 0x14,
	0x0a, 0x10, 0x46, 0x41, 0x49, 0x4c, 0x5f, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49,
	0x43, 0x54, 0x10, 0x02, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x53, 0x4b,
	0x49, 0x50, 0x5f, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c, 0x49, 0x43, 0x54, 0x10, 0x03,
	0x12, 0x24, 0x0a, 0x20, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43,
	0x45, 0x5f, 0x56, 0x4f, 0x4c, 0x55, 0x4d, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46,
	0x4c, 0x49, 0x43, 0x54, 0x10, 0x04, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f,
	0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x5f, 0x4f, 0x4e, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x4c,
	0x49, 0x43, 0x54, 0x10, 0x05, 0x42, 0x23, 0x0a, 0x21, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x22, 0xb7, 0x02, 0x0a, 0x10, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x56, 0x0a, 0x0a, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x21, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xdc, 0x01, 0x0a, 0x1f, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44,
	0x61, 0x74, 0x61, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x5d, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x56, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x44, 0x61, 0x74, 0x61, 0x52, 0x65, 0x73,
	0x74, 0x6f, 0x72, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x51, 0x0a, 0x0d, 0x73, 0x65, 0x6c, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x5f, 0x70, 0x76, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b,
	0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x73,
	0x70, 0x61, 0x63, 0x65, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x65,
	0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x50, 0x76, 0x63, 0x73, 0x42, 0x07, 0x0a, 0x05, 0x73, 0x63,
	0x6f, 0x70, 0x65, 0x42, 0xc3, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x67, 0x6b, 0x65, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x70, 0x62, 0x3b, 0x67, 0x6b, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x47, 0x6b, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02,
	0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x47, 0x6b,
	0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1c, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x47, 0x6b, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_gkebackup_v1_restore_proto_rawDescOnce sync.Once
	file_google_cloud_gkebackup_v1_restore_proto_rawDescData = file_google_cloud_gkebackup_v1_restore_proto_rawDesc
)

func file_google_cloud_gkebackup_v1_restore_proto_rawDescGZIP() []byte {
	file_google_cloud_gkebackup_v1_restore_proto_rawDescOnce.Do(func() {
		file_google_cloud_gkebackup_v1_restore_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_gkebackup_v1_restore_proto_rawDescData)
	})
	return file_google_cloud_gkebackup_v1_restore_proto_rawDescData
}

var file_google_cloud_gkebackup_v1_restore_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_gkebackup_v1_restore_proto_msgTypes = make([]protoimpl.MessageInfo, 16)
var file_google_cloud_gkebackup_v1_restore_proto_goTypes = []any{
	(Restore_State)(0),                               // 0: google.cloud.gkebackup.v1.Restore.State
	(RestoreConfig_VolumeDataRestorePolicy)(0),       // 1: google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	(RestoreConfig_ClusterResourceConflictPolicy)(0), // 2: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
	(RestoreConfig_NamespacedResourceRestoreMode)(0), // 3: google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
	(RestoreConfig_TransformationRuleAction_Op)(0),   // 4: google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op
	(*Restore)(nil),                         // 5: google.cloud.gkebackup.v1.Restore
	(*RestoreConfig)(nil),                   // 6: google.cloud.gkebackup.v1.RestoreConfig
	(*ResourceSelector)(nil),                // 7: google.cloud.gkebackup.v1.ResourceSelector
	(*VolumeDataRestorePolicyOverride)(nil), // 8: google.cloud.gkebackup.v1.VolumeDataRestorePolicyOverride
	(*Restore_Filter)(nil),                  // 9: google.cloud.gkebackup.v1.Restore.Filter
	nil,                                     // 10: google.cloud.gkebackup.v1.Restore.LabelsEntry
	(*RestoreConfig_GroupKind)(nil),         // 11: google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	(*RestoreConfig_ClusterResourceRestoreScope)(nil),      // 12: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
	(*RestoreConfig_SubstitutionRule)(nil),                 // 13: google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
	(*RestoreConfig_TransformationRuleAction)(nil),         // 14: google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
	(*RestoreConfig_ResourceFilter)(nil),                   // 15: google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter
	(*RestoreConfig_TransformationRule)(nil),               // 16: google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
	(*RestoreConfig_VolumeDataRestorePolicyBinding)(nil),   // 17: google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicyBinding
	(*RestoreConfig_RestoreOrder)(nil),                     // 18: google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder
	(*RestoreConfig_RestoreOrder_GroupKindDependency)(nil), // 19: google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder.GroupKindDependency
	nil,                            // 20: google.cloud.gkebackup.v1.ResourceSelector.LabelsEntry
	(*timestamppb.Timestamp)(nil),  // 21: google.protobuf.Timestamp
	(*Namespaces)(nil),             // 22: google.cloud.gkebackup.v1.Namespaces
	(*NamespacedNames)(nil),        // 23: google.cloud.gkebackup.v1.NamespacedNames
	(VolumeTypeEnum_VolumeType)(0), // 24: google.cloud.gkebackup.v1.VolumeTypeEnum.VolumeType
}
var file_google_cloud_gkebackup_v1_restore_proto_depIdxs = []int32{
	21, // 0: google.cloud.gkebackup.v1.Restore.create_time:type_name -> google.protobuf.Timestamp
	21, // 1: google.cloud.gkebackup.v1.Restore.update_time:type_name -> google.protobuf.Timestamp
	6,  // 2: google.cloud.gkebackup.v1.Restore.restore_config:type_name -> google.cloud.gkebackup.v1.RestoreConfig
	10, // 3: google.cloud.gkebackup.v1.Restore.labels:type_name -> google.cloud.gkebackup.v1.Restore.LabelsEntry
	0,  // 4: google.cloud.gkebackup.v1.Restore.state:type_name -> google.cloud.gkebackup.v1.Restore.State
	21, // 5: google.cloud.gkebackup.v1.Restore.complete_time:type_name -> google.protobuf.Timestamp
	9,  // 6: google.cloud.gkebackup.v1.Restore.filter:type_name -> google.cloud.gkebackup.v1.Restore.Filter
	8,  // 7: google.cloud.gkebackup.v1.Restore.volume_data_restore_policy_overrides:type_name -> google.cloud.gkebackup.v1.VolumeDataRestorePolicyOverride
	1,  // 8: google.cloud.gkebackup.v1.RestoreConfig.volume_data_restore_policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	2,  // 9: google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_conflict_policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceConflictPolicy
	3,  // 10: google.cloud.gkebackup.v1.RestoreConfig.namespaced_resource_restore_mode:type_name -> google.cloud.gkebackup.v1.RestoreConfig.NamespacedResourceRestoreMode
	12, // 11: google.cloud.gkebackup.v1.RestoreConfig.cluster_resource_restore_scope:type_name -> google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope
	22, // 12: google.cloud.gkebackup.v1.RestoreConfig.selected_namespaces:type_name -> google.cloud.gkebackup.v1.Namespaces
	23, // 13: google.cloud.gkebackup.v1.RestoreConfig.selected_applications:type_name -> google.cloud.gkebackup.v1.NamespacedNames
	22, // 14: google.cloud.gkebackup.v1.RestoreConfig.excluded_namespaces:type_name -> google.cloud.gkebackup.v1.Namespaces
	13, // 15: google.cloud.gkebackup.v1.RestoreConfig.substitution_rules:type_name -> google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule
	16, // 16: google.cloud.gkebackup.v1.RestoreConfig.transformation_rules:type_name -> google.cloud.gkebackup.v1.RestoreConfig.TransformationRule
	17, // 17: google.cloud.gkebackup.v1.RestoreConfig.volume_data_restore_policy_bindings:type_name -> google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicyBinding
	18, // 18: google.cloud.gkebackup.v1.RestoreConfig.restore_order:type_name -> google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder
	11, // 19: google.cloud.gkebackup.v1.ResourceSelector.group_kind:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	20, // 20: google.cloud.gkebackup.v1.ResourceSelector.labels:type_name -> google.cloud.gkebackup.v1.ResourceSelector.LabelsEntry
	1,  // 21: google.cloud.gkebackup.v1.VolumeDataRestorePolicyOverride.policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	23, // 22: google.cloud.gkebackup.v1.VolumeDataRestorePolicyOverride.selected_pvcs:type_name -> google.cloud.gkebackup.v1.NamespacedNames
	7,  // 23: google.cloud.gkebackup.v1.Restore.Filter.inclusion_filters:type_name -> google.cloud.gkebackup.v1.ResourceSelector
	7,  // 24: google.cloud.gkebackup.v1.Restore.Filter.exclusion_filters:type_name -> google.cloud.gkebackup.v1.ResourceSelector
	11, // 25: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.selected_group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	11, // 26: google.cloud.gkebackup.v1.RestoreConfig.ClusterResourceRestoreScope.excluded_group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	11, // 27: google.cloud.gkebackup.v1.RestoreConfig.SubstitutionRule.target_group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	4,  // 28: google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.op:type_name -> google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction.Op
	11, // 29: google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter.group_kinds:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	14, // 30: google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.field_actions:type_name -> google.cloud.gkebackup.v1.RestoreConfig.TransformationRuleAction
	15, // 31: google.cloud.gkebackup.v1.RestoreConfig.TransformationRule.resource_filter:type_name -> google.cloud.gkebackup.v1.RestoreConfig.ResourceFilter
	1,  // 32: google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicyBinding.policy:type_name -> google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicy
	24, // 33: google.cloud.gkebackup.v1.RestoreConfig.VolumeDataRestorePolicyBinding.volume_type:type_name -> google.cloud.gkebackup.v1.VolumeTypeEnum.VolumeType
	19, // 34: google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder.group_kind_dependencies:type_name -> google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder.GroupKindDependency
	11, // 35: google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder.GroupKindDependency.satisfying:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	11, // 36: google.cloud.gkebackup.v1.RestoreConfig.RestoreOrder.GroupKindDependency.requiring:type_name -> google.cloud.gkebackup.v1.RestoreConfig.GroupKind
	37, // [37:37] is the sub-list for method output_type
	37, // [37:37] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_google_cloud_gkebackup_v1_restore_proto_init() }
func file_google_cloud_gkebackup_v1_restore_proto_init() {
	if File_google_cloud_gkebackup_v1_restore_proto != nil {
		return
	}
	file_google_cloud_gkebackup_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Restore); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*VolumeDataRestorePolicyOverride); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Restore_Filter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_GroupKind); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_ClusterResourceRestoreScope); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_SubstitutionRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_TransformationRuleAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_ResourceFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_TransformationRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[12].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_VolumeDataRestorePolicyBinding); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[13].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_RestoreOrder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_gkebackup_v1_restore_proto_msgTypes[14].Exporter = func(v any, i int) any {
			switch v := v.(*RestoreConfig_RestoreOrder_GroupKindDependency); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_gkebackup_v1_restore_proto_msgTypes[1].OneofWrappers = []any{
		(*RestoreConfig_AllNamespaces)(nil),
		(*RestoreConfig_SelectedNamespaces)(nil),
		(*RestoreConfig_SelectedApplications)(nil),
		(*RestoreConfig_NoNamespaces)(nil),
		(*RestoreConfig_ExcludedNamespaces)(nil),
	}
	file_google_cloud_gkebackup_v1_restore_proto_msgTypes[3].OneofWrappers = []any{
		(*VolumeDataRestorePolicyOverride_SelectedPvcs)(nil),
	}
	file_google_cloud_gkebackup_v1_restore_proto_msgTypes[12].OneofWrappers = []any{
		(*RestoreConfig_VolumeDataRestorePolicyBinding_VolumeType)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_gkebackup_v1_restore_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   16,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_gkebackup_v1_restore_proto_goTypes,
		DependencyIndexes: file_google_cloud_gkebackup_v1_restore_proto_depIdxs,
		EnumInfos:         file_google_cloud_gkebackup_v1_restore_proto_enumTypes,
		MessageInfos:      file_google_cloud_gkebackup_v1_restore_proto_msgTypes,
	}.Build()
	File_google_cloud_gkebackup_v1_restore_proto = out.File
	file_google_cloud_gkebackup_v1_restore_proto_rawDesc = nil
	file_google_cloud_gkebackup_v1_restore_proto_goTypes = nil
	file_google_cloud_gkebackup_v1_restore_proto_depIdxs = nil
}
