// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package osconfig_test

import (
	"context"

	osconfig "cloud.google.com/go/osconfig/apiv1"
	osconfigpb "cloud.google.com/go/osconfig/apiv1/osconfigpb"
	"google.golang.org/api/iterator"
)

func ExampleNewOsConfigZonalClient() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleNewOsConfigZonalRESTClient() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalRESTClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	// TODO: Use client.
	_ = c
}

func ExampleOsConfigZonalClient_CreateOSPolicyAssignment() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.CreateOSPolicyAssignmentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#CreateOSPolicyAssignmentRequest.
	}
	op, err := c.CreateOSPolicyAssignment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_UpdateOSPolicyAssignment() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.UpdateOSPolicyAssignmentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#UpdateOSPolicyAssignmentRequest.
	}
	op, err := c.UpdateOSPolicyAssignment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	resp, err := op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_GetOSPolicyAssignment() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetOSPolicyAssignmentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#GetOSPolicyAssignmentRequest.
	}
	resp, err := c.GetOSPolicyAssignment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListOSPolicyAssignments() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListOSPolicyAssignmentsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#ListOSPolicyAssignmentsRequest.
	}
	it := c.ListOSPolicyAssignments(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleOsConfigZonalClient_ListOSPolicyAssignmentRevisions() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListOSPolicyAssignmentRevisionsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#ListOSPolicyAssignmentRevisionsRequest.
	}
	it := c.ListOSPolicyAssignmentRevisions(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleOsConfigZonalClient_DeleteOSPolicyAssignment() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.DeleteOSPolicyAssignmentRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#DeleteOSPolicyAssignmentRequest.
	}
	op, err := c.DeleteOSPolicyAssignment(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}

	err = op.Wait(ctx)
	if err != nil {
		// TODO: Handle error.
	}
}

func ExampleOsConfigZonalClient_GetOSPolicyAssignmentReport() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetOSPolicyAssignmentReportRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#GetOSPolicyAssignmentReportRequest.
	}
	resp, err := c.GetOSPolicyAssignmentReport(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListOSPolicyAssignmentReports() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListOSPolicyAssignmentReportsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#ListOSPolicyAssignmentReportsRequest.
	}
	it := c.ListOSPolicyAssignmentReports(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleOsConfigZonalClient_GetInventory() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetInventoryRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#GetInventoryRequest.
	}
	resp, err := c.GetInventory(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListInventories() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListInventoriesRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#ListInventoriesRequest.
	}
	it := c.ListInventories(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}

func ExampleOsConfigZonalClient_GetVulnerabilityReport() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.GetVulnerabilityReportRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#GetVulnerabilityReportRequest.
	}
	resp, err := c.GetVulnerabilityReport(ctx, req)
	if err != nil {
		// TODO: Handle error.
	}
	// TODO: Use resp.
	_ = resp
}

func ExampleOsConfigZonalClient_ListVulnerabilityReports() {
	ctx := context.Background()
	// This snippet has been automatically generated and should be regarded as a code template only.
	// It will require modifications to work:
	// - It may require correct/in-range values for request initialization.
	// - It may require specifying regional endpoints when creating the service client as shown in:
	//   https://pkg.go.dev/cloud.google.com/go#hdr-Client_Options
	c, err := osconfig.NewOsConfigZonalClient(ctx)
	if err != nil {
		// TODO: Handle error.
	}
	defer c.Close()

	req := &osconfigpb.ListVulnerabilityReportsRequest{
		// TODO: Fill request struct fields.
		// See https://pkg.go.dev/cloud.google.com/go/osconfig/apiv1/osconfigpb#ListVulnerabilityReportsRequest.
	}
	it := c.ListVulnerabilityReports(ctx, req)
	for {
		resp, err := it.Next()
		if err == iterator.Done {
			break
		}
		if err != nil {
			// TODO: Handle error.
		}
		// TODO: Use resp.
		_ = resp
	}
}
