#!/bin/sh

# Setup env
set -xe
. /environ

# Clone git repository at branch / tag / commit.
REPO='https://chromium.googlesource.com/webm/libwebp'; TAG='v1.5.0'
git clone "$REPO" --depth=1 --branch="${TAG}" /webp
cd /webp

# Configure build.
cmake -B build \
      -D CMAKE_INSTALL_PREFIX=/vendor \
      -D BUILD_SHARED_LIBS=OFF \
      -D WEBP_LINK_STATIC=ON \
      -D WEBP_ENABLE_SIMD=ON \
      -D WEBP_BUILD_ANIM_UTILS=OFF \
      -D WEBP_BUILD_CWEBP=OFF \
      -D WEBP_BUILD_DWEBP=OFF \
      -D WEBP_BUILD_GIF2WEBP=OFF \
      -D WEBP_BUILD_IMG2WEBP=OFF \
      -D WEBP_BUILD_VWEBP=OFF \
      -D WEBP_BUILD_WEBPINFO=OFF \
      -D WEBP_BUILD_WEBPMUX=OFF \
      -D WEBP_BUILD_EXTRAS=OFF \
      -D WEBP_USE_THREAD=OFF
cd build

# Perform build + install.
make -j $(nproc) install

# Combine the 2 webp library parts.
merge_archives /vendor/lib/libwebp.a \
               /vendor/lib/libwebp.a \
               /vendor/lib/libsharpyuv.a
