// Code generated by go-swagger; DO NOT EDIT.

package tasks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/go-swagger/go-swagger/examples/task-tracker/models"
)

// GetTaskCommentsReader is a Reader for the GetTaskComments structure.
type GetTaskCommentsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetTaskCommentsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetTaskCommentsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetTaskCommentsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetTaskCommentsOK creates a GetTaskCommentsOK with default headers values
func NewGetTaskCommentsOK() *GetTaskCommentsOK {
	return &GetTaskCommentsOK{}
}

/*
GetTaskCommentsOK describes a response with status code 200, with default header values.

The list of comments
*/
type GetTaskCommentsOK struct {
	Payload []*models.Comment
}

// IsSuccess returns true when this get task comments o k response has a 2xx status code
func (o *GetTaskCommentsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get task comments o k response has a 3xx status code
func (o *GetTaskCommentsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get task comments o k response has a 4xx status code
func (o *GetTaskCommentsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get task comments o k response has a 5xx status code
func (o *GetTaskCommentsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get task comments o k response a status code equal to that given
func (o *GetTaskCommentsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get task comments o k response
func (o *GetTaskCommentsOK) Code() int {
	return 200
}

func (o *GetTaskCommentsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /tasks/{id}/comments][%d] getTaskCommentsOK %s", 200, payload)
}

func (o *GetTaskCommentsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /tasks/{id}/comments][%d] getTaskCommentsOK %s", 200, payload)
}

func (o *GetTaskCommentsOK) GetPayload() []*models.Comment {
	return o.Payload
}

func (o *GetTaskCommentsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTaskCommentsDefault creates a GetTaskCommentsDefault with default headers values
func NewGetTaskCommentsDefault(code int) *GetTaskCommentsDefault {
	return &GetTaskCommentsDefault{
		_statusCode: code,
	}
}

/*
GetTaskCommentsDefault describes a response with status code -1, with default header values.

Error response
*/
type GetTaskCommentsDefault struct {
	_statusCode int
	XErrorCode  string

	Payload *models.Error
}

// IsSuccess returns true when this get task comments default response has a 2xx status code
func (o *GetTaskCommentsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get task comments default response has a 3xx status code
func (o *GetTaskCommentsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get task comments default response has a 4xx status code
func (o *GetTaskCommentsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get task comments default response has a 5xx status code
func (o *GetTaskCommentsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get task comments default response a status code equal to that given
func (o *GetTaskCommentsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get task comments default response
func (o *GetTaskCommentsDefault) Code() int {
	return o._statusCode
}

func (o *GetTaskCommentsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /tasks/{id}/comments][%d] getTaskComments default %s", o._statusCode, payload)
}

func (o *GetTaskCommentsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /tasks/{id}/comments][%d] getTaskComments default %s", o._statusCode, payload)
}

func (o *GetTaskCommentsDefault) GetPayload() *models.Error {
	return o.Payload
}

func (o *GetTaskCommentsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header X-Error-Code
	hdrXErrorCode := response.GetHeader("X-Error-Code")

	if hdrXErrorCode != "" {
		o.XErrorCode = hdrXErrorCode
	}

	o.Payload = new(models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
