/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swingframework.autofit;

import java.awt.Component;
import java.awt.FontMetrics;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class AutoFitTable
extends JTable {
    private static final Logger LOG = Logger.getLogger(AutoFitTable.class);
    private static final long serialVersionUID = 1L;

    public AutoFitTable() {
    }

    public AutoFitTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public AutoFitTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public AutoFitTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public AutoFitTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public AutoFitTable(TableModel dm) {
        super(dm);
    }

    public AutoFitTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public void autoFit(List<Integer> ignoreColumns) {
        this.setAutoResizeMode(0);
        FontMetrics metrics = this.getTableHeader().getGraphics().getFontMetrics();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            int columnIdx = this.convertRowIndexToModel(i);
            if (ignoreColumns != null && ignoreColumns.contains(columnIdx)) continue;
            int width = metrics.stringWidth(this.getColumnName(i)) + 20;
            for (int j = 0; j < this.getRowCount(); ++j) {
                int rowIdx = this.convertRowIndexToModel(j);
                Object value = this.getValueAt(j, i);
                TableCellRenderer renderer = this.getCellRenderer(j, i);
                if (renderer == null) continue;
                Component rendererComponent = renderer.getTableCellRendererComponent(this, value, false, false, rowIdx, columnIdx);
                try {
                    Method getText = rendererComponent.getClass().getMethod("getText", new Class[0]);
                    String text = (String)getText.invoke((Object)rendererComponent, new Object[0]);
                    int cellWidth = this.getGraphics().getFontMetrics(rendererComponent.getFont()).stringWidth(text) + 12;
                    if (cellWidth <= width) continue;
                    width = cellWidth;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            LOG.debug((Object)("Column " + i + " width: " + width));
            this.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }
}

