/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.plugins.autosave;

import java.io.File;
import java.util.EnumSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.SwingUtilities;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.EventType;
import org.diylc.common.IPlugIn;
import org.diylc.common.IPlugInPort;
import org.diylc.core.IView;

public class AutoSavePlugin
implements IPlugIn {
    private static final String AUTO_SAVE_FILE_NAME = "autoSave.diy";
    protected static final long autoSaveFrequency = 60000L;
    private ExecutorService executor;
    private IPlugInPort plugInPort;
    private IView view;
    private long lastSave = 0L;

    public AutoSavePlugin(IView iView) {
        this.view = iView;
        this.executor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void connect(IPlugInPort iPlugInPort) {
        this.plugInPort = iPlugInPort;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n;
                boolean bl = ConfigurationManager.getInstance().readBoolean("abnormalExit", false);
                if (bl && new File(AutoSavePlugin.AUTO_SAVE_FILE_NAME).exists() && (n = AutoSavePlugin.this.view.showConfirmDialog("It appears that aplication was not closed normally in the previous session. Do you want to open the last auto-saved file?", "Auto-Save", 0, 3)) == 0) {
                    AutoSavePlugin.this.plugInPort.loadProjectFromFile(AutoSavePlugin.AUTO_SAVE_FILE_NAME);
                }
                ConfigurationManager.getInstance().writeValue("abnormalExit", true);
            }
        });
    }

    @Override
    public EnumSet<EventType> getSubscribedEventTypes() {
        return EnumSet.of(EventType.PROJECT_MODIFIED);
    }

    @Override
    public void processMessage(EventType eventType, Object ... objectArray) {
        if (eventType == EventType.PROJECT_MODIFIED && System.currentTimeMillis() - this.lastSave > 60000L) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread.currentThread().setPriority(1);
                    AutoSavePlugin.this.lastSave = System.currentTimeMillis();
                    AutoSavePlugin.this.plugInPort.saveProjectToFile(AutoSavePlugin.AUTO_SAVE_FILE_NAME, true);
                }
            });
        }
    }
}

