/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.formula.ControlPtg;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;

public final class AttrPtg
extends ControlPtg {
    public static final byte sid = 25;
    private static final int SIZE = 4;
    private byte field_1_options;
    private short field_2_data;
    private final int[] _jumpTable;
    private final int _chooseFuncOffset;
    private static final BitField semiVolatile = BitFieldFactory.getInstance(1);
    private static final BitField optiIf = BitFieldFactory.getInstance(2);
    private static final BitField optiChoose = BitFieldFactory.getInstance(4);
    private static final BitField optGoto = BitFieldFactory.getInstance(8);
    private static final BitField sum = BitFieldFactory.getInstance(16);
    private static final BitField baxcel = BitFieldFactory.getInstance(32);
    private static final BitField space = BitFieldFactory.getInstance(64);
    public static final AttrPtg SUM = new AttrPtg(16, 0, null, -1);

    public AttrPtg() {
        this._jumpTable = null;
        this._chooseFuncOffset = -1;
    }

    public AttrPtg(LittleEndianInput in) {
        this.field_1_options = in.readByte();
        this.field_2_data = in.readShort();
        if (this.isOptimizedChoose()) {
            short nCases = this.field_2_data;
            int[] jumpTable = new int[nCases];
            for (int i = 0; i < jumpTable.length; ++i) {
                jumpTable[i] = in.readUShort();
            }
            this._jumpTable = jumpTable;
            this._chooseFuncOffset = in.readUShort();
        } else {
            this._jumpTable = null;
            this._chooseFuncOffset = -1;
        }
    }

    private AttrPtg(int options, int data, int[] jt, int chooseFuncOffset) {
        this.field_1_options = (byte)options;
        this.field_2_data = (short)data;
        this._jumpTable = jt;
        this._chooseFuncOffset = chooseFuncOffset;
    }

    public static AttrPtg createSpace(int type, int count) {
        int data = type & 0xFF | count << 8 & 0xFFFF;
        return new AttrPtg(space.set(0), data, null, -1);
    }

    public static AttrPtg getSumSingle() {
        return new AttrPtg(sum.set(0), 0, null, -1);
    }

    public boolean isSemiVolatile() {
        return semiVolatile.isSet(this.field_1_options);
    }

    public boolean isOptimizedIf() {
        return optiIf.isSet(this.field_1_options);
    }

    public boolean isOptimizedChoose() {
        return optiChoose.isSet(this.field_1_options);
    }

    public boolean isGoto() {
        return optGoto.isSet(this.field_1_options);
    }

    public boolean isSum() {
        return sum.isSet(this.field_1_options);
    }

    public void setOptimizedIf(boolean bif) {
        this.field_1_options = optiIf.setByteBoolean(this.field_1_options, bif);
    }

    public void setGoto(boolean isGoto) {
        this.field_1_options = optGoto.setByteBoolean(this.field_1_options, isGoto);
    }

    private boolean isBaxcel() {
        return baxcel.isSet(this.field_1_options);
    }

    public boolean isSpace() {
        return space.isSet(this.field_1_options);
    }

    public void setData(short data) {
        this.field_2_data = data;
    }

    public short getData() {
        return this.field_2_data;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        if (this.isSemiVolatile()) {
            sb.append("volatile ");
        }
        if (this.isSpace()) {
            sb.append("space count=").append(this.field_2_data >> 8 & 0xFF);
            sb.append(" type=").append(this.field_2_data & 0xFF).append(" ");
        }
        if (this.isOptimizedIf()) {
            sb.append("if dist=").append(this.getData());
        } else if (this.isOptimizedChoose()) {
            sb.append("choose nCases=").append(this.getData());
        } else if (this.isGoto()) {
            sb.append("skip dist=").append(this.getData());
        } else if (this.isSum()) {
            sb.append("sum ");
        } else if (this.isBaxcel()) {
            sb.append("assign ");
        }
        sb.append("]");
        return sb.toString();
    }

    public void write(LittleEndianOutput out) {
        out.writeByte(25 + this.getPtgClass());
        out.writeByte(this.field_1_options);
        out.writeShort(this.field_2_data);
        int[] jt = this._jumpTable;
        if (jt != null) {
            for (int i = 0; i < jt.length; ++i) {
                out.writeShort(jt[i]);
            }
            out.writeShort(this._chooseFuncOffset);
        }
    }

    public int getSize() {
        if (this._jumpTable != null) {
            return 4 + (this._jumpTable.length + 1) * 2;
        }
        return 4;
    }

    public String toFormulaString(String[] operands) {
        if (space.isSet(this.field_1_options)) {
            return operands[0];
        }
        if (optiIf.isSet(this.field_1_options)) {
            return this.toFormulaString() + "(" + operands[0] + ")";
        }
        if (optGoto.isSet(this.field_1_options)) {
            return this.toFormulaString() + operands[0];
        }
        return this.toFormulaString() + "(" + operands[0] + ")";
    }

    public int getNumberOfOperands() {
        return 1;
    }

    public int getType() {
        return -1;
    }

    public String toFormulaString() {
        if (semiVolatile.isSet(this.field_1_options)) {
            return "ATTR(semiVolatile)";
        }
        if (optiIf.isSet(this.field_1_options)) {
            return "IF";
        }
        if (optiChoose.isSet(this.field_1_options)) {
            return "CHOOSE";
        }
        if (optGoto.isSet(this.field_1_options)) {
            return "";
        }
        if (sum.isSet(this.field_1_options)) {
            return "SUM";
        }
        if (baxcel.isSet(this.field_1_options)) {
            return "ATTR(baxcel)";
        }
        if (space.isSet(this.field_1_options)) {
            return "";
        }
        return "UNKNOWN ATTRIBUTE";
    }

    public Object clone() {
        int[] jt = this._jumpTable == null ? null : (int[])this._jumpTable.clone();
        return new AttrPtg(this.field_1_options, this.field_2_data, jt, this._chooseFuncOffset);
    }

    public static final class SpaceType {
        public static final int SPACE_BEFORE = 0;
        public static final int CR_BEFORE = 1;
        public static final int SPACE_BEFORE_OPEN_PAREN = 2;
        public static final int CR_BEFORE_OPEN_PAREN = 3;
        public static final int SPACE_BEFORE_CLOSE_PAREN = 4;
        public static final int CR_BEFORE_CLOSE_PAREN = 5;
        public static final int SPACE_AFTER_EQUALITY = 6;

        private SpaceType() {
        }
    }
}

