package woff2

const (
	// signature is the WOFF 2.0 file identifying signature 'wOF2'.
	signature = uint32('w'<<24 | 'O'<<16 | 'F'<<8 | '2')

	// ttcfFlavor is the TrueType Collection flavor 'ttcf'.
	ttcfFlavor = uint32('t'<<24 | 't'<<16 | 'c'<<8 | 'f')

	glyfTable = uint32('g'<<24 | 'l'<<16 | 'y'<<8 | 'f')
	locaTable = uint32('l'<<24 | 'o'<<16 | 'c'<<8 | 'a')
)

// knownTableTags is the "Known Table Tags" table.
var knownTableTags = [...]uint32{
	0:  uint32('c'<<24 | 'm'<<16 | 'a'<<8 | 'p'),
	1:  uint32('h'<<24 | 'e'<<16 | 'a'<<8 | 'd'),
	2:  uint32('h'<<24 | 'h'<<16 | 'e'<<8 | 'a'),
	3:  uint32('h'<<24 | 'm'<<16 | 't'<<8 | 'x'),
	4:  uint32('m'<<24 | 'a'<<16 | 'x'<<8 | 'p'),
	5:  uint32('n'<<24 | 'a'<<16 | 'm'<<8 | 'e'),
	6:  uint32('O'<<24 | 'S'<<16 | '/'<<8 | '2'),
	7:  uint32('p'<<24 | 'o'<<16 | 's'<<8 | 't'),
	8:  uint32('c'<<24 | 'v'<<16 | 't'<<8 | ' '),
	9:  uint32('f'<<24 | 'p'<<16 | 'g'<<8 | 'm'),
	10: uint32('g'<<24 | 'l'<<16 | 'y'<<8 | 'f'),
	11: uint32('l'<<24 | 'o'<<16 | 'c'<<8 | 'a'),
	12: uint32('p'<<24 | 'r'<<16 | 'e'<<8 | 'p'),
	13: uint32('C'<<24 | 'F'<<16 | 'F'<<8 | ' '),
	14: uint32('V'<<24 | 'O'<<16 | 'R'<<8 | 'G'),
	15: uint32('E'<<24 | 'B'<<16 | 'D'<<8 | 'T'),
	16: uint32('E'<<24 | 'B'<<16 | 'L'<<8 | 'C'),
	17: uint32('g'<<24 | 'a'<<16 | 's'<<8 | 'p'),
	18: uint32('h'<<24 | 'd'<<16 | 'm'<<8 | 'x'),
	19: uint32('k'<<24 | 'e'<<16 | 'r'<<8 | 'n'),
	20: uint32('L'<<24 | 'T'<<16 | 'S'<<8 | 'H'),
	21: uint32('P'<<24 | 'C'<<16 | 'L'<<8 | 'T'),
	22: uint32('V'<<24 | 'D'<<16 | 'M'<<8 | 'X'),
	23: uint32('v'<<24 | 'h'<<16 | 'e'<<8 | 'a'),
	24: uint32('v'<<24 | 'm'<<16 | 't'<<8 | 'x'),
	25: uint32('B'<<24 | 'A'<<16 | 'S'<<8 | 'E'),
	26: uint32('G'<<24 | 'D'<<16 | 'E'<<8 | 'F'),
	27: uint32('G'<<24 | 'P'<<16 | 'O'<<8 | 'S'),
	28: uint32('G'<<24 | 'S'<<16 | 'U'<<8 | 'B'),
	29: uint32('E'<<24 | 'B'<<16 | 'S'<<8 | 'C'),
	30: uint32('J'<<24 | 'S'<<16 | 'T'<<8 | 'F'),
	31: uint32('M'<<24 | 'A'<<16 | 'T'<<8 | 'H'),
	32: uint32('C'<<24 | 'B'<<16 | 'D'<<8 | 'T'),
	33: uint32('C'<<24 | 'B'<<16 | 'L'<<8 | 'C'),
	34: uint32('C'<<24 | 'O'<<16 | 'L'<<8 | 'R'),
	35: uint32('C'<<24 | 'P'<<16 | 'A'<<8 | 'L'),
	36: uint32('S'<<24 | 'V'<<16 | 'G'<<8 | ' '),
	37: uint32('s'<<24 | 'b'<<16 | 'i'<<8 | 'x'),
	38: uint32('a'<<24 | 'c'<<16 | 'n'<<8 | 't'),
	39: uint32('a'<<24 | 'v'<<16 | 'a'<<8 | 'r'),
	40: uint32('b'<<24 | 'd'<<16 | 'a'<<8 | 't'),
	41: uint32('b'<<24 | 'l'<<16 | 'o'<<8 | 'c'),
	42: uint32('b'<<24 | 's'<<16 | 'l'<<8 | 'n'),
	43: uint32('c'<<24 | 'v'<<16 | 'a'<<8 | 'r'),
	44: uint32('f'<<24 | 'd'<<16 | 's'<<8 | 'c'),
	45: uint32('f'<<24 | 'e'<<16 | 'a'<<8 | 't'),
	46: uint32('f'<<24 | 'm'<<16 | 't'<<8 | 'x'),
	47: uint32('f'<<24 | 'v'<<16 | 'a'<<8 | 'r'),
	48: uint32('g'<<24 | 'v'<<16 | 'a'<<8 | 'r'),
	49: uint32('h'<<24 | 's'<<16 | 't'<<8 | 'y'),
	50: uint32('j'<<24 | 'u'<<16 | 's'<<8 | 't'),
	51: uint32('l'<<24 | 'c'<<16 | 'a'<<8 | 'r'),
	52: uint32('m'<<24 | 'o'<<16 | 'r'<<8 | 't'),
	53: uint32('m'<<24 | 'o'<<16 | 'r'<<8 | 'x'),
	54: uint32('o'<<24 | 'p'<<16 | 'b'<<8 | 'd'),
	55: uint32('p'<<24 | 'r'<<16 | 'o'<<8 | 'p'),
	56: uint32('t'<<24 | 'r'<<16 | 'a'<<8 | 'k'),
	57: uint32('Z'<<24 | 'a'<<16 | 'p'<<8 | 'f'),
	58: uint32('S'<<24 | 'i'<<16 | 'l'<<8 | 'f'),
	59: uint32('G'<<24 | 'l'<<16 | 'a'<<8 | 't'),
	60: uint32('G'<<24 | 'l'<<16 | 'o'<<8 | 'c'),
	61: uint32('F'<<24 | 'e'<<16 | 'a'<<8 | 't'),
	62: uint32('S'<<24 | 'i'<<16 | 'l'<<8 | 'l'),
}
