/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.MapEditorTransformPanel;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;

public final class InfoPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(InfoPanel.class.getName());
    private static final int SLACK = 5;
    private static final int PANEL_WIDTH = 260;
    public static final int PANEL_HEIGHT = 130;
    private InfoPanelMode mode = InfoPanelMode.NONE;
    private final EndTurnPanel endTurnPanel = new EndTurnPanel();
    private final JPanel mapEditorPanel = new JPanel(null);
    private final TileInfoPanel tileInfoPanel;
    private final UnitInfoPanel unitInfoPanel;
    private final Image skin;

    public InfoPanel(FreeColClient freeColClient) {
        this(freeColClient, true);
    }

    public InfoPanel(FreeColClient freeColClient, boolean useSkin) {
        super(freeColClient);
        this.mapEditorPanel.setSize(130, 100);
        this.mapEditorPanel.setOpaque(false);
        this.tileInfoPanel = new TileInfoPanel();
        this.unitInfoPanel = new UnitInfoPanel();
        this.skin = useSkin ? ResourceManager.getImage("image.skin.InfoPanel") : null;
        this.setLayout(null);
        int internalPanelTop = 0;
        int internalPanelHeight = 128;
        if (this.skin != null) {
            this.setBorder(null);
            this.setSize(this.skin.getWidth(null), this.skin.getHeight(null));
            this.setOpaque(false);
            internalPanelTop = 75;
            internalPanelHeight = 128;
        } else {
            this.setSize(260, 130);
        }
        this.add(this.endTurnPanel, internalPanelTop, internalPanelHeight);
        this.add(this.mapEditorPanel, internalPanelTop, internalPanelHeight);
        this.add(this.tileInfoPanel, internalPanelTop, internalPanelHeight);
        this.add(this.unitInfoPanel, internalPanelTop, internalPanelHeight);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Unit activeUnit = InfoPanel.this.getGUI().getActiveUnit();
                if (activeUnit != null && activeUnit.hasTile()) {
                    InfoPanel.this.getGUI().setFocus(activeUnit.getTile());
                }
            }
        });
    }

    private void add(JPanel panel, int internalTop, int internalHeight) {
        panel.setVisible(false);
        panel.setLocation((this.getWidth() - panel.getWidth()) / 2, internalTop + (internalHeight - panel.getHeight()) / 2);
        this.add(panel);
    }

    private InfoPanelMode getMode() {
        return this.getFreeColClient().isMapEditor() ? InfoPanelMode.MAP : (this.getGUI().getViewMode() == 1 ? InfoPanelMode.TILE : (this.unitInfoPanel.hasUnit() ? InfoPanelMode.UNIT : (this.getFreeColClient().getMyPlayer() == null ? InfoPanelMode.NONE : InfoPanelMode.END)));
    }

    public void update(MapEditorTransformPanel.MapTransform mapTransform) {
        JPanel p;
        JPanel jPanel = p = mapTransform == null ? null : mapTransform.getDescriptionPanel();
        if (p != null) {
            p.setOpaque(false);
            Dimension d = p.getPreferredSize();
            p.setBounds(0, (this.mapEditorPanel.getHeight() - d.height) / 2, this.mapEditorPanel.getWidth(), d.height);
            this.mapEditorPanel.removeAll();
            this.mapEditorPanel.add((Component)p, "Center");
            this.mapEditorPanel.validate();
            this.mapEditorPanel.revalidate();
        }
        this.update();
    }

    public void update(Tile tile) {
        if (this.tileInfoPanel.getTile() != tile) {
            this.tileInfoPanel.update(tile);
        }
        this.update();
    }

    public void update(Unit unit) {
        this.unitInfoPanel.update(unit);
        this.update();
    }

    public void update() {
        InfoPanelMode newMode = this.getMode();
        if (newMode == InfoPanelMode.END && this.getFreeColClient().getMyPlayer().hasNextActiveUnit()) {
            logger.warning("Inconsistent InfoPanel status");
        }
        if (this.mode != newMode) {
            logger.info("Switching InfoPanel mode from " + (Object)((Object)this.mode) + " to " + (Object)((Object)newMode));
            this.mode = newMode;
            switch (this.mode) {
                case END: {
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    this.endTurnPanel.setVisible(true);
                    break;
                }
                case MAP: {
                    this.endTurnPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(true);
                    break;
                }
                case TILE: {
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(true);
                    break;
                }
                case UNIT: {
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(true);
                    break;
                }
                default: {
                    this.endTurnPanel.setVisible(false);
                    this.mapEditorPanel.setVisible(false);
                    this.tileInfoPanel.setVisible(false);
                    this.unitInfoPanel.setVisible(false);
                }
            }
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.skin != null) {
            graphics.drawImage(this.skin, 0, 0, null);
        }
        super.paintComponent(graphics);
    }

    private static enum InfoPanelMode {
        NONE,
        END,
        MAP,
        TILE,
        UNIT;

    }

    public class UnitInfoPanel
    extends JPanel
    implements PropertyChangeListener {
        private Unit unit;

        public UnitInfoPanel() {
            super(new MigLayout("wrap 5, fill, gap 0 0", "", ""));
            this.setSize(260, 130);
            this.setOpaque(false);
        }

        public boolean hasUnit() {
            return this.unit != null;
        }

        public void update(Unit unit) {
            if (this.unit != unit) {
                GoodsContainer gc;
                if (this.unit != null) {
                    this.unit.removePropertyChangeListener(this);
                    gc = this.unit.getGoodsContainer();
                    if (gc != null) {
                        gc.removePropertyChangeListener(this);
                    }
                }
                if (unit != null) {
                    unit.addPropertyChangeListener(this);
                    gc = unit.getGoodsContainer();
                    if (gc != null) {
                        gc.addPropertyChangeListener(this);
                    }
                }
                logger.info("Switching UnitInfoPanel from " + (this.unit == null ? "null" : this.unit.getId() + " " + this.unit.getDescription() + " " + this.unit.getMovesAsString()) + " to " + (unit == null ? "null" : unit.getId() + " " + unit.getDescription() + " " + unit.getMovesAsString()));
                this.unit = unit;
            }
            this.update();
        }

        public void update() {
            this.removeAll();
            ImageLibrary lib = InfoPanel.this.getGUI().getTileImageLibrary();
            Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, lib.getScaleFactor());
            if (this.unit != null) {
                JLabel textLabel;
                ImageIcon ii = new ImageIcon(lib.getUnitImage(this.unit));
                JLabel imageLabel = new JLabel(ii);
                this.add((Component)imageLabel, "spany, gapafter 5px");
                int width = this.getWidth() - ii.getIconWidth() - 5;
                String text = this.unit.getDescription(Unit.UnitLabelType.FULL);
                for (String s : StringUtils.splitText(text, " /", this.getFontMetrics(font), width)) {
                    textLabel = new JLabel(s);
                    textLabel.setFont(font);
                    this.add((Component)textLabel, "span 5");
                }
                text = this.unit.isInEurope() ? Messages.getName(this.unit.getOwner().getEurope()) : Messages.message("infoPanel.moves") + " " + this.unit.getMovesAsString();
                textLabel = new JLabel(text);
                textLabel.setFont(font);
                this.add((Component)textLabel, "span 5");
                if (this.unit.isCarrier()) {
                    JLabel label;
                    ImageIcon icon;
                    for (Goods goods : this.unit.getGoodsList()) {
                        int amount = goods.getAmount();
                        GoodsType gt = goods.getType();
                        if (amount == 100) {
                            icon = new ImageIcon(lib.getIconImage(gt));
                            label = new JLabel(icon);
                        } else {
                            icon = new ImageIcon(lib.getSmallIconImage(gt));
                            label = new JLabel(String.valueOf(amount), icon, 4);
                        }
                        text = Messages.message(goods.getLabel(true));
                        label.setFont(font);
                        label.setToolTipText(text);
                        this.add(label);
                    }
                    for (Unit carriedUnit : this.unit.getUnitList()) {
                        icon = new ImageIcon(lib.getSmallerUnitImage(carriedUnit));
                        label = new JLabel(icon);
                        text = carriedUnit.getDescription(Unit.UnitLabelType.NATIONAL);
                        label.setFont(font);
                        label.setToolTipText(text);
                        this.add(label);
                    }
                }
            }
            this.revalidate();
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            this.update();
        }
    }

    public class TileInfoPanel
    extends MigPanel {
        private static final int PRODUCTION = 4;
        private Tile tile;

        public TileInfoPanel() {
            super(new MigLayout("fill, wrap 5, gap 1 1"));
            this.setSize(260, 130);
            this.setOpaque(false);
        }

        public void update(Tile tile) {
            this.tile = tile;
            this.removeAll();
            ImageLibrary lib = InfoPanel.this.getGUI().getTileImageLibrary();
            Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, lib.getScaleFactor());
            if (tile != null) {
                int width = this.getWidth() - 5;
                BufferedImage image = InfoPanel.this.getGUI().createTileImageWithBeachBorderAndItems(tile);
                if (tile.isExplored()) {
                    String text = Messages.message(tile.getLabel());
                    for (String s : StringUtils.splitText(text, " /", this.getFontMetrics(font), width)) {
                        JLabel label = new JLabel(s);
                        this.add((Component)label, "span, align center");
                    }
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                    Player owner = tile.getOwner();
                    if (owner == null) {
                        this.add((Component)new JLabel(), "span 4");
                    } else {
                        StringTemplate t = owner.getNationLabel();
                        this.add((Component)Utility.localizedLabel(t), "span 4");
                    }
                    JLabel defenceLabel = Utility.localizedLabel(StringTemplate.template("infoPanel.defenseBonus").addAmount("%bonus%", tile.getDefenceBonusPercentage()));
                    this.add((Component)defenceLabel, "span 4");
                    JLabel moveLabel = Utility.localizedLabel(StringTemplate.template("infoPanel.movementCost").addAmount("%cost%", tile.getType().getBasicMoveCost() / 3));
                    this.add((Component)moveLabel, "span 4");
                    List<AbstractGoods> produce = tile.getType().getPossibleProduction(true);
                    if (produce.isEmpty()) {
                        this.add((Component)new JLabel(), "span 4");
                    } else {
                        Collections.sort(produce, AbstractGoods.abstractGoodsComparator);
                        for (AbstractGoods ag : produce) {
                            GoodsType type = ag.getType();
                            int n = tile.getPotentialProduction(type, null);
                            JLabel label = new JLabel(String.valueOf(n), new ImageIcon(lib.getSmallIconImage(type)), 4);
                            label.setToolTipText(Messages.getName(type));
                            label.setFont(font);
                            this.add(label);
                        }
                    }
                } else {
                    this.add((Component)Utility.localizedLabel("unexplored"), "span, align center");
                    this.add((Component)new JLabel(new ImageIcon(image)), "spany");
                }
            }
            this.revalidate();
            this.repaint();
        }

        public Tile getTile() {
            return this.tile;
        }
    }

    public class EndTurnPanel
    extends MigPanel {
        public EndTurnPanel() {
            super(new MigLayout("wrap 1, center", "[center]", ""));
            ImageLibrary lib = InfoPanel.this.getGUI().getTileImageLibrary();
            Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.TINY, lib.getScaleFactor());
            String labelString = Messages.message("infoPanel.endTurn");
            for (String s : StringUtils.splitText(labelString, " /", this.getFontMetrics(font), 150)) {
                JLabel label = new JLabel(s);
                label.setFont(font);
                this.add(label);
            }
            JButton button = new JButton(InfoPanel.this.getFreeColClient().getActionManager().getFreeColAction("endTurnAction"));
            button.setFont(font);
            this.add(button);
            this.setOpaque(false);
            this.setSize(this.getPreferredSize());
        }
    }
}

