package edgeorderapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/edgeorder/mgmt/2021-12-01/edgeorder"
	"github.com/Azure/go-autorest/autorest"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CancelOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, cancellationReason edgeorder.CancellationReason) (result autorest.Response, err error)
	CreateAddress(ctx context.Context, addressName string, resourceGroupName string, addressResource edgeorder.AddressResource) (result edgeorder.CreateAddressFuture, err error)
	CreateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemResource edgeorder.OrderItemResource) (result edgeorder.CreateOrderItemFuture, err error)
	DeleteAddressByName(ctx context.Context, addressName string, resourceGroupName string) (result edgeorder.DeleteAddressByNameFuture, err error)
	DeleteOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string) (result edgeorder.DeleteOrderItemByNameFuture, err error)
	GetAddressByName(ctx context.Context, addressName string, resourceGroupName string) (result edgeorder.AddressResource, err error)
	GetOrderByName(ctx context.Context, orderName string, resourceGroupName string, location string) (result edgeorder.OrderResource, err error)
	GetOrderItemByName(ctx context.Context, orderItemName string, resourceGroupName string, expand string) (result edgeorder.OrderItemResource, err error)
	ListAddressesAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string, skipToken string) (result edgeorder.AddressResourceListPage, err error)
	ListAddressesAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string, skipToken string) (result edgeorder.AddressResourceListIterator, err error)
	ListAddressesAtSubscriptionLevel(ctx context.Context, filter string, skipToken string) (result edgeorder.AddressResourceListPage, err error)
	ListAddressesAtSubscriptionLevelComplete(ctx context.Context, filter string, skipToken string) (result edgeorder.AddressResourceListIterator, err error)
	ListConfigurations(ctx context.Context, configurationsRequest edgeorder.ConfigurationsRequest, skipToken string) (result edgeorder.ConfigurationsPage, err error)
	ListConfigurationsComplete(ctx context.Context, configurationsRequest edgeorder.ConfigurationsRequest, skipToken string) (result edgeorder.ConfigurationsIterator, err error)
	ListOperations(ctx context.Context) (result edgeorder.OperationListResultPage, err error)
	ListOperationsComplete(ctx context.Context) (result edgeorder.OperationListResultIterator, err error)
	ListOrderAtResourceGroupLevel(ctx context.Context, resourceGroupName string, skipToken string) (result edgeorder.OrderResourceListPage, err error)
	ListOrderAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, skipToken string) (result edgeorder.OrderResourceListIterator, err error)
	ListOrderAtSubscriptionLevel(ctx context.Context, skipToken string) (result edgeorder.OrderResourceListPage, err error)
	ListOrderAtSubscriptionLevelComplete(ctx context.Context, skipToken string) (result edgeorder.OrderResourceListIterator, err error)
	ListOrderItemsAtResourceGroupLevel(ctx context.Context, resourceGroupName string, filter string, expand string, skipToken string) (result edgeorder.OrderItemResourceListPage, err error)
	ListOrderItemsAtResourceGroupLevelComplete(ctx context.Context, resourceGroupName string, filter string, expand string, skipToken string) (result edgeorder.OrderItemResourceListIterator, err error)
	ListOrderItemsAtSubscriptionLevel(ctx context.Context, filter string, expand string, skipToken string) (result edgeorder.OrderItemResourceListPage, err error)
	ListOrderItemsAtSubscriptionLevelComplete(ctx context.Context, filter string, expand string, skipToken string) (result edgeorder.OrderItemResourceListIterator, err error)
	ListProductFamilies(ctx context.Context, productFamiliesRequest edgeorder.ProductFamiliesRequest, expand string, skipToken string) (result edgeorder.ProductFamiliesPage, err error)
	ListProductFamiliesComplete(ctx context.Context, productFamiliesRequest edgeorder.ProductFamiliesRequest, expand string, skipToken string) (result edgeorder.ProductFamiliesIterator, err error)
	ListProductFamiliesMetadata(ctx context.Context, skipToken string) (result edgeorder.ProductFamiliesMetadataPage, err error)
	ListProductFamiliesMetadataComplete(ctx context.Context, skipToken string) (result edgeorder.ProductFamiliesMetadataIterator, err error)
	ReturnOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, returnOrderItemDetails edgeorder.ReturnOrderItemDetails) (result edgeorder.ReturnOrderItemFuture, err error)
	UpdateAddress(ctx context.Context, addressName string, resourceGroupName string, addressUpdateParameter edgeorder.AddressUpdateParameter, ifMatch string) (result edgeorder.UpdateAddressFuture, err error)
	UpdateOrderItem(ctx context.Context, orderItemName string, resourceGroupName string, orderItemUpdateParameter edgeorder.OrderItemUpdateParameter, ifMatch string) (result edgeorder.UpdateOrderItemFuture, err error)
}

var _ BaseClientAPI = (*edgeorder.BaseClient)(nil)
