package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDnsGtmMonitorStatus invokes the alidns.SetDnsGtmMonitorStatus API synchronously
func (client *Client) SetDnsGtmMonitorStatus(request *SetDnsGtmMonitorStatusRequest) (response *SetDnsGtmMonitorStatusResponse, err error) {
	response = CreateSetDnsGtmMonitorStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetDnsGtmMonitorStatusWithChan invokes the alidns.SetDnsGtmMonitorStatus API asynchronously
func (client *Client) SetDnsGtmMonitorStatusWithChan(request *SetDnsGtmMonitorStatusRequest) (<-chan *SetDnsGtmMonitorStatusResponse, <-chan error) {
	responseChan := make(chan *SetDnsGtmMonitorStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDnsGtmMonitorStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDnsGtmMonitorStatusWithCallback invokes the alidns.SetDnsGtmMonitorStatus API asynchronously
func (client *Client) SetDnsGtmMonitorStatusWithCallback(request *SetDnsGtmMonitorStatusRequest, callback func(response *SetDnsGtmMonitorStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDnsGtmMonitorStatusResponse
		var err error
		defer close(result)
		response, err = client.SetDnsGtmMonitorStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDnsGtmMonitorStatusRequest is the request struct for api SetDnsGtmMonitorStatus
type SetDnsGtmMonitorStatusRequest struct {
	*requests.RpcRequest
	MonitorConfigId string `position:"Query" name:"MonitorConfigId"`
	UserClientIp    string `position:"Query" name:"UserClientIp"`
	Lang            string `position:"Query" name:"Lang"`
	Status          string `position:"Query" name:"Status"`
}

// SetDnsGtmMonitorStatusResponse is the response struct for api SetDnsGtmMonitorStatus
type SetDnsGtmMonitorStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDnsGtmMonitorStatusRequest creates a request to invoke SetDnsGtmMonitorStatus API
func CreateSetDnsGtmMonitorStatusRequest() (request *SetDnsGtmMonitorStatusRequest) {
	request = &SetDnsGtmMonitorStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "SetDnsGtmMonitorStatus", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetDnsGtmMonitorStatusResponse creates a response to parse from SetDnsGtmMonitorStatus response
func CreateSetDnsGtmMonitorStatusResponse() (response *SetDnsGtmMonitorStatusResponse) {
	response = &SetDnsGtmMonitorStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
