package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFromMetaCategory invokes the dataworks_public.DeleteFromMetaCategory API synchronously
func (client *Client) DeleteFromMetaCategory(request *DeleteFromMetaCategoryRequest) (response *DeleteFromMetaCategoryResponse, err error) {
	response = CreateDeleteFromMetaCategoryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFromMetaCategoryWithChan invokes the dataworks_public.DeleteFromMetaCategory API asynchronously
func (client *Client) DeleteFromMetaCategoryWithChan(request *DeleteFromMetaCategoryRequest) (<-chan *DeleteFromMetaCategoryResponse, <-chan error) {
	responseChan := make(chan *DeleteFromMetaCategoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFromMetaCategory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFromMetaCategoryWithCallback invokes the dataworks_public.DeleteFromMetaCategory API asynchronously
func (client *Client) DeleteFromMetaCategoryWithCallback(request *DeleteFromMetaCategoryRequest, callback func(response *DeleteFromMetaCategoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFromMetaCategoryResponse
		var err error
		defer close(result)
		response, err = client.DeleteFromMetaCategory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFromMetaCategoryRequest is the request struct for api DeleteFromMetaCategory
type DeleteFromMetaCategoryRequest struct {
	*requests.RpcRequest
	TableGuid  string           `position:"Query" name:"TableGuid"`
	CategoryId requests.Integer `position:"Query" name:"CategoryId"`
}

// DeleteFromMetaCategoryResponse is the response struct for api DeleteFromMetaCategory
type DeleteFromMetaCategoryResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateDeleteFromMetaCategoryRequest creates a request to invoke DeleteFromMetaCategory API
func CreateDeleteFromMetaCategoryRequest() (request *DeleteFromMetaCategoryRequest) {
	request = &DeleteFromMetaCategoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteFromMetaCategory", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteFromMetaCategoryResponse creates a response to parse from DeleteFromMetaCategory response
func CreateDeleteFromMetaCategoryResponse() (response *DeleteFromMetaCategoryResponse) {
	response = &DeleteFromMetaCategoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
