package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnRegionAndIsp invokes the dcdn.DescribeDcdnRegionAndIsp API synchronously
func (client *Client) DescribeDcdnRegionAndIsp(request *DescribeDcdnRegionAndIspRequest) (response *DescribeDcdnRegionAndIspResponse, err error) {
	response = CreateDescribeDcdnRegionAndIspResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnRegionAndIspWithChan invokes the dcdn.DescribeDcdnRegionAndIsp API asynchronously
func (client *Client) DescribeDcdnRegionAndIspWithChan(request *DescribeDcdnRegionAndIspRequest) (<-chan *DescribeDcdnRegionAndIspResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnRegionAndIspResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnRegionAndIsp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnRegionAndIspWithCallback invokes the dcdn.DescribeDcdnRegionAndIsp API asynchronously
func (client *Client) DescribeDcdnRegionAndIspWithCallback(request *DescribeDcdnRegionAndIspRequest, callback func(response *DescribeDcdnRegionAndIspResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnRegionAndIspResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnRegionAndIsp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnRegionAndIspRequest is the request struct for api DescribeDcdnRegionAndIsp
type DescribeDcdnRegionAndIspRequest struct {
	*requests.RpcRequest
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeDcdnRegionAndIspResponse is the response struct for api DescribeDcdnRegionAndIsp
type DescribeDcdnRegionAndIspResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Regions   Regions `json:"Regions" xml:"Regions"`
	Isps      Isps    `json:"Isps" xml:"Isps"`
}

// CreateDescribeDcdnRegionAndIspRequest creates a request to invoke DescribeDcdnRegionAndIsp API
func CreateDescribeDcdnRegionAndIspRequest() (request *DescribeDcdnRegionAndIspRequest) {
	request = &DescribeDcdnRegionAndIspRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnRegionAndIsp", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnRegionAndIspResponse creates a response to parse from DescribeDcdnRegionAndIsp response
func CreateDescribeDcdnRegionAndIspResponse() (response *DescribeDcdnRegionAndIspResponse) {
	response = &DescribeDcdnRegionAndIspResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
