package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSipAccount invokes the dyvmsapi.CreateSipAccount API synchronously
func (client *Client) CreateSipAccount(request *CreateSipAccountRequest) (response *CreateSipAccountResponse, err error) {
	response = CreateCreateSipAccountResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSipAccountWithChan invokes the dyvmsapi.CreateSipAccount API asynchronously
func (client *Client) CreateSipAccountWithChan(request *CreateSipAccountRequest) (<-chan *CreateSipAccountResponse, <-chan error) {
	responseChan := make(chan *CreateSipAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSipAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSipAccountWithCallback invokes the dyvmsapi.CreateSipAccount API asynchronously
func (client *Client) CreateSipAccountWithCallback(request *CreateSipAccountRequest, callback func(response *CreateSipAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSipAccountResponse
		var err error
		defer close(result)
		response, err = client.CreateSipAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSipAccountRequest is the request struct for api CreateSipAccount
type CreateSipAccountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BusinessKey          string           `position:"Query" name:"BusinessKey"`
	PartnerId            requests.Integer `position:"Query" name:"PartnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateSipAccountResponse is the response struct for api CreateSipAccount
type CreateSipAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateSipAccountRequest creates a request to invoke CreateSipAccount API
func CreateCreateSipAccountRequest() (request *CreateSipAccountRequest) {
	request = &CreateSipAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "CreateSipAccount", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateSipAccountResponse creates a response to parse from CreateSipAccount response
func CreateCreateSipAccountResponse() (response *CreateSipAccountResponse) {
	response = &CreateSipAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
