package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlarmContactGroups invokes the mse.ListAlarmContactGroups API synchronously
func (client *Client) ListAlarmContactGroups(request *ListAlarmContactGroupsRequest) (response *ListAlarmContactGroupsResponse, err error) {
	response = CreateListAlarmContactGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlarmContactGroupsWithChan invokes the mse.ListAlarmContactGroups API asynchronously
func (client *Client) ListAlarmContactGroupsWithChan(request *ListAlarmContactGroupsRequest) (<-chan *ListAlarmContactGroupsResponse, <-chan error) {
	responseChan := make(chan *ListAlarmContactGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlarmContactGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlarmContactGroupsWithCallback invokes the mse.ListAlarmContactGroups API asynchronously
func (client *Client) ListAlarmContactGroupsWithCallback(request *ListAlarmContactGroupsRequest, callback func(response *ListAlarmContactGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlarmContactGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListAlarmContactGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlarmContactGroupsRequest is the request struct for api ListAlarmContactGroups
type ListAlarmContactGroupsRequest struct {
	*requests.RpcRequest
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
}

// ListAlarmContactGroupsResponse is the response struct for api ListAlarmContactGroups
type ListAlarmContactGroupsResponse struct {
	*responses.BaseResponse
	HttpCode   string                   `json:"HttpCode" xml:"HttpCode"`
	TotalCount int                      `json:"TotalCount" xml:"TotalCount"`
	RequestId  string                   `json:"RequestId" xml:"RequestId"`
	Message    string                   `json:"Message" xml:"Message"`
	PageSize   int                      `json:"PageSize" xml:"PageSize"`
	PageNumber int                      `json:"PageNumber" xml:"PageNumber"`
	ErrorCode  string                   `json:"ErrorCode" xml:"ErrorCode"`
	Success    bool                     `json:"Success" xml:"Success"`
	Data       []AlarmContactGroupModel `json:"Data" xml:"Data"`
}

// CreateListAlarmContactGroupsRequest creates a request to invoke ListAlarmContactGroups API
func CreateListAlarmContactGroupsRequest() (request *ListAlarmContactGroupsRequest) {
	request = &ListAlarmContactGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "ListAlarmContactGroups", "", "")
	request.Method = requests.GET
	return
}

// CreateListAlarmContactGroupsResponse creates a response to parse from ListAlarmContactGroups response
func CreateListAlarmContactGroupsResponse() (response *ListAlarmContactGroupsResponse) {
	response = &ListAlarmContactGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
