package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobDetail invokes the openanalytics_open.GetJobDetail API synchronously
func (client *Client) GetJobDetail(request *GetJobDetailRequest) (response *GetJobDetailResponse, err error) {
	response = CreateGetJobDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobDetailWithChan invokes the openanalytics_open.GetJobDetail API asynchronously
func (client *Client) GetJobDetailWithChan(request *GetJobDetailRequest) (<-chan *GetJobDetailResponse, <-chan error) {
	responseChan := make(chan *GetJobDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobDetailWithCallback invokes the openanalytics_open.GetJobDetail API asynchronously
func (client *Client) GetJobDetailWithCallback(request *GetJobDetailRequest, callback func(response *GetJobDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobDetailResponse
		var err error
		defer close(result)
		response, err = client.GetJobDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobDetailRequest is the request struct for api GetJobDetail
type GetJobDetailRequest struct {
	*requests.RpcRequest
	JobId  string `position:"Body" name:"JobId"`
	VcName string `position:"Body" name:"VcName"`
}

// GetJobDetailResponse is the response struct for api GetJobDetail
type GetJobDetailResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	JobDetail JobDetail `json:"JobDetail" xml:"JobDetail"`
}

// CreateGetJobDetailRequest creates a request to invoke GetJobDetail API
func CreateGetJobDetailRequest() (request *GetJobDetailRequest) {
	request = &GetJobDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "GetJobDetail", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetJobDetailResponse creates a response to parse from GetJobDetail response
func CreateGetJobDetailResponse() (response *GetJobDetailResponse) {
	response = &GetJobDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
