package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDownloadUrl invokes the outboundbot.CreateDownloadUrl API synchronously
func (client *Client) CreateDownloadUrl(request *CreateDownloadUrlRequest) (response *CreateDownloadUrlResponse, err error) {
	response = CreateCreateDownloadUrlResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDownloadUrlWithChan invokes the outboundbot.CreateDownloadUrl API asynchronously
func (client *Client) CreateDownloadUrlWithChan(request *CreateDownloadUrlRequest) (<-chan *CreateDownloadUrlResponse, <-chan error) {
	responseChan := make(chan *CreateDownloadUrlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDownloadUrl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDownloadUrlWithCallback invokes the outboundbot.CreateDownloadUrl API asynchronously
func (client *Client) CreateDownloadUrlWithCallback(request *CreateDownloadUrlRequest, callback func(response *CreateDownloadUrlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDownloadUrlResponse
		var err error
		defer close(result)
		response, err = client.CreateDownloadUrl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDownloadUrlRequest is the request struct for api CreateDownloadUrl
type CreateDownloadUrlRequest struct {
	*requests.RpcRequest
	DownloadTaskId string `position:"Query" name:"DownloadTaskId"`
	FileId         string `position:"Query" name:"FileId"`
}

// CreateDownloadUrlResponse is the response struct for api CreateDownloadUrl
type CreateDownloadUrlResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	FileHttpUrl    string `json:"FileHttpUrl" xml:"FileHttpUrl"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
}

// CreateCreateDownloadUrlRequest creates a request to invoke CreateDownloadUrl API
func CreateCreateDownloadUrlRequest() (request *CreateDownloadUrlRequest) {
	request = &CreateDownloadUrlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateDownloadUrl", "outboundbot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateCreateDownloadUrlResponse creates a response to parse from CreateDownloadUrl response
func CreateCreateDownloadUrlResponse() (response *CreateDownloadUrlResponse) {
	response = &CreateDownloadUrlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
