package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSearchCondition invokes the sas.DescribeSearchCondition API synchronously
func (client *Client) DescribeSearchCondition(request *DescribeSearchConditionRequest) (response *DescribeSearchConditionResponse, err error) {
	response = CreateDescribeSearchConditionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSearchConditionWithChan invokes the sas.DescribeSearchCondition API asynchronously
func (client *Client) DescribeSearchConditionWithChan(request *DescribeSearchConditionRequest) (<-chan *DescribeSearchConditionResponse, <-chan error) {
	responseChan := make(chan *DescribeSearchConditionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSearchCondition(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSearchConditionWithCallback invokes the sas.DescribeSearchCondition API asynchronously
func (client *Client) DescribeSearchConditionWithCallback(request *DescribeSearchConditionRequest, callback func(response *DescribeSearchConditionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSearchConditionResponse
		var err error
		defer close(result)
		response, err = client.DescribeSearchCondition(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSearchConditionRequest is the request struct for api DescribeSearchCondition
type DescribeSearchConditionRequest struct {
	*requests.RpcRequest
	Type     string `position:"Query" name:"Type"`
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeSearchConditionResponse is the response struct for api DescribeSearchCondition
type DescribeSearchConditionResponse struct {
	*responses.BaseResponse
	RequestId     string      `json:"RequestId" xml:"RequestId"`
	ConditionList []Condition `json:"ConditionList" xml:"ConditionList"`
}

// CreateDescribeSearchConditionRequest creates a request to invoke DescribeSearchCondition API
func CreateDescribeSearchConditionRequest() (request *DescribeSearchConditionRequest) {
	request = &DescribeSearchConditionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeSearchCondition", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSearchConditionResponse creates a response to parse from DescribeSearchCondition response
func CreateDescribeSearchConditionResponse() (response *DescribeSearchConditionResponse) {
	response = &DescribeSearchConditionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
