package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProjectMembers invokes the teambition_aliyun.DeleteProjectMembers API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectmembers.html
func (client *Client) DeleteProjectMembers(request *DeleteProjectMembersRequest) (response *DeleteProjectMembersResponse, err error) {
	response = CreateDeleteProjectMembersResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProjectMembersWithChan invokes the teambition_aliyun.DeleteProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteProjectMembersWithChan(request *DeleteProjectMembersRequest) (<-chan *DeleteProjectMembersResponse, <-chan error) {
	responseChan := make(chan *DeleteProjectMembersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProjectMembers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProjectMembersWithCallback invokes the teambition_aliyun.DeleteProjectMembers API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/deleteprojectmembers.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteProjectMembersWithCallback(request *DeleteProjectMembersRequest, callback func(response *DeleteProjectMembersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProjectMembersResponse
		var err error
		defer close(result)
		response, err = client.DeleteProjectMembers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProjectMembersRequest is the request struct for api DeleteProjectMembers
type DeleteProjectMembersRequest struct {
	*requests.RpcRequest
	UserIds   string `position:"Body" name:"UserIds"`
	ProjectId string `position:"Body" name:"ProjectId"`
	OrgId     string `position:"Body" name:"OrgId"`
}

// DeleteProjectMembersResponse is the response struct for api DeleteProjectMembers
type DeleteProjectMembersResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	Object     bool   `json:"Object" xml:"Object"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProjectMembersRequest creates a request to invoke DeleteProjectMembers API
func CreateDeleteProjectMembersRequest() (request *DeleteProjectMembersRequest) {
	request = &DeleteProjectMembersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "DeleteProjectMembers", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProjectMembersResponse creates a response to parse from DeleteProjectMembers response
func CreateDeleteProjectMembersResponse() (response *DeleteProjectMembersResponse) {
	response = &DeleteProjectMembersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
