package badio

import (
	"fmt"
)

type badReaderError struct {
	s string
}

func newError(format string, a ...interface{}) error {
	return &badReaderError{
		s: fmt.Sprintf(format, a...),
	}
}

func (c *badReaderError) Error() string {
	return c.s
}

// IsBadIOError returns a boolean indicating whether the error is known to
// be an error generated by the badio package itself rather than an underlying
// Reader or Writer implementation or the Go standard library.
func IsBadIOError(err error) bool {
	_, ok := err.(*badReaderError)
	return ok
}
