// +build ignore

package main

import (
	"io"
	"os"
	"path/filepath"
)

// Reads static/index.html and saves as a constant in static.go
func main() {
	wd, err := os.Getwd()
	if err != nil {
		panic(err)
	}
	out, err := os.Create(filepath.Join(wd, "static.go"))
	if err != nil {
		panic(err)
	}
	indexPath := filepath.Join(wd, "static", "index.html")

	out.Write([]byte("// This file is autogenerated; DO NOT EDIT DIRECTLY\n// See generate.go for more info\npackage main\n\nconst (\n"))
	out.Write([]byte("\tindexHTML = `"))
	f, err := os.Open(indexPath)
	if err != nil {
		panic(err)
	}
	defer f.Close()
	if _, err := io.Copy(out, f); err != nil {
		panic(err)
	}

	out.Write([]byte("`\n"))
	out.Write([]byte(")\n"))
}
