// Code generated by go-swagger; DO NOT EDIT.

package organization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/preview/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// OrganizationServiceSetNameReader is a Reader for the OrganizationServiceSetName structure.
type OrganizationServiceSetNameReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *OrganizationServiceSetNameReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewOrganizationServiceSetNameOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewOrganizationServiceSetNameDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewOrganizationServiceSetNameOK creates a OrganizationServiceSetNameOK with default headers values
func NewOrganizationServiceSetNameOK() *OrganizationServiceSetNameOK {
	return &OrganizationServiceSetNameOK{}
}

/*
OrganizationServiceSetNameOK describes a response with status code 200, with default header values.

A successful response.
*/
type OrganizationServiceSetNameOK struct {
	Payload *models.HashicorpCloudResourcemanagerOrganizationSetNameResponse
}

// IsSuccess returns true when this organization service set name o k response has a 2xx status code
func (o *OrganizationServiceSetNameOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this organization service set name o k response has a 3xx status code
func (o *OrganizationServiceSetNameOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this organization service set name o k response has a 4xx status code
func (o *OrganizationServiceSetNameOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this organization service set name o k response has a 5xx status code
func (o *OrganizationServiceSetNameOK) IsServerError() bool {
	return false
}

// IsCode returns true when this organization service set name o k response a status code equal to that given
func (o *OrganizationServiceSetNameOK) IsCode(code int) bool {
	return code == 200
}

func (o *OrganizationServiceSetNameOK) Error() string {
	return fmt.Sprintf("[PUT /resource-manager/2019-12-10/organizations/{id}/name][%d] organizationServiceSetNameOK  %+v", 200, o.Payload)
}

func (o *OrganizationServiceSetNameOK) String() string {
	return fmt.Sprintf("[PUT /resource-manager/2019-12-10/organizations/{id}/name][%d] organizationServiceSetNameOK  %+v", 200, o.Payload)
}

func (o *OrganizationServiceSetNameOK) GetPayload() *models.HashicorpCloudResourcemanagerOrganizationSetNameResponse {
	return o.Payload
}

func (o *OrganizationServiceSetNameOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerOrganizationSetNameResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewOrganizationServiceSetNameDefault creates a OrganizationServiceSetNameDefault with default headers values
func NewOrganizationServiceSetNameDefault(code int) *OrganizationServiceSetNameDefault {
	return &OrganizationServiceSetNameDefault{
		_statusCode: code,
	}
}

/*
OrganizationServiceSetNameDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type OrganizationServiceSetNameDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// Code gets the status code for the organization service set name default response
func (o *OrganizationServiceSetNameDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this organization service set name default response has a 2xx status code
func (o *OrganizationServiceSetNameDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this organization service set name default response has a 3xx status code
func (o *OrganizationServiceSetNameDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this organization service set name default response has a 4xx status code
func (o *OrganizationServiceSetNameDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this organization service set name default response has a 5xx status code
func (o *OrganizationServiceSetNameDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this organization service set name default response a status code equal to that given
func (o *OrganizationServiceSetNameDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *OrganizationServiceSetNameDefault) Error() string {
	return fmt.Sprintf("[PUT /resource-manager/2019-12-10/organizations/{id}/name][%d] OrganizationService_SetName default  %+v", o._statusCode, o.Payload)
}

func (o *OrganizationServiceSetNameDefault) String() string {
	return fmt.Sprintf("[PUT /resource-manager/2019-12-10/organizations/{id}/name][%d] OrganizationService_SetName default  %+v", o._statusCode, o.Payload)
}

func (o *OrganizationServiceSetNameDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *OrganizationServiceSetNameDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
