// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package databasemanagement

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListTablespacesRequest wrapper for the ListTablespaces operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/databasemanagement/ListTablespaces.go.html to see an example of how to use ListTablespacesRequest.
type ListTablespacesRequest struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
	ManagedDatabaseId *string `mandatory:"true" contributesTo:"path" name:"managedDatabaseId"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter to return only resources that match the entire name.
	Name *string `mandatory:"false" contributesTo:"query" name:"name"`

	// The field to sort information by. Only one sortOrder can be used. The default sort order
	// for ‘TIMECREATED’ is descending and the default sort order for ‘NAME’ is ascending.
	// The ‘NAME’ sort order is case-sensitive.
	SortBy ListTablespacesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The option to sort information in ascending (‘ASC’) or descending (‘DESC’) order. Ascending order is the default order.
	SortOrder ListTablespacesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The page token representing the page from where the next set of paginated results
	// are retrieved. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The maximum number of records returned in the paginated response.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The OCID of the Named Credential.
	OpcNamedCredentialId *string `mandatory:"false" contributesTo:"header" name:"opc-named-credential-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListTablespacesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListTablespacesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListTablespacesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListTablespacesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListTablespacesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListTablespacesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListTablespacesSortByEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListTablespacesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListTablespacesSortOrderEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListTablespacesResponse wrapper for the ListTablespaces operation
type ListTablespacesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of TablespaceCollection instances
	TablespaceCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListTablespacesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListTablespacesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListTablespacesSortByEnum Enum with underlying type: string
type ListTablespacesSortByEnum string

// Set of constants representing the allowable values for ListTablespacesSortByEnum
const (
	ListTablespacesSortByTimecreated ListTablespacesSortByEnum = "TIMECREATED"
	ListTablespacesSortByName        ListTablespacesSortByEnum = "NAME"
)

var mappingListTablespacesSortByEnum = map[string]ListTablespacesSortByEnum{
	"TIMECREATED": ListTablespacesSortByTimecreated,
	"NAME":        ListTablespacesSortByName,
}

var mappingListTablespacesSortByEnumLowerCase = map[string]ListTablespacesSortByEnum{
	"timecreated": ListTablespacesSortByTimecreated,
	"name":        ListTablespacesSortByName,
}

// GetListTablespacesSortByEnumValues Enumerates the set of values for ListTablespacesSortByEnum
func GetListTablespacesSortByEnumValues() []ListTablespacesSortByEnum {
	values := make([]ListTablespacesSortByEnum, 0)
	for _, v := range mappingListTablespacesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListTablespacesSortByEnumStringValues Enumerates the set of values in String for ListTablespacesSortByEnum
func GetListTablespacesSortByEnumStringValues() []string {
	return []string{
		"TIMECREATED",
		"NAME",
	}
}

// GetMappingListTablespacesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListTablespacesSortByEnum(val string) (ListTablespacesSortByEnum, bool) {
	enum, ok := mappingListTablespacesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListTablespacesSortOrderEnum Enum with underlying type: string
type ListTablespacesSortOrderEnum string

// Set of constants representing the allowable values for ListTablespacesSortOrderEnum
const (
	ListTablespacesSortOrderAsc  ListTablespacesSortOrderEnum = "ASC"
	ListTablespacesSortOrderDesc ListTablespacesSortOrderEnum = "DESC"
)

var mappingListTablespacesSortOrderEnum = map[string]ListTablespacesSortOrderEnum{
	"ASC":  ListTablespacesSortOrderAsc,
	"DESC": ListTablespacesSortOrderDesc,
}

var mappingListTablespacesSortOrderEnumLowerCase = map[string]ListTablespacesSortOrderEnum{
	"asc":  ListTablespacesSortOrderAsc,
	"desc": ListTablespacesSortOrderDesc,
}

// GetListTablespacesSortOrderEnumValues Enumerates the set of values for ListTablespacesSortOrderEnum
func GetListTablespacesSortOrderEnumValues() []ListTablespacesSortOrderEnum {
	values := make([]ListTablespacesSortOrderEnum, 0)
	for _, v := range mappingListTablespacesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListTablespacesSortOrderEnumStringValues Enumerates the set of values in String for ListTablespacesSortOrderEnum
func GetListTablespacesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListTablespacesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListTablespacesSortOrderEnum(val string) (ListTablespacesSortOrderEnum, bool) {
	enum, ok := mappingListTablespacesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
