// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package wlms

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListWlsDomainServersRequest wrapper for the ListWlsDomainServers operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/wlms/ListWlsDomainServers.go.html to see an example of how to use ListWlsDomainServersRequest.
type ListWlsDomainServersRequest struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the WebLogic domain.
	WlsDomainId *string `mandatory:"true" contributesTo:"path" name:"wlsDomainId"`

	// The name of the resource.
	Name *string `mandatory:"false" contributesTo:"query" name:"name"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A token that uniquely identifies a request so it can be retried in case of a timeout or
	// server error without risk of executing that same action again. Retry tokens expire after 24
	// hours, but can be invalidated before then due to conflicting operations. For example, if a resource
	// has been deleted and purged from the system, then a retry of the original creation request
	// might be rejected.
	OpcRetryToken *string `mandatory:"false" contributesTo:"header" name:"opc-retry-token"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token that represents the page at which to start retrieving results. The token is usually retrieved from a previous List call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order is either 'ASC' or 'DESC'.
	SortOrder ListWlsDomainServersSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field by which to sort the resource. Only one sort order may be provided.
	// Default order for _timeCreated_ is **descending**.
	// Default order for _name_ is **ascending**.
	// If no value is specified, _timeCreated_ is default.
	SortBy ListWlsDomainServersSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListWlsDomainServersRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListWlsDomainServersRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListWlsDomainServersRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListWlsDomainServersRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListWlsDomainServersRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListWlsDomainServersSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListWlsDomainServersSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListWlsDomainServersSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListWlsDomainServersSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListWlsDomainServersResponse wrapper for the ListWlsDomainServers operation
type ListWlsDomainServersResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of ServerCollection instances
	ServerCollection `presentIn:"body"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`
}

func (response ListWlsDomainServersResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListWlsDomainServersResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListWlsDomainServersSortOrderEnum Enum with underlying type: string
type ListWlsDomainServersSortOrderEnum string

// Set of constants representing the allowable values for ListWlsDomainServersSortOrderEnum
const (
	ListWlsDomainServersSortOrderAsc  ListWlsDomainServersSortOrderEnum = "ASC"
	ListWlsDomainServersSortOrderDesc ListWlsDomainServersSortOrderEnum = "DESC"
)

var mappingListWlsDomainServersSortOrderEnum = map[string]ListWlsDomainServersSortOrderEnum{
	"ASC":  ListWlsDomainServersSortOrderAsc,
	"DESC": ListWlsDomainServersSortOrderDesc,
}

var mappingListWlsDomainServersSortOrderEnumLowerCase = map[string]ListWlsDomainServersSortOrderEnum{
	"asc":  ListWlsDomainServersSortOrderAsc,
	"desc": ListWlsDomainServersSortOrderDesc,
}

// GetListWlsDomainServersSortOrderEnumValues Enumerates the set of values for ListWlsDomainServersSortOrderEnum
func GetListWlsDomainServersSortOrderEnumValues() []ListWlsDomainServersSortOrderEnum {
	values := make([]ListWlsDomainServersSortOrderEnum, 0)
	for _, v := range mappingListWlsDomainServersSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListWlsDomainServersSortOrderEnumStringValues Enumerates the set of values in String for ListWlsDomainServersSortOrderEnum
func GetListWlsDomainServersSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListWlsDomainServersSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListWlsDomainServersSortOrderEnum(val string) (ListWlsDomainServersSortOrderEnum, bool) {
	enum, ok := mappingListWlsDomainServersSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListWlsDomainServersSortByEnum Enum with underlying type: string
type ListWlsDomainServersSortByEnum string

// Set of constants representing the allowable values for ListWlsDomainServersSortByEnum
const (
	ListWlsDomainServersSortByTimecreated ListWlsDomainServersSortByEnum = "timeCreated"
	ListWlsDomainServersSortByName        ListWlsDomainServersSortByEnum = "name"
)

var mappingListWlsDomainServersSortByEnum = map[string]ListWlsDomainServersSortByEnum{
	"timeCreated": ListWlsDomainServersSortByTimecreated,
	"name":        ListWlsDomainServersSortByName,
}

var mappingListWlsDomainServersSortByEnumLowerCase = map[string]ListWlsDomainServersSortByEnum{
	"timecreated": ListWlsDomainServersSortByTimecreated,
	"name":        ListWlsDomainServersSortByName,
}

// GetListWlsDomainServersSortByEnumValues Enumerates the set of values for ListWlsDomainServersSortByEnum
func GetListWlsDomainServersSortByEnumValues() []ListWlsDomainServersSortByEnum {
	values := make([]ListWlsDomainServersSortByEnum, 0)
	for _, v := range mappingListWlsDomainServersSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListWlsDomainServersSortByEnumStringValues Enumerates the set of values in String for ListWlsDomainServersSortByEnum
func GetListWlsDomainServersSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"name",
	}
}

// GetMappingListWlsDomainServersSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListWlsDomainServersSortByEnum(val string) (ListWlsDomainServersSortByEnum, bool) {
	enum, ok := mappingListWlsDomainServersSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
